/******************************************************************

            Title  : winscard_rpc.x
            Package: PCSC Lite
            Author : David Corcoran
            Date   : 10/24/99
            Purpose: This is a generic interface definition
	             for rpcgen.
            LICENSE: See file LICENSE

********************************************************************/ 

const RPC_MAX_BUFFER_SIZE     = 264;
const RPC_MAX_ATR_SIZE        = 33;
const RPC_MAX_STRING_SIZE     = 255;

typedef long RPC_LPSCARDCONTEXT;
typedef long RPC_SCARDCONTEXT;
typedef long RPC_SCARDHANDLE;
typedef long RPC_LPSCARDHANDLE;
typedef long RPC_LONG;
typedef long RPC_DWORD;
typedef long RPC_LPDWORD;
typedef char RPC_LPCSTR<RPC_MAX_STRING_SIZE>;
typedef char RPC_LPSTR<RPC_MAX_STRING_SIZE>;
typedef char RPC_LPBYTE<RPC_MAX_BUFFER_SIZE>;
typedef char RPC_LPCBYTE<RPC_MAX_BUFFER_SIZE>;

struct RPC_LPCSCARD_IO_REQUEST {
  RPC_DWORD dwProtocol;
  RPC_DWORD cbPciLength;
};

struct RPC_LPSCARD_IO_REQUEST {
  RPC_DWORD dwProtocol;
  RPC_DWORD cbPciLength;
};

struct RPC_LPSCARD_READERSTATE_A {
  RPC_LPCSTR      szReader;
  RPC_DWORD       dwCurrentState;
  RPC_DWORD       dwEventState;
  RPC_DWORD       cbAtr;
  RPC_LPBYTE      rgbAtr;  
};

struct establish_struct {
  RPC_DWORD dwScope; 
  RPC_LPSCARDCONTEXT phContext;
  RPC_LONG rv;
};

struct release_struct {
  RPC_SCARDCONTEXT hContext;
  RPC_LONG rv;
};     

struct connect_struct {
  RPC_SCARDCONTEXT hContext;
  RPC_LPCSTR szReader;
  RPC_DWORD dwShareMode;
  RPC_DWORD dwPreferredProtocols; 
  RPC_LPSCARDHANDLE phCard;
  RPC_LPDWORD pdwActiveProtocol;
  RPC_LONG rv;
};

struct disconnect_struct {
  RPC_SCARDHANDLE hCard;
  RPC_DWORD dwDisposition;
  RPC_LONG rv;
};

struct begin_struct {
  RPC_SCARDHANDLE hCard;
  RPC_LONG rv;
};

struct end_struct {
  RPC_SCARDHANDLE hCard;
  RPC_DWORD dwDisposition;
  RPC_LONG rv;
};

struct cancel_struct {
  RPC_SCARDHANDLE hCard;
  RPC_LONG rv;
};

struct status_struct {
  RPC_SCARDHANDLE hCard;
  RPC_LPSTR mszReaderNames;
  RPC_LPDWORD pcchReaderLen;
  RPC_LPDWORD pdwState;
  RPC_LPDWORD pdwProtocol;
  RPC_LPBYTE pbAtr;
  RPC_LPDWORD pcbAtrLen;
  RPC_LONG rv;
};

struct statuschange_struct {
  RPC_SCARDHANDLE hContext;
  RPC_DWORD dwTimeout;
  RPC_LPSCARD_READERSTATE_A rgReaderStates;
  RPC_DWORD cReaders;
  RPC_LONG rv;
};

struct transmit_struct {
  RPC_SCARDHANDLE hCard;
  RPC_LPCSCARD_IO_REQUEST pioSendPci;
  RPC_LPCBYTE pbSendBuffer;
  RPC_DWORD cbSendLength; 
  RPC_LPSCARD_IO_REQUEST pioRecvPci;
  RPC_LPBYTE pbRecvBuffer;
  RPC_LPDWORD pcbRecvLength;
  RPC_LONG rv;
};

struct cancellock_struct {
  RPC_SCARDCONTEXT hContext;
  RPC_LONG rv;
};

struct list_struct {
  RPC_SCARDCONTEXT hContext;
  RPC_LPCSTR mszGroups;
  RPC_LPSTR mszReaders;
  RPC_LPDWORD pcchReaders;
  RPC_LONG rv;
};

struct read_struct {
  RPC_SCARDHANDLE hCard;
  RPC_DWORD dwCardType;
  RPC_DWORD dwCardSize;
  RPC_DWORD dwAddress;
  RPC_LPBYTE pbBuffer;
  RPC_DWORD dwLength;
  RPC_LONG rv;
};

struct write_struct {
  RPC_SCARDHANDLE hCard;
  RPC_DWORD dwCardType;
  RPC_DWORD dwCardSize;
  RPC_DWORD dwAddress;
  RPC_LPCBYTE pcbBuffer;
  RPC_DWORD dwLength;
  RPC_LONG rv;
};


program DISPLAY_PRG {
	version DISPLAY_VER {

  establish_struct    SCARDESTABLISHCONTEXT( establish_struct )   = 1;
  release_struct      SCARDRELEASECONTEXT( release_struct )       = 2;
  connect_struct      SCARDCONNECT( connect_struct )              = 3;
  disconnect_struct   SCARDDISCONNECT( disconnect_struct )        = 4;
  begin_struct        SCARDBEGINTRANSACTION( begin_struct )       = 5;
  end_struct          SCARDENDTRANSACTION( end_struct )           = 6;
  cancel_struct       SCARDCANCELTRANSACTION( cancel_struct )     = 7;
  status_struct       SCARDSTATUS( status_struct )                = 8;
  statuschange_struct SCARDGETSTATUSCHANGE( statuschange_struct ) = 9;
  transmit_struct     SCARDTRANSMIT( transmit_struct )            = 10;
  cancellock_struct   SCARDCANCEL( cancellock_struct )            = 11;
  list_struct         SCARDLISTREADERS( list_struct )             = 12;
  read_struct         SCARDREADMEMORY( read_struct )              = 13;
  write_struct        SCARDWRITEMEMORY( write_struct )            = 14;

	} = 1;		
} = 0x20000001;	
