/******************************************************************

	MUSCLE SmartCard Development ( http://www.linuxnet.com )
	    Title  : winscard.h
	    Package: pcsc lite
            Author : David Corcoran
            Date   : 7/27/99
            Purpose: This handles smartcard reader communications. 
	            

********************************************************************/

#ifndef __scardcomm_h__
#define __scardcomm_h__

#include <pcsclite.h>

#ifdef __cplusplus
extern "C" {
#endif  

  LONG SCardEstablishContext( DWORD, LPCVOID, LPCVOID, LPSCARDCONTEXT );
  LONG SCardReleaseContext( SCARDCONTEXT );
  LONG SCardSetTimeout( SCARDCONTEXT, DWORD );
  LONG SCardConnect( SCARDCONTEXT, LPCSTR, DWORD, 
                     DWORD, LPSCARDHANDLE, LPDWORD );
  LONG SCardDisconnect( SCARDHANDLE, DWORD );
  LONG SCardBeginTransaction( SCARDHANDLE );
  LONG SCardEndTransaction( SCARDHANDLE, DWORD );
  LONG SCardCancelTransaction( SCARDHANDLE );
  LONG SCardStatus( SCARDHANDLE, LPSTR, LPDWORD, LPDWORD, 
                    LPDWORD, LPBYTE, LPDWORD );
  LONG SCardGetStatusChange( SCARDHANDLE, DWORD, LPSCARD_READERSTATE_A, 
                             DWORD );
  LONG SCardTransmit( SCARDHANDLE, LPCSCARD_IO_REQUEST, LPCBYTE, DWORD,
                      LPSCARD_IO_REQUEST, LPBYTE, LPDWORD ); 
  LONG SCardListReaders( SCARDCONTEXT, LPCSTR, LPSTR, LPDWORD );

  /* The following functions extend the Winscard interface
     for use with memory type storage smart cards.         */

  LONG SCardReadMemory( SCARDHANDLE, DWORD, DWORD, DWORD, LPBYTE, DWORD );
  LONG SCardWriteMemory( SCARDHANDLE, DWORD, DWORD, DWORD, LPCBYTE, DWORD );


#ifdef __cplusplus
}
#endif 
  
#endif
