/******************************************************************

	MUSCLE SmartCard Development ( http://www.linuxnet.com )
	    Title  : readerfactory.h
	    Package: pcsc lite
            Author : David Corcoran
            Date   : 7/27/99
            Purpose: This keeps track of a list of currently 
	             available reader structures.

********************************************************************/

#ifndef __readerlist_h__
#define __readerlist_h__

#include <pcsclite.h>

#ifdef __cplusplus
extern "C" {
#endif  

  struct ReaderContext {
    char  lpcReader[MAX_READERNAME];   /* Reader Name                      */
    char  lpcLibrary[MAX_LIBNAME];     /* Library Path                     */
    LPVOID vHandle;                    /* Dlopen handle                    */
    DWORD dwPort;                      /* Port ID                          */
    DWORD dwProtocol;                  /* Currently used protocol          */
    DWORD dwSlot;                      /* Current Reader Slot              */
    DWORD dwBlockStatus;               /* Current blocking status          */
    DWORD dwStatus;                    /* Current Status Mask              */
    DWORD dwLockId;                    /* Lock Id                          */
    DWORD dwIdentity;                  /* Shared ID High Nibble            */
    DWORD dwContexts;                  /* Number of open contexts          */
  };

  typedef struct ReaderContext READER_CONTEXT, *PREADER_CONTEXT;

  LONG RFAddReader( LPSTR, DWORD, LPSTR );
  LONG RFRemoveReader( LPSTR );
  LONG RFListReaders( LPSTR, LPDWORD );
  LONG RFReaderInfo( LPSTR, struct ReaderContext** );
  LONG RFReaderInfoById( DWORD, struct ReaderContext** );
  LONG RFCheckSharing( DWORD );
  LONG RFLockSharing( DWORD );
  LONG RFUnlockSharing( DWORD );
  LONG RFUnblockContext( SCARDCONTEXT );
  LONG RFLoadReader( LPSTR );
  LONG RFUnloadReader( LPSTR );

#ifdef __cplusplus
}
#endif 
  
#endif
