/******************************************************************

	MUSCLE SmartCard Development ( http://www.linuxnet.com )
	    Title  : pcsclite.h
	    Package: pcsc lite
            Author : David Corcoran
            Date   : 7/27/99
            Purpose: This keeps a list of defines for pcsc lite.
	            

********************************************************************/

#ifndef __pcsclite_h__
#define __pcsclite_h__

#ifdef __cplusplus
extern "C" {
#endif  
  
#ifndef BYTE
  typedef unsigned char                 BYTE;
#endif
  typedef unsigned char                 UCHAR;
  typedef unsigned char*                PUCHAR;
  typedef unsigned short                USHORT;
  typedef unsigned long                 ULONG;
  typedef short                         BOOL;
  typedef unsigned long                 DWORD;
  typedef unsigned long*                PDWORD;
  typedef DWORD                         WORD;
  typedef long                          LONG;
  typedef long                          RESPONSECODE;
  typedef const char *                  LPCSTR;
  typedef LONG                          SCARDCONTEXT;
  typedef SCARDCONTEXT *                PSCARDCONTEXT;
  typedef SCARDCONTEXT *                LPSCARDCONTEXT;
  typedef LONG                          SCARDHANDLE;
  typedef SCARDHANDLE *                 PSCARDHANDLE;
  typedef SCARDHANDLE *                 LPSCARDHANDLE;
  typedef const void *                  LPCVOID;
  typedef void *                        LPVOID;
  typedef const BYTE *                  LPCBYTE;
  typedef BYTE *                        LPBYTE;
  typedef DWORD *                       LPDWORD;
  typedef char *                        LPSTR;
  typedef char *                        LPCWSTR;    

typedef struct {
    LPCSTR      szReader;
    LPVOID      pvUserData;
    DWORD       dwCurrentState;
    DWORD       dwEventState;
    DWORD       cbAtr;
    BYTE        rgbAtr[36];
} SCARD_READERSTATE_A;

typedef SCARD_READERSTATE_A SCARD_READERSTATE, *PSCARD_READERSTATE_A,
        *LPSCARD_READERSTATE_A;

typedef struct _SCARD_IO_REQUEST{
    DWORD   dwProtocol;         /* Protocol identifier                  */
    DWORD   cbPciLength;        /* Protocol Control Information Length  */
} SCARD_IO_REQUEST, *PSCARD_IO_REQUEST, *LPSCARD_IO_REQUEST;

typedef const SCARD_IO_REQUEST *LPCSCARD_IO_REQUEST;
  
extern SCARD_IO_REQUEST g_rgSCardT0Pci, g_rgSCardT1Pci, g_rgSCardRawPci;
  
#define SCARD_PCI_T0  (&g_rgSCardT0Pci)
#define SCARD_PCI_T1  (&g_rgSCardT1Pci)
#define SCARD_PCI_RAW (&g_rgSCardRawPci)

#define SCARD_S_SUCCESS                 0x0001
#define SCARD_E_CANCELLED               0x0002
#define SCARD_E_CANT_DISPOSE            0x0004
#define SCARD_E_INSUFFICIENT_BUFFER     0x0008
#define SCARD_E_INVALID_ATR             0x0010
#define SCARD_E_INVALID_HANDLE          0x0011
#define SCARD_E_INVALID_PARAMETER       0x0012
#define SCARD_E_INVALID_TARGET          0x0014
#define SCARD_E_INVALID_VALUE           0x0018
#define SCARD_E_NO_MEMORY               0x0020
#define SCARD_F_COMM_ERROR              0x0021
#define SCARD_F_INTERNAL_ERROR          0x0022
#define SCARD_F_UNKNOWN_ERROR           0x0024
#define SCARD_F_WAITED_TOO_LONG         0x0028
#define SCARD_E_UNKNOWN_READER          0x0100
#define SCARD_E_TIMEOUT                 0x0101
#define SCARD_E_SHARING_VIOLATION       0x0102  
#define SCARD_E_NO_SMARTCARD            0x0104 
#define SCARD_E_UNKNOWN_CARD            0x0108
#define SCARD_E_PROTO_MISMATCH          0x0110 
#define SCARD_E_NOT_READY               0x0111
#define SCARD_E_SYSTEM_CANCELLED        0x0112
#define SCARD_E_NOT_TRANSACTED          0x0114
#define SCARD_E_READER_UNAVAILABLE      0x0118

#define SCARD_W_UNSUPPORTED_CARD        0x0120
#define SCARD_W_UNRESPONSIVE_CARD       0x0121
#define SCARD_W_UNPOWERED_CARD          0x0122
#define SCARD_W_RESET_CARD              0x0124
#define SCARD_W_REMOVED_CARD            0x0128
#define SCARD_W_INSERTED_CARD           0x0132

#define SCARD_E_UNSUPPORTED_FEATURE     0x0141
#define SCARD_E_PCI_TOO_SMALL           0x0188
#define SCARD_E_READER_UNSUPPORTED      0x0200
#define SCARD_E_DUPLICATE_READER        0x0201
#define SCARD_E_CARD_UNSUPPORTED        0x0202
#define SCARD_E_NO_SERVICE              0x0204
#define SCARD_E_SERVICE_STOPPED         0x0208


#define SCARD_SCOPE_USER                0x0000  /* Scope in user space */
#define SCARD_SCOPE_TERMINAL            0x0001  /* Scope in terminal   */
#define SCARD_SCOPE_SYSTEM              0x0002  /* Scope in system     */
#define SCARD_SCOPE_GLOBAL              0x0003  /* Scope is global     */

#define SCARD_PROTOCOL_T0               0x0001  /* T=0 active protocol. */
#define SCARD_PROTOCOL_T1               0x0002  /* T=1 active protocol. */
#define SCARD_PROTOCOL_RAW              0x0004  /* Raw active protocol. */
#define SCARD_IGNORE_CARD		0x0004  /* Ignore card-extended */

#define SCARD_SHARE_EXCLUSIVE           0x0001  /* Exclusive mode only  */
#define SCARD_SHARE_SHARED              0x0002  /* Shared mode only     */
#define SCARD_SHARE_DIRECT              0x0003  /* Raw mode only        */

#define SCARD_LEAVE_CARD                0x0000  /* Do nothing on close  */
#define SCARD_RESET_CARD                0x0001  /* Reset on close       */
#define SCARD_UNPOWER_CARD              0x0002  /* Power down on close  */
#define SCARD_EJECT_CARD                0x0003  /* Eject on close       */  

#define SCARD_UNKNOWN                   0x0001  /* Unknown state        */   
#define SCARD_ABSENT                    0x0002  /* Card is absent       */
#define SCARD_PRESENT                   0x0004  /* Card is present      */
#define SCARD_SWALLOWED                 0x0008  /* Card not powered     */
#define SCARD_POWERED                   0x0010  /* Card is powered      */
#define SCARD_NEGOTIABLEMODE            0x0020  /* Ready for PTS        */
#define SCARD_SPECIFICMODE              0x0040  /* PTS has been set     */

#define SCARD_STATE_UNAWARE		0x0000  /* App wants status     */
#define SCARD_STATE_IGNORE              0x0001  /* Ignore this reader   */
#define SCARD_STATE_CHANGED             0x0002  /* State has changed    */
#define SCARD_STATE_UNKNOWN		0x0004  /* Reader unknown       */
#define SCARD_STATE_UNAVAILABLE         0x0008  /* Status unavailable   */
#define SCARD_STATE_EMPTY	        0x0010  /* Card removed         */
#define SCARD_STATE_PRESENT		0x0020  /* Card inserted        */
#define SCARD_STATE_ATRMATCH         	0x0040  /* ATR matches card 	*/
#define SCARD_STATE_EXCLUSIVE      	0x0080  /* Exclusive Mode       */
#define SCARD_STATE_INUSE               0x0100  /* Shared Mode          */
#define SCARD_STATE_MUTE                0x0200  /* Unresponsive card    */

#define SCARD_TYPE_I2C                  0x0001  /* Card is an I2C type  */
#define SCARD_TYPE_2WIRE                0x0002  /* Card is a 2 wire     */
#define SCARD_TYPE_3WIRE                0x0003  /* Card is a 3 wire     */

#define BLOCK_STATUS_RESUME             0x00FF  /* Normal resume        */
#define BLOCK_STATUS_BLOCKING           0x00FA  /* Function is blocking */

#define PCSCLITE_READER_CONFIG		"/etc/reader.conf"
#define PCSCLITE_CARD_CONFIG		"/etc/card.conf"

#define PCSCLITE_MAX_CHANNELS           16      /* Maximum channels     */
#define PCSCLITE_MAX_CONTEXTS           16      /* Maximum readers      */
#define PCSCLITE_STATUS_WAIT		600     /* Status Change Sleep  */
#define MAX_ATR_SIZE                    33      /* Maximum ATR size     */
#define MAX_BUFFER_SIZE                 264     /* Maximum Tx/Rx Buffer */
#define MAX_READERNAME			50      /* 50 char Reader Name  */
#define MAX_LIBNAME			100     /* 100 char Lib Name    */

#ifdef __cplusplus
}
#endif 

#endif

