/******************************************************************

            Title  : ifdwrapper.h
            Package: PC/SC Lite
            Author : David Corcoran
            Date   : 10/08/99
            Purpose: This wraps the dynamic ifdhandler functions.
	             This abstraction will eventually allow multiple card
	             slots in the same terminal.
            LICENSE: See LICENSE

********************************************************************/

#ifndef __ifdwrapper_h__
#define __ifdwrapper_h__

#include <readerfactory.h>
#include <ifdhandler.h>
#include <pcsclite.h>

#ifdef __cplusplus
extern "C" {
#endif  

  LONG IFDOpenIFD(   PREADER_CONTEXT, DWORD );
  LONG IFDCloseIFD(  PREADER_CONTEXT );
  LONG IFDPowerICC(  PREADER_CONTEXT, DWORD, PUCHAR, PDWORD );
  LONG IFDStatusICC( PREADER_CONTEXT, PDWORD, PDWORD, PUCHAR, PDWORD );
  LONG IFDActionICC( PREADER_CONTEXT, DWORD );
  LONG IFDTransmit(  PREADER_CONTEXT, struct SCARD_IO_HEADER,
		     PUCHAR, DWORD, PUCHAR, PDWORD, struct SCARD_IO_HEADER* );
  LONG IFDSetPTS(    PREADER_CONTEXT, DWORD, UCHAR, UCHAR, 
		     UCHAR, UCHAR );
  LONG IFDReadICC(   PREADER_CONTEXT, DWORD, DWORD, 
		     DWORD, PUCHAR, DWORD );
  LONG IFDWriteICC(  PREADER_CONTEXT, DWORD, DWORD, 
		     DWORD, PUCHAR, DWORD );

  LONG IFDSetCapabilities( PREADER_CONTEXT, DWORD, PUCHAR );

#ifdef __cplusplus
}
#endif  

#endif /* __ifdwrapper_h__ */
