/* Title  : Tester for PC/SC Lite
   Author : David Corcoran
   Purpose: Waits for card insertion, then 
            connects and queries random
            generator if exists.
*/

#include <stdio.h>
#include <winscard.h>
#include <configfile.h>

SCARDCONTEXT hContext;
SCARD_READERSTATE_A rgReaderStates;

void waitinsertion( );

void waitinsertion( ) {
  printf("Status before %d\n", rgReaderStates.dwCurrentState);
  SCardGetStatusChange( hContext, 0, &rgReaderStates, 1 );
  printf("Status after %d\n", rgReaderStates.dwEventState);
}


int main( int argc, char **argv ) {
  SCARDHANDLE hCard;
  struct ReaderContext *rContext;
  SCARD_IO_REQUEST sSendPci, sRecvPci;
  DWORD dwReaderLen, dwState, dwProt, dwAtrLen;
  DWORD dwSendLength, dwRecvLength, dwPref, dwReaders;
  LPSTR pcReaders, mszReaders;
  BYTE pbAtr[MAX_ATR_SIZE];
  BYTE s[7], r[20];
  LPCSTR mszGroups;
  LONG rv;
  int i, p, iReader, Pid;
  int iList[16];
  char c;

  printf("\nWinscard PC/SC Lite Test Program\n\n");

  printf("Testing SCardEstablishContext \n");
  SCardEstablishContext( SCARD_SCOPE_SYSTEM, NULL, NULL, &hContext );

  printf("Testing SCardListReaders \n");

  mszGroups = 0;
  SCardListReaders( hContext, mszGroups, 0, &dwReaders );
  mszReaders = (char *)malloc(sizeof(char)*dwReaders);
  printf("Allocated %d space for readers\n", dwReaders);
  SCardListReaders( hContext, mszGroups, mszReaders, &dwReaders );

  /* Have to understand the multi-string here */
  p = 0;
  for ( i=0; i < dwReaders - 1; i++ ) {
    ++p;
    printf("Reader %02d: %s\n", p, &mszReaders[i]);
    iList[p] = i;
    while ( mszReaders[++i] != 0 );
  } 

  do {
    printf("Enter the desired reader number : " );
    scanf("%d", &iReader);
    printf("\n");

    if ( iReader > p || iReader <= 0 ) {
      printf("Invalid Value - try again\n");
    }
  } while ( iReader > p || iReader <= 0 );

  rgReaderStates.szReader       = &mszReaders[iList[iReader]];
  rgReaderStates.dwCurrentState = SCARD_STATE_EMPTY;


  Pid = fork();

  if ( Pid > 0 ) {
    /* Parent */
    
    printf("Press 'Y' then <ENTER> to unblock GetStatusChange\n");
    scanf("%d", &iReader);
    
    printf("Cancelling the pending operation\n");
    SCardCancel( hContext );
    
    printf("Testing SCardReleaseContext \n");
    SCardReleaseContext( hContext );
    
  } else {
    waitinsertion();
    return 0;
  }
  
}
