/*****************************************************************
/
/ File   :   configfile.ll
/ Author :   David Corcoran
/ Date   :   February 12, 1999 modified 7/28/99
/ Purpose:   Reads lexical config files and updates database.
/            See http://www.linuxnet.com for more information.
/ License:   See file LICENSE
/
******************************************************************/

%{
void evaluatetoken( char *pcToken );
int iLinenumber = 1;
char *pcPrevious;
char *pcCurrent;

char *pcFriendlyname;
char *pcDevicename;
char *pcLibpath;
char *pcChannelid;

void error ( char *pcToken_error );

%}

%%

#.*                                       {}
"\n"                                      { iLinenumber++; }
(\"[^"\n]*["\n])|(\'[^'\n]*['\n])         { evaluatetoken( yytext); } 
[ \t]                     {}
([A-Z]|[a-z]|[0-9]|[\\\/\-\.\_])+         { evaluatetoken( yytext ); } 
.                                         { error( yytext ); }
%%

#include <stdio.h>
#include <string.h>
#include <readerfactory.h>

void evaluatetoken( char *pcToken ) {

  DWORD dwChannelId;
  int p = 0;
  int n = 0;

  if ( pcPrevious == 0 ) {       /* This is the key */
    pcPrevious = strdup( pcToken );
  } else {
    pcCurrent = pcToken;
    if ( strcmp( pcPrevious, "FRIENDLYNAME" ) == 0 ) {
       if ( pcFriendlyname == 0 ) {
         pcFriendlyname = (char *)malloc(strlen(pcCurrent)-1);
         for ( n = 0; n < strlen(pcCurrent); n++ ) {
           if ( pcCurrent[n] != '"' ) { /* Strip off the quotes */
             pcFriendlyname[p++] = pcCurrent[n];         
           }
         }
         pcFriendlyname[p++] = 0;
       } else {
         error( pcPrevious ); exit(1);
       }
    } else if ( strcmp( pcPrevious, "DEVICENAME" ) == 0 ) {
       if ( pcDevicename == 0 ) {
         pcDevicename = strdup( pcCurrent );
       } else {
         error( pcPrevious ); exit(1);
       }
    } else if ( strcmp( pcPrevious, "LIBPATH" ) == 0 ) {
       if ( pcLibpath == 0 ) {
         pcLibpath = strdup( pcCurrent );
       } else {
         error( pcPrevious ); exit(1);
       }
    } else if ( strcmp( pcPrevious, "CHANNELID" ) == 0 ) {
       if ( pcChannelid == 0 ) {
         pcChannelid = strdup( pcCurrent );
       } else {
         error( pcPrevious ); exit(1);
       }
    } else {
       error( pcPrevious ); exit(1);
    }

    free( pcPrevious ); pcPrevious = 0;
  }

  if ( pcFriendlyname != 0 && pcDevicename != 0 &&
       pcLibpath != 0 && pcChannelid != 0 ) {
     
       dwChannelId = strtoul( pcChannelid, 0, 16 );
       RFAddReader( pcFriendlyname, dwChannelId, pcLibpath );

       free( pcFriendlyname ); free( pcDevicename );
       free( pcLibpath);       free( pcChannelid );
       pcFriendlyname = 0; pcDevicename = 0;
       pcLibpath      = 0; pcChannelid  = 0;
  }
}

void error ( char *token_error ) {
  printf("pcsc-manager::Invalid ID (%s) on line %d.\n", 
          token_error, iLinenumber );
}

int DBUpdateReaders ( char *readerconf ) {

  FILE *file;
  file = fopen( readerconf, "r");

  if (!file) {
    fprintf(stderr, "Couldn't open config file %s.\n", readerconf);
    exit(1);
  }

  yyin = file;

  do {
    yylex();
  }
  while (!feof(file));

  fclose(file);

} /* End of configfile.c */
