/*
 * Secure beam, using smart card for encryption.
 * Smart card interface routines.
 *
 * Jim Rees, University of Michigan, July 2000
 */

#ifdef __palmos__
#pragma pack(2)

#if (__GNUC_MINOR__ > 7)
#include <PalmOS.h>
#else
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif
#include <System/DateTime.h>
#include <System/MemoryMgr.h>
#include <System/DataMgr.h>
#include <System/SysEvtMgr.h>

#include <System/Unix/sys_types.h>
#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#if (__GNUC_MINOR__ > 7)
#include <System/Unix/unix_string.h>
#else
#include <string.h>
#endif

#include "field.h"
#include "resource.h"
#define TTYN 0
#else /* __palmos__ */
#include <stdio.h>
#ifndef TTYN
#define TTYN 1
#endif
#endif /* __palmos__ */

#include "scrw.h"
#include "addr.h"
#include "secb.h"

#define ENCFLAGS 0x00040001

static int fd = -1;

do_des(int ins, unsigned char *p0, unsigned char *p1)
{
    int n, len, r1, r2;

    if (!openreader()) {
	printf("Can't open reader\n");
	return -1;
    }

    len = (curreclen <= 255) ? curreclen : 255;

    n = scrw(fd, 4, ins, 0, 0, len, p0, (len + 7) & ~7, p1, &r1, &r2);
    closereader();

    if (n <= 0 || r1 != 0x90) {
	printf("read %d status %s\n", n, get_r1r2s(r1, r2));
	return -1;
    }
    curreclen = n;
    return n;
}

encrec()
{
    /*
     * Make up an address rec with last name " ***" and the encrypted data
     * attached as a note
     */
    if (do_des(0xe, (unsigned char *) currecptr, (unsigned char *) currecptr + SECHDRLEN) < 0)
	return;
    currecptr->p = 0x15043210;
    currecptr->f = ENCFLAGS;
    bcopy("\0 ***\0", currecptr->s, 6);
    curreclen += SECHDRLEN;
    displayrec();
}

decrec()
{
    if (currecptr->f != ENCFLAGS) {
	printf("record is not encrypted\n");
	return;
    }
    curreclen -= SECHDRLEN;
    if (do_des(0x10, (unsigned char *) currecptr + SECHDRLEN, (unsigned char *) currecptr) < 0)
	return;
    displayrec();
}

displayrec()
{
    int i, j, nrows;
    unsigned char c, *p;
    char buf[34];

#ifdef __palmos__
    hidefield(fieldID_rec);
    setfield(printfield, NULL);
#endif

    p = (unsigned char *) currecptr;
    nrows = (curreclen + 7) / 8;

    for (i = 0; i < nrows; i++) {
	for (j = 0; j < 8; j++)
	    sprintf(&buf[j*3], "%02x ", p[j]);
	for (j = 0; j < 8; j++) {
	    c = p[j];
	    if ((c >= ' ' && c <= '~') || (c >= 160 && c <= 255))
		buf[24+j] = c;
	    else
		buf[24+j] = '.';
	}
	buf[32] = '\0';
	printf("%s\n", buf);
	p += 8;
    }

#ifdef __palmos__
    FldSetScrollPosition(printfield, 0);
    showfield(fieldID_rec);
#endif
    return 0;
}

openreader()
{
    if (fd < 0)
	fd = scopen(TTYN, 0, NULL);
    if (fd < 0 || !screset(fd, NULL, NULL)) {
	closereader();
	return 0;
    }
    return 1;
}

closereader()
{
    if (fd >= 0) {
	scclose(fd);
	fd = -1;
    }
}

#ifdef TEST
int currecno, curreclen;
struct addr *currecptr;

main()
{
    static char s[100] = "this is my plaintext message for testing.";

    currecptr = (struct addr *) s;
    curreclen = strlen(s);
    printf("Plain:\n");
    displayrec();
    printf("Encrypted:\n");
    encrec();
    printf("Decrypted:\n");
    decrec();
    exit(0);
}
#endif

/*
copyright 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
