// Copyright (c) 2000
// The Regents of The University of Michigan
// All rights reserved
// Written by Jim Rees July 2000

import javacard.framework.*;
import javacardx.framework.*;
import javacardx.crypto.*;

public class secbdes extends javacard.framework.Applet {
    final byte secb_CLA = (byte) 0x04;
    final byte Encrypt = (byte) 0x0e;
    final byte Decrypt = (byte) 0x10;
    final byte GetResponse = (byte) 0xc0;

    byte IV[];

    DES_Key deskey;

    private secbdes() {
	deskey = new DES_Key((short)1);
	IV = new byte[64];
	deskey.setICV(IV, (short)0);
	deskey.clearICV();
	register();
    }

    public static void install(APDU apdu) {
	new secbdes();
    }

    public boolean select() {
	return true;
    }

    public static void main(String args[]) {
	ISOException.throwIt((short) 0x7264);
    }

    public void process(APDU apdu) {
	short len, status = ISO.SW_NO_ERROR;
	byte b[] = apdu.getBuffer();

	// Check cla & ins
	if (b[ISO.OFFSET_CLA] != secb_CLA) {
	    if (b[ISO.OFFSET_INS] == ISO.INS_SELECT) {
		if (b[ISO.OFFSET_P1] != 4)
		    status = ISO.SW_WRONG_P1P2;
	    } else if (b[ISO.OFFSET_INS] != GetResponse)
		status = ISO.SW_CLA_NOT_SUPPORTED;
	}
	if (status != ISO.SW_NO_ERROR)
	    ISOException.throwIt(status);

	switch (b[ISO.OFFSET_INS]) {
	case ISO.INS_SELECT:
	case GetResponse:
	    break;
	case Encrypt:
	    len = apdu.setIncomingAndReceive();
	    while (len % (short)8 != 0)
		b[(short)ISO.OFFSET_CDATA + len++] = (short)0;
	    deskey.encryptCBC(b, (short)ISO.OFFSET_CDATA, len, b, (short)ISO.OFFSET_CDATA);
	    apdu.setOutgoingAndSend((short)ISO.OFFSET_CDATA, len);
	    break;
	case Decrypt:
	    len = apdu.setIncomingAndReceive();
	    deskey.decryptCBC(b, (short)ISO.OFFSET_CDATA, len, b, (short)ISO.OFFSET_CDATA);
	    apdu.setOutgoingAndSend((short)ISO.OFFSET_CDATA, len);
	    break;
	default:
	    status = ISO.SW_INS_NOT_SUPPORTED;
	}

	if (status != ISO.SW_NO_ERROR)
	    ISOException.throwIt(status);
    }
}
