/*
 * Cyberflex stuff for lewis.
 *
 * Jim Rees, University of Michigan, September 1999
 */
static char *rcsid = "$Id: cyber.c,v 1.7 2000/05/11 20:45:03 rees Exp $";

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <System/SysEvtMgr.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/sys_types.h>
#include <string.h>

#include "lewis.h"
#include "scrw.h"
#include "field.h"

/* This will pull in the clib sprintf instead of using the crippled Pilot rom one */
#undef sprintf
#undef vsprintf

#define MAXFILES 32

#define myisprint(x) ((x) >= '!' && (x) <= 'z')

extern int		fd, testmode;
int			cyber_cla = 0;
static char		AUT0[] = {0xad, 0x9f, 0x61, 0xfe, 0xfa, 0x20, 0xce, 0x63};

char *apptype[] = {
    "?",
    "applet",
    "app",
    "app/applet",
};

char *appstat[] = {
    "?",
    "created",
    "installed",
    "registered",
};

char *filestruct[] = {
    "binary",
    "fixed rec",
    "variable rec",
    "cyclic",
    "program",
};

static int nfiles;
static int cdf0, cdf1; /* current directory fid */
static struct {
    int i;
    unsigned char f0, f1;
} itab[MAXFILES];

initcyberform(FormPtr form)
{
    int	r1, r2;
    unsigned char buf[22];

    printfield = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_cylist));
    FrmDrawForm(form);

    /* determine cyberflex access class: 00 or F0 */
    if (fd >= 0 && scread(fd, 0xf0, 0xca, 0, 1, sizeof buf, buf, &r1, &r2) >= 0 && r1 == 0x90)
	cyber_cla = 0xf0;

    cybercmd(buttonID_cyls);
}

cybercmd(id)
int id;
{
    int code = 1;

    switch (id) {
    case buttonID_cyls:
	/* cd to "/" */
	cdf0 = 0x3f;
	cdf1 = 0;
	/* fall through */
    case buttonID_cyop:
	cyberflex_open(fd);
	break;
    case buttonID_cyok:
	cyber_cla = 0;
	FrmGotoForm(formID_lewis);
	break;
    default:
	code = 0;
	break;
    }
    return code;
}

cyberflex_explore(int fd)
{
    int p2, f0, f1, r1, r2;
    unsigned char buf[64];
    char ftype[32], fname[6];

    setfield(printfield, NULL);

    for (nfiles = p2 = 0; ; p2++) {
	if (scread(fd, cyber_cla, 0xa8, 0, p2, 40, buf, &r1, &r2) < 0)
	    break;
	if (r1 != 0x90)
	    break;
	f0 = buf[4];
	f1 = buf[5];
	if (f0 == 0xff || f0 + f1 == 0)
	    continue;
	if (myisprint(f0) && myisprint(f1))
	    sprintf(fname, "%c%c", f0, f1);
	else
	    sprintf(fname, "%2x.%02x", f0, f1);
	if (buf[6] == 1)
	    /* root */
	    sprintf(ftype, "root");
	else if (buf[6] == 2) {
	    /* DF */
	    if (buf[12] == 27)
		sprintf(ftype, "%s %s", appstat[buf[10]], apptype[buf[9]]);
	    else
		sprintf(ftype, "directory");
	} else if (buf[6] == 4)
	    /* EF */
	    sprintf(ftype, "%s", filestruct[buf[13]]);
	itab[nfiles].i = FldGetTextLength(printfield);
	itab[nfiles].f0 = f0;
	itab[nfiles++].f1 = f1;
	printf("%5s %5d %s\n", fname, (buf[2] << 8) | buf[3], ftype);
    }
}

getmsgidx()
{
    int i, ipt, mypt = -1, myi = 0;

    ipt = FldGetInsPtPosition(printfield);
    for (i = 0; i < nfiles; i++)
	if (itab[i].i > mypt && itab[i].i <= ipt) {
	    mypt = itab[i].i;
	    myi = i;
	}
    return myi;
}

cyberflex_open(int fd)
{
    int i, k, len, rlen, r1, r2;
    unsigned char buf[256];

    if (fd < 0) {
	printf("reader not open\n");
	return;
    }

    if (cdf0 == 0 && cdf1 == 0) {
	/* If there is no current directory, find out which file name cursor is on */
	i = getmsgidx();
	buf[0] = itab[i].f0;
	buf[1] = itab[i].f1;
    } else {
	/* Else we're opening the current directory */
	buf[0] = cdf0;
	buf[1] = cdf1;
    }

    /* Erase the screen */
    setfield(printfield, NULL);

    /* Select the fid */
    if (scwrite(fd, cyber_cla, 0xa4, 0, 0, 2, buf, &r1, &r2) < 0 || r1 != 0x61) {
	printf("select %x.%02x failed\n", buf[0], buf[1]);
	printf("class: %x\n", cyber_cla );
	return;
    }

    /* Get response */
    if (scread(fd, cyber_cla, 0xc0, 0, 0, r2, buf, &r1, &r2) < 0 || r1 != 0x90) {
	printf("get response failed\n");
	return;
    }
    len = (buf[2] << 8) | buf[3];

    if (buf[6] == 4) {
	/* EF. Read bits, write to screen */
	cdf0 = buf[0];
	cdf1 = buf[1];
	for (k = 0; k < len; ) {
	    rlen = (len - k < 248) ? (len - k) : 248;
	    i = scread(fd, cyber_cla, 0xb0, (k >> 8) & 0xff, k & 0xff, rlen, buf, &r1, &r2);
	    if (i <= 0)
		break;
	    buf[i] = '\0';
	    putscrollfield(printfield, buf, 0);
	    k += i;
	}
    } else {
	/* DF. ls it */
	cyberflex_explore(fd);
	cdf0 = cdf1 = 0;
    }
}

/*
copyright 1999, 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
