/*
 * translate doggy doo into something useful
 * -A try to print ascii instead of hex
 *
 * Jim Rees, University of Michigan, April 1998
 */

#ifdef __palmos__
#pragma pack(2)
#include <Common.h>
#include <System/SysAll.h>
#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/sys_types.h>
#else
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#endif
#include <scrw.h>

#ifdef __palmos__
#define printf palmprintf
#endif

int Aflag;
int money, updates;

char *inouttab[] = {
    "in", "out", "?"
};

unsigned char *gbuf;
int gi, gn, gmax;

#ifndef __palmos__
main(ac, av)
int ac;
char *av[];
{
    int i;

    while ((i = getopt(ac, av, "Avx")) != -1) {
	switch (i) {
	case 'A':
	    Aflag = 1;
	    break;
	}
    }

    initbuf();
    compost();

    exit(0);
}

initbuf()
{
    int b;

    if (!gbuf) {
	gbuf = malloc(10 * 1024);
	while (scanf("%2x", &b) == 1)
	    gbuf[gn++] = b;
    }
}
#endif

compost()
{
    int n, T;
    struct scparam param;

    gi = 0;

    while (gi < gn - 2 && gbuf[gi] == 0x3 || gbuf[gi] == 0x3b || gbuf[gi] == 0x3f) {
	n = parse_atr(0, (SCRV | SCRLEN | SCRTODOS), &gbuf[gi], 33, &param);
	if (n < 0)
	    return;
	gi += n;
    }

    T = param.t;
    if (T == 0)
	parse_T0();
    else if (T == 1)
	parse_T1();
    else if (T != -1)
	printf("can't parse T=%d\n", T);
}

parse_T0()
{
    int i, n, class, ins, p1, p2, p3, ack, ackxins, sw1, sw2;
    unsigned char *bp, buf[256];

    while ((class = getbyte()) != -1) {
	ins = getbyte();
	p1 = getbyte();
	p2 = getbyte();
	p3 = getbyte();
	n = 0;
	bp = buf;
	while (1) {
	    /* read ack byte; see 7816-3 8.2.2 */
	    ack = getbyte();
	    if (ack == 0x60) {
		/* null (no-op but resets timer) */
		continue;
	    } else if ((ack & 0xf0) == 0x60 || (ack & 0xf0) == 0x90) {
		/* SW1; get SW2 and return */
		sw1 = ack;
		sw2 = getbyte();
		break;
	    } else if (ack < 0) {
		printf("EOF\n");
		break;
	    } else {
		ackxins = (ack ^ ins) & 0xfe;
		if (ackxins == 0xfe) {
		    /* xfer next data byte */
		    *bp++ = getbyte();
		    n++;
		} else if (ackxins == 0) {
		    /* xfer all remaining data bytes */
		    while (n < p3) {
			*bp++ = getbyte();
			n++;
		    }
		} else {
		    /* ?? unknown ack byte */
		    printf("unknown ack %x\n", ack);
		    continue;
		}
	    }
	}
	if (ack < 0)
	    break;
	printf("%s %x %x %d:", lookup_cmdname(ins), p1, p2, p3);
	for (i = 0; i < p3; i++) {
	    if (Aflag && buf[i] >= ' ' && buf[i] <= '~')
		printf(" %c", buf[i]);
	    else
		printf(" %02x", buf[i]);
	}
	printf(" %s\n", get_r1r2s(sw1, sw2));
    }
}

parse_T1()
{
    int i, c, nad, pcb, len, edc;
    static int lastpcb = 0x40;
    unsigned char buf[256];
    char *s;

    while (1) {
	edc = 0;
	nad = getbyte();
	if (nad < 0)
	    break;
	edc ^= nad;
	pcb = getbyte(); edc ^= pcb;
	len = getbyte(); edc ^= len;
	for (i = 0; i < len; i++) {
	    buf[i] = getbyte();
	    edc ^= buf[i];
	}
	c = getbyte();
	if (c != edc)
	    printf("edc mismatch, %02x != %02x\n", c, edc);
	if (len >= 5 && (pcb & ~0x40) == 0 && lastpcb != pcb) {
	    printf("cla %x ins %x %s p1=%x p2=%x p3=%x\n",
		   buf[0], buf[1], lookup_cmdname(buf[1]), buf[2], buf[3], buf[4]);
	    if (len > 5)
		dump_bytes(&buf[5], buf[4]);
	} else {
	    printf("%d:", len);
	    dump_bytes(buf, len);
	    if (len >= 2)
		printf("%s\n", get_r1r2s(buf[len-2], buf[len-1]));
	}
	lastpcb = pcb;
    }
}

getbyte()
{
    return ((gi < gn) ? gbuf[gi++] : -1);
}

dump_bytes(buf, len)
unsigned char *buf;
int len;
{
    int i;

    for (i = 0; i < len; i++)
	printf(" %02x", buf[i]);
    printf("\n");
}

/*
copyright 1998
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
