#include <Pilot.h>				
#include <UI/UIAll.h>
#include <CharAttr.h>
#include <SysEvtMgr.h>
#include <SysAll.h>

#include "decard.h"
#include "scrw.h"
#include "field.h"

#ifdef __GNUC__
#include "callback.h"
#endif __GNUC__

int fd = -1;

struct {
    unsigned long phonebits, addrbits;
    char s[1000];
} a;
/*    0x00043210, 0xb, "\000Frank\000Randy\000555-1212\000"*/

struct {
    char *l, *v;
} f[] = {
    "Last name", NULL,
    "First name", NULL,
    "Company", NULL,
    "Work", NULL,
    "Home", NULL,
    "Fax", NULL,
    "Other", NULL,
    "Email", NULL,
    "Address", NULL,
    "City", NULL,
    "State", NULL,
    "Zip", NULL,
    "Country", NULL,
    "Title", NULL,
    "Custom 1", NULL,
    "Custom 2", NULL,
    "Custom 3", NULL,
    "Custom 4", NULL,
    "Note", NULL,
    NULL, NULL,
};

char d[1024];

InitField()
{
    int i;

    /* Initialize field array */
    for (i = 0; f[i].l; i++)
	f[i].v = NULL;
}

PrintField()
{
    int i;

    /* Print it to the screen */
    for (i = 0; f[i].l; i++)
	if (f[i].v)
	    printf("%s: %s\n", f[i].l, f[i].v);
}

trim(int ix, int p0, int len)
{
    char *p = &d[p0];
    char *q = p + len - 1;

    *q-- = '\0';
    while (q >= p && *q == ' ')
	*q-- = '\0';
    f[ix].v = p;
}

    Int
GetCardInfo()
{
    int n, serno, r1, r2;
    unsigned char buf[8];
    static char phonebuf[16];
    static unsigned char aid[] = {0xa0, 0x00, 0x00, 0x00, 0x40, 0x01, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};

    InitField();

#if 0
    /* For demo purposes, get the card serial number and use it as phone no. */

    /* open 0.2 */
    if (open_file(fd, 0, 2) < 0)
	return;

    if ((n = scread(fd, 0, 0xb2, 0, 0, 8, buf, &r1, &r2)) != 8 || r1 != 0x90) {
	printf("read %d: %s\n", n, get_r1r2s(r1, r2));
	return;
    }

    sprintf(phonebuf, "%d", (buf[2] << 8 | buf[3]));

    f[0].v = "Frank";
    f[1].v = "Randy";
    f[3].v = phonebuf;
#else
    scwrite(fd, 0, 0xa4, 4, 0xc, sizeof aid, aid, &r1, &r2);
    buf[0] = 0x04;
    buf[1] = 0x3e;
    scwrite(fd, 0, 0xa4, 2, 0xc, 0x2, buf, &r1, &r2);
    scread(fd, 0, 0xb0, 0,   0, 128, &d[000], &r1, &r2);
    scread(fd, 0, 0xb0, 0, 128, 128, &d[128], &r1, &r2);
    scread(fd, 0, 0xb0, 1,   0, 128, &d[256], &r1, &r2);

    trim(0, 13, 20);
    trim(1, 33, 15);
    trim(2, 48, 50);
    trim(8, 98, 50);
    trim(9, 148, 25);
    phonebuf[0] = d[173];
    phonebuf[1] = d[174];
    phonebuf[2] = '\0';
    f[10].v = phonebuf;
    trim(11, 175, 6);
    trim(3, 205, 20);
    trim(5, 228, 15);
    trim(7, 245, 32);
    trim(13, 299, 32);
#endif

    PrintField();
}

open_file(fd, f0, f1)
int fd, f0, f1;
{
    char buf[2];
    int len, r1, r2;

    buf[0] = f0;
    buf[1] = f1;
    len = scwrite(fd, 0, 0xa4, 0, 0, 2, buf, &r1, &r2);
    if (len != 2 || (r1 != 0x90 && r1 != 0x61)) {
	printf("open->scwrite %d %s\n", len, get_r1r2s(r1, r2));
	return -1;
    }
    return 0;
}

DoReap()
{
    if (!openreader()) {
	printf("can't open reader\n");
	return -1;
    }
    if (!screset(fd, NULL, NULL)) {
	printf("can't reset card\n");
	closereader();
	return -1;
    }

    GetCardInfo();

    closereader();
    return 0;
}

Int
compar(void *r1, void *r2, Int other, SortRecordInfoPtr r1s, SortRecordInfoPtr r2s, VoidHand ah)
{
    return strcasecmp((char *) r1 + 9, (char *) r2 + 9);
}

DoSow()
{
    DmOpenRef DB;
    UInt index;
    VoidHand RecHandle;
    Ptr RecPointer;
    int i, len;
    char *p;

    /* See if we have anything */
    if (!f[0].v && !f[1].v) {
	printf("Nothing to add\n");
	return;
    }

    /* Initialize addrrec */
    a.phonebits = 0x00043210;
    a.addrbits = 0;
    a.s[0] = '\0';
    p = &a.s[1];

    /* Copy field to addrrec */
    for (i = 0; f[i].l; i++) {
	if (f[i].v) {
	    a.addrbits |= (1 << i);
	    strcpy(p, f[i].v);
	    p += strlen(f[i].v) + 1;
	}
    }
    len = p - (char *) &a;

    /* Open address database */
    DB = DmOpenDatabaseByTypeCreator('DATA', 'addr', dmModeReadWrite);
    if (!DB)
	return -1;

    /* Figure out where to put it */
    index = DmFindSortPosition(DB, &a, NULL, compar, 0);

    /* Allocate new record */
    RecHandle = DmNewRecord(DB, &index, len);
    RecPointer = MemHandleLock(RecHandle);

    /* Write record */
    DmWrite(RecPointer, 0, &a, len);

    /* Release and close */
    MemPtrUnlock(RecPointer);
    DmReleaseRecord(DB, index, true);
    DmCloseDatabase(DB);

    printf("Added %s %s to address book\n", f[1].v, f[0].v);

    return 0;
}

DoDemo()
{
    InitField();

    /* Fill in a dummy entry */
    f[0].v = "Russell";
    f[1].v = "Robert";
    f[2].v = "Financial Operations";
    f[3].v = "+1 734 763-3262";
    f[7].v = "rrussell@umich.edu";
    f[8].v = "5002 Wolverine Tower";
    f[13].v = "Assistant Director";

    PrintField();
}

DoGo()
{
    printf("Not implemented yet\n");
//    SysUIAppSwitch();
}

    static Err
StartApplication(void)
{
    FrmGotoForm( MainForm );
    return 0;
}

    static void
StopApplication(void)
{
    closereader();
}

    Int
StringIsNumber( string )
    CharPtr	string;
{
    Int		i;

    for ( i = 0; string[ i ] != NULL; i++ ) {
	if ( !(IsDigit( GetCharAttr(), string[ i ] ))) {
//	    FrmCustomAlert( DebugAlert, string, NULL, NULL );
	    return( 0 );
	}
    }
    return( 1 );
}

    static Boolean
MyFormHandleEvent(EventPtr event)
{
    Int			bpm, hz;
    Boolean		handled;
    FormPtr		frm = FrmGetActiveForm();
    FieldPtr		fldP;
    ControlPtr		button;
    Word		item = FrmGetFocus(frm);

#ifdef __GNUC__
    CALLBACK_PROLOGUE
#endif __GNUC__

    handled = false;

    switch (event->eType) {

    case frmOpenEvent:					/* form */
	printfield = FrmGetObjectPtr(frm, FrmGetObjectIndex(frm, Message));
	FrmDrawForm( frm );
	handled = true;
	break;

    case ctlSelectEvent:  				/* buttons */
	switch ( event->data.ctlSelect.controlID ) {
	case Reap:
	    DoReap();
	    break;
	case Sow:
	    DoSow();
	    break;
	case Demo:
	    DoDemo();
	    break;
	case Go:
	    DoGo();
	    break;
	}
	handled = true;
	break;
	    
    case keyDownEvent:
	handled = scrollfield(printfield, event->data.keyDown.chr);
	break;

    case menuEvent:					/* menus */
	switch ( event->data.menu.itemID ) {
	case Prefs:					/* prefs */
	    /* new form */
	    break;
	case Help:					/* help */
	    FrmHelp( HelpText );
	    break;
	case About:					/* about */
	    FrmAlert( AboutForm );
	    break;
	case Copy:
	    if (item != noFocus)
	    FldCopy(FrmGetObjectPtr(frm, item));
	    break;
	}
	handled = true;
	break;
    }

#ifdef __GNUC__
    CALLBACK_EPILOGUE
#endif
    return(handled);
}


    static Boolean
ApplicationHandleEvent(EventPtr event)
{
    FormPtr	frm;
    Int		formId;
    Boolean	handled = false;

    if (event->eType == frmLoadEvent) {
	formId = event->data.frmLoad.formID;
	frm = FrmInitForm(formId);
	FrmSetActiveForm(frm);

	switch (formId) {
	case MainForm:
	    FrmSetEventHandler(frm, MyFormHandleEvent);
	    break;
	}

	handled = true;
    }
    
    return handled;
}


    static void
EventLoop(void)
{
    EventType	event;
    Word	error;
    
    do {
	EvtGetEvent(&event, evtWaitForever);
	if (! SysHandleEvent(&event))
	    if (! MenuHandleEvent(0, &event, &error))
		if (! ApplicationHandleEvent(&event))
		    FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}

    DWord
PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    Err err = 0;		
    
    if (cmd == sysAppLaunchCmdNormalLaunch) {
	if ((err = StartApplication()) == 0) {
	    EventLoop();
	    StopApplication();
	}
    }

    return err;
}

openreader()
{
    if (fd < 0)
	fd = scopen(0, 0, NULL);
    if (fd < 0) {
	IO_Close();
	return 0;
    }
    return 1;
}

closereader()
{
    if (fd >= 0) {
	scclose(fd);
	IO_Close();
	fd = -1;
    }
    return( 0 );
}
