/*
 * Payflex balance checker and transaction log dumper.
 * Known to work only with UM Mcard.
 * Jim Rees, University of Michigan, February 1999
 */
static char *rcsid = "$Id: main.c,v 1.4 2000/08/04 21:29:34 rees Exp $";

#pragma pack(2)

#include <Common.h>
#include <System/SysAll.h>
#include <System/DataMgr.h>
#include <System/SysEvtMgr.h>
#include <UI/UIAll.h>

#include <System/Unix/unix_stdio.h>
#include <System/Unix/unix_stdlib.h>
#include <System/Unix/sys_types.h>
#include <string.h>

#include "balance.h"
#include "field.h"
#include "scrw.h"

/* This will pull in the clib sprintf instead of using the crippled Pilot rom one */
#undef sprintf
#undef vsprintf

extern int Dflag, aflag, vflag;
int fd, cla;

static Boolean balance(EventPtr event);
int paycmd(int id);

DWord
PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags)
{
    int err;

    if (cmd == sysAppLaunchCmdNormalLaunch) {
	err = StartApplication();
	if (err)
	    return err;
	EventLoop();
	StopApplication();
	return 0;
    } else
	return sysErrParamErr;
}

StartApplication()
{
    fd = -1;
    FrmGotoForm(formID_balance);
    return 0;
}

StopApplication()
{
    closereader();
    return 0;
}

EventLoop()
{
    short err;
    int formID;
    FormPtr form;
    EventType event;

    do {
	EvtGetEvent(&event, 200);

	if (SysHandleEvent(&event))
	    continue;
	if (MenuHandleEvent((void *)0, &event, &err))
	    continue;

	if (event.eType == frmLoadEvent) {
	    formID = event.data.frmLoad.formID;
	    form = FrmInitForm(formID);
	    FrmSetActiveForm(form);
	    switch (formID) {
	    case formID_balance:
		FrmSetEventHandler(form, (FormEventHandlerPtr) balance);
		break;
	    }
	}
	FrmDispatchEvent(&event);
    } while (event.eType != appStopEvent);
}

static Boolean
balance(EventPtr event)
{
    FormPtr form = FrmGetActiveForm();
    Word field;
    int i, handled = 0;

    switch (event->eType) {
    case frmOpenEvent:
	printfield = FrmGetObjectPtr(form, FrmGetObjectIndex(form, fieldID_msg));
	FrmDrawForm(form);
	handled = 1;
	break;

    case ctlSelectEvent:  // A control button was pressed and released.
	handled = paycmd(event->data.ctlEnter.controlID);
	break;

    case keyDownEvent:
	handled = scrollfield(printfield, event->data.keyDown.chr);
	break;

    case menuEvent:
	field = FrmGetFocus(form);
	switch (event->data.menu.itemID) {
	case menuitemID_verbose:
	    vflag ^= 1;
	    break;
	case menuitemID_about:
	    FrmAlert(alertID_about);
	    break;
	case menuitemID_copy:
	    FldCopy(FrmGetObjectPtr(form, field));
	    break;
	}
	handled = 1;
	break;

    }
    return handled;
}

paycmd(int id)
{
    unsigned char buf[100];
    int m = 0, n, doflag = 0, err, code = 1;

    setfield(printfield, NULL);

    switch (id) {
    case buttonID_bal:
	aflag = Dflag = 0;
	doflag = 1;
	break;
    case buttonID_log:
	aflag = 1;
	Dflag = 0;
	doflag = 1;
	break;
    case buttonID_tst:
	aflag = Dflag = 1;
	demo();
	break;
    case buttonID_clr:
	break;
    default:
	code = 0;
	break;
    }

    if (doflag) {
	if (openreader()) {
	    n = screset(fd, buf, &err);
	    if (err == SCEOK)
		TryThemAll(fd, buf, n, m);
	    else
		printf("%s\n", scerrtab[err]);
	    closereader();
	}
    }

    scrollfield(printfield, pageUpChr);
    return code;
}

openreader()
{
    if (fd < 0)
	fd = scopen(0, 0, NULL);
    if (fd < 0) {
	printf("can't open reader\n");
	return 0;
    }
    return 1;
}

closereader()
{
    if (fd >= 0) {
	scclose(fd);
	fd = -1;
    }
    IO_Close();
}

char *
strdup(p)
char *p;
{
    char *q;

    q = malloc(strlen(p) + 1);
    if (q != NULL)
	strcpy(q, p);
    return q;
}

/*
copyright 1998, 1999, 2000
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
