/* pay_smartcafe.c
   1/11/2000, Naomaru Itoi (itoi@eecs.umich.edu)
   pay extension for G&D Sm@rt Cafe, i.e., installing JavaCard 2.1
   compliant CAP file
*/
  
#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <des.h>
#include <scrw.h>

extern struct cmd *lookup_cmd(int ins);
extern int cla; /* in pay.c */

/* Definitions */

#define MAX_BUF_SIZE 256
#define MAX_ARG_SIZE 32

#define CLA          0
#define INS          1
#define P1           2
#define P2           3
#define LENC         4
#define PRIVATE_USE  0x80
#define DEFAULT_TTYN 2
#define INS_CLEARMEM 0x1A
#define INS_CREATEML 0xe0
#define INS_INSTALL  0xe6
#define INS_LOAD_APP 0xe8

#define MAX_XMIT     0xe0 


int jc_create_ml ( int fd )
{
  int rv;
  int r1, r2;
  /*unsigned char buf [16] = {0x0a, 0, 0, 0,
			    0xff, 0xff, 0, 0xff,
			    0xff, 0xff, 0xff}; */
  unsigned char buf [16] = {0x0a, 0x00, 0x00, 0xff,
			    0xff, 0xff, 0xff, 0xff,
			    0xff, 0xff, 0xff};
  
  rv = scwrite(fd, PRIVATE_USE, INS_CREATEML, 1, 0, 0x0b, buf, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("creating ML: ");
    print_r1r2(r1, r2);
    return -1; 
  }

  printf ("create_ml succeeded\n");
  return 0; 
}

int jc_clear_memory( int fd )
{
  int rv;
  int r1, r2; 

  rv = scwrite(fd, PRIVATE_USE, INS_CLEARMEM, 0, 0, 0, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("clearing memory: ");
    print_r1r2(r1, r2);
    return -1; 
  }

  printf ("clear_memory succeeded\n");
  return 0; 
}

int jc_install_load ( int fd )
{
  int rv;
  int r1, r2;
  unsigned char buf [8] = {0x05, 0x77, 0x77, 0x77,
			   0x77, 0x77, 0x00, 0x00}; 

  rv = scwrite(fd, PRIVATE_USE, INS_INSTALL, 0x02, 0, 0x08, buf, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("installing (load): ");
    print_r1r2(r1, r2);
    return -1; 
  }

  printf ("install (load) succeeded\n");
  return 0; 
}

int jc_load_applet ( int fd, unsigned char *buf )
{
  int i, rv, r1, r2, fd_app, len_read, block_num;
  unsigned char buf_tmp [MAX_BUF_SIZE]; 
  unsigned char app_name[MAX_ARG_SIZE];

  sscanf (buf, "%*s %s", app_name);
  printf ("download \"%s\"\n", app_name); 

  /* open the input file */
  fd_app = open (app_name, O_RDONLY, NULL);
  if (fd_app == -1) {
    fprintf (stderr, "cannot open file \"%s\"\n", app_name);
    return -1; 
  }

  /* initialize variables */
  block_num = 0; 
  /* read file and write to the card */
  len_read = read (fd_app, buf_tmp, MAX_XMIT);
  while (len_read == MAX_XMIT) {
    printf ("block #%d\n", block_num);
    /*for (i = 0; i < len_read ; i ++ ){
      printf ("%c", buf_tmp[i]); 
    }
    printf ("\n");*/
    
    rv = scwrite(fd, PRIVATE_USE, INS_LOAD_APP, 0, block_num++, len_read,
		 buf_tmp, &r1, &r2);
    if (r1 != 0x90 && r1 != 0x61) {
      /* error */
      printf("loading applet: ");
      print_r1r2(r1, r2);
      return -1; 
    }

    len_read = read (fd_app, buf_tmp, MAX_XMIT);
  }

  /* write the last block to the card */
  /* the size must be multiple of 32 */
  if (len_read % 32 != 0) {
    len_read += (32 - (len_read % 32));
    for (i = 0 ; i < 32 - (len_read % 32); i ++) 
      buf_tmp [len_read + i] = 0; 
  }

  printf ("block #%d\n", block_num);
  rv = scwrite(fd, PRIVATE_USE, INS_LOAD_APP, 0x80, block_num, len_read,
	       buf_tmp, &r1, &r2);
  if (rv != 0 || (r1 != 0x90 && r1 != 0x61)) {
    /* error */
    printf("loading the last block of applet: ");
    print_r1r2(r1, r2);
    return -1; 
  }
  
  printf ("install (install) succeeded\n");
      
  return 0; 
}

int jc_install_install ( int fd )
{
  int rv;
  int r1, r2;
  unsigned char buf [8] = {0x05, 0x77, 0x77, 0x77,
			   0x77, 0x77, 0x00, 0x00}; 

  rv = scwrite(fd, PRIVATE_USE, INS_INSTALL, 0x04, 0, 0x08, buf, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("installing (install): ");
    print_r1r2(r1, r2);
    return -1; 
  }

  printf ("install (install) succeeded\n");
  return 0; 
}

smartcafe_load_applet (int fd, unsigned char *buf)
{
  int rv;

  rv = jc_create_ml (fd);
  if (rv != 0) return rv;
  
  rv = jc_clear_memory (fd);
  if (rv != 0) return rv;

  rv = jc_install_load (fd);
  if (rv != 0) return rv;

  rv = jc_load_applet (fd, buf);
  if (rv != 0) return rv;

  return 0;
}
