#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#ifdef __linux
#include <openssl/des.h>
#else /* __linux */
#include <des.h>
#endif 

#include <scrw.h>

#ifdef __sun
#define des_set_key(key, schedule) des_key_sched(key, schedule)
#endif

/* external variables */
extern struct cmd *lookup_cmd(int ins);
extern int cla; /* in pay.c */
extern unsigned char AUT0[]; /* pay.c */
extern FILE *cmdf;

/* forward declarations */
void cyberflex_fill_key_block (unsigned char *dst, int key_num,
			       int alg_num, unsigned char *key);

#define myisprint(x) ((x) >= '!' && (x) <= 'z')

char *apptype[] = {
    "?",
    "applet",
    "app",
    "app/applet",
};

char *appstat[] = {
    "?",
    "created",
    "installed",
    "registered",
};

char *filestruct[] = {
    "binary",
    "fixed rec",
    "variable rec",
    "cyclic",
    "program",
};

cyberflex_explore(int fd, unsigned char *buf)
{
    int p2, f0, f1, r1, r2;
    char ftype[32], fname[6];

    for (p2 = 0; ; p2++) {
	if (scread(fd, cla, 0xa8, 0, p2, 0x28, buf, &r1, &r2) < 0)
	    break;
	if (r1 != 0x90)
	    break;
	f0 = buf[4];
	f1 = buf[5];
	if (f0 == 0xff || f0 + f1 == 0)
	    continue;
	if (myisprint(f0) && myisprint(f1))
	    sprintf(fname, "%c%c", f0, f1);
	else
	    sprintf(fname, "%2x.%02x", f0, f1);
	if (buf[6] == 1)
	    /* root */
	    sprintf(ftype, "root");
	else if (buf[6] == 2) {
	    /* DF */
	    if (buf[12] == 27)
		sprintf(ftype, "%s %s", appstat[buf[10]], apptype[buf[9]]);
	    else
		sprintf(ftype, "directory");
	} else if (buf[6] == 4)
	    /* EF */
	    sprintf(ftype, "%s", filestruct[buf[13]]);
	printf("%5s %5d %s\n", fname, (buf[2] << 8) | buf[3], ftype);
    }
}

/* load an applet (.bin) to 3f00/7777 and 3f00/7778
   1/2/2000, Naomaru Itoi */
/*#define MAX_FILE_NAME 256*/
#define MAX_BUF_SIZE 256
#define MAX_APP_SIZE 4096
#define MAX_KEY_FILE_SIZE 1024
#define MAX_APDU_SIZE 0xfa
#define BLOCK_SIZE 8
#define MAX_NUM_ARGS 16
#define MAX_ARG_SIZE 32

char *arg_bufs[MAX_NUM_ARGS];
/*unsigned char progID[2], contID[2]; */

int init_arg_bufs()
{
  int i;

  for (i = 0; i < MAX_NUM_ARGS; i++ ) {
    arg_bufs [i] = (char *) malloc (sizeof (char) * MAX_ARG_SIZE);
    if (arg_bufs[i] == NULL) return -1; 
  }

  return 0; 
}

void free_arg_bufs()
{
  int i;
  
  for (i = 0; i < MAX_NUM_ARGS; i++ ) {
    free (arg_bufs[i]);
  }

  return; 
}

/* default signed applet key of Cyberflex Access */
des_cblock app_key = {0x6A, 0x21, 0x36, 0xF5, 0xD8, 0x0C, 0x47, 0x83};

/* options for load and unload */
unsigned char *app_name; 
unsigned char progID[2], contID[2];
int cont_size, inst_size;
int aid_len, aid[16]; 

int analyze_load_options(unsigned char *buf)
{
  int i, rv;
  int num_bufs, tmp1, tmp2;

  progID[0] = 0x77;
  progID[1] = 0x77;
  contID[0] = 0x77;
  contID[1] = 0x78;
  cont_size = 1152;
  inst_size = 1024;
  aid_len = 5;
  
  for (i = 0 ; i < 16 ; i ++)
    aid[i] = 0x77;

  /* dispatch the buffer to arg_bufs */
  num_bufs = sscanf (buf, "%s %s %s %s %s %s %s %s %s %s %s %s %s %s %s %s", 
		     arg_bufs[0], arg_bufs[1], arg_bufs[2], arg_bufs[3],
		     arg_bufs[4], arg_bufs[5], arg_bufs[6], arg_bufs[7],
		     arg_bufs[8], arg_bufs[9], arg_bufs[10], arg_bufs[11],
		     arg_bufs[12], arg_bufs[13], arg_bufs[14], arg_bufs[15]);
  
  /*for (i = 0 ; i < num_bufs ; i++) {
    printf ("%s\n", arg_bufs[i]);
    }*/

  /* applet file name */
  app_name = arg_bufs[num_bufs - 1]; 

  /* option analysis */
  /* reset the option index */
  optind = 1;

  /* switch on options */
  while (1) {
    rv = getopt (num_bufs, arg_bufs, "p:c:s:i:a:");
    if (rv == -1) break; 
    /*printf ("rv=%c, optarg=%s\n", rv, optarg);*/
    switch (rv) {

    case 'p':
      sscanf(optarg, "%x.%x", &tmp1, &tmp2);
      progID[0] = (unsigned char)tmp1;
      progID[1] = (unsigned char)tmp2;
      break;

    case 'c':
      sscanf(optarg, "%x.%x", &tmp1, &tmp2);
      contID[0] = (unsigned char)tmp1;
      contID[1] = (unsigned char)tmp2;
      break;

    case 's':
      sscanf(optarg, "%d", &cont_size);
      break;

    case 'i':
      sscanf(optarg, "%d", &inst_size);
      break;
      
    case 'a':
      aid_len = sscanf(optarg, "%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x",
	     &aid[0], &aid[1], &aid[2], &aid[3],
	     &aid[4], &aid[5], &aid[6], &aid[7],
	     &aid[8], &aid[9], &aid[10], &aid[11],
	     &aid[12], &aid[13], &aid[14], &aid[15]);
      /*printf ("aid_len = %d\n", aid_len);*/
      break;
    default:
      printf ("unknown option.  command aborted.\n");
      return -1; 
    }
  }

  return 0; 
}

/* let's load applet! :) */
int load_applet (int fd, unsigned char *buf)
{
  unsigned char app_data[MAX_APP_SIZE],
                data[MAX_BUF_SIZE];
  int i, j, fd_app, size, rv, r1, r2; 
  des_cblock tmp;
  des_key_schedule schedule;

  rv = analyze_load_options(buf);
  if (rv != 0) return rv; 

  printf ("applet file             \"%s\"\n", app_name); 
  printf ("program ID              %x.%x\n", progID[0], progID[1]);
  printf ("container ID             %x.%x\n", contID[0], contID[1]);
  printf ("instance container size %d\n", cont_size);
  printf ("instance data size      %d\n", inst_size);
  printf ("AID                     ");
  for (i = 0 ; i < aid_len ; i ++ ) {
    printf ("%02x", (unsigned char)aid[i]);
  }
  printf ("\n");
  
  /* open the input file */
  fd_app = open (app_name, O_RDONLY, NULL);
  if (fd_app == -1) {
    fprintf (stderr, "cannot open file \"%s\"\n", app_name);
    return -1; 
  }

  /* read the input file */
  size = read (fd_app, app_data, MAX_APP_SIZE);
  if (size == 0) {
    fprintf (stderr, "file %s size 0??\n", app_name);
    return -1; 
  }
  if (size == -1) {
    fprintf (stderr, "error reading file %s\n", app_name);
    return -1; 
  }

  /*printf ("file size %d\n", size);*/

  /* size must be able to be divided by BLOCK_SIZE */
  if (size % BLOCK_SIZE != 0) {
    fprintf (stderr, "file (%s) size cannot be divided by BLOCK_SIZE.\n",
	     app_name);
    return -1; 
  }

  /* compute the signature of the applet */
  /* initialize the result buffer */
  for (j = 0; j < BLOCK_SIZE; j++ ) {
    tmp[j] = 0;
  }

  /* chain.  DES encrypt one block, XOR the cyphertext with the next block,
     ... continues until the end of the buffer */
  /*  des_key_sched (&key, schedule);
      #else*/
  des_set_key (&app_key, schedule);
  /*#endif /* __sun */
  for (i = 0; i < size/BLOCK_SIZE; i++) {
    for (j = 0; j < BLOCK_SIZE; j++ ){
      tmp[j] = tmp[j] ^ app_data[i*BLOCK_SIZE + j]; 
    }
    des_ecb_encrypt (&tmp, &tmp, schedule, DES_ENCRYPT);
  }

  /* print out the signature */
  printf ("signature ");
  for (j = 0; j < BLOCK_SIZE; j++ ) {
    printf ("%02x", tmp[j]);
  }
  printf ("\n");

  /* select the default loader */
  rv = scwrite(fd, cla, 0xa4, 0x04, 0, 0, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("selecting default loader: ");
    print_r1r2(r1, r2);
    return -1; 
  }

  /* select 3f.00 (root) */
  rv = selectfile(fd, 0x3f, 0, 0);
  if (rv < 0) return rv; 

  /* create program file */
  data[0] = (size + 16) / 256; /* size, upper byte */
  data[1] = (size + 16) % 256; /* size, lower byte */
  data[2] = progID[0]; /* FID, upper */
  data[3] = progID[1]; /* FID, lower */
  data[4] = 0x03; /* file type = 3 (program file) */
  data[5] = 0x01; /* status = 1 */
  data[6] = data[7] = 0x00; /* record related */
  data[8] = 0xff; /* ACL can do everything with AUT0 */
  for (i = 9; i < 16; i++ ) {
    data[i] = 0x00; /* ACL : cannot do anything without AUT0 */
  }
  
  rv = scwrite(fd, cla, 0xe0, 0, 0, 0x10, data, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("creating file %02x.%02x: ", progID[0], progID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

  /* select program */
  rv = selectfile(fd, progID[0], progID[1], 0);
  if (rv < 0) return rv;

  /* update binary */
  for (i = 0; i < size; i += MAX_APDU_SIZE) {
    int send_size;

    /* compute the size to be sent */
    if (size - i > MAX_APDU_SIZE) send_size = MAX_APDU_SIZE;
    else send_size = size - i;

    rv = scwrite(fd, cla, 0xd6,
		 i / 256, /* offset, upper byte */
		 i % 256, /* offset, lower byte */
		 send_size,
		 app_data + i, /* program file */
		 &r1, &r2);
    
    if (r1 != 0x90 && r1 != 0x61) {
      /* error */
      printf("updating binary %02x.%02x: ", progID[0], progID[1]);
      print_r1r2(r1, r2);
    return -1; 
    } 
  }

  /* manage program .. validate */
  rv = scwrite(fd, cla, 0x0a, 01, 0, 0x08, 
	       tmp, /* signature */
	       &r1, &r2);
    
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("validating applet in %02x.%02x: ", progID[0], progID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

  /* select the default loader */
  rv = scwrite(fd, cla, 0xa4, 0x04, 0, 0, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("selecting default loader: ");
    print_r1r2(r1, r2);
    return -1; 
  }

  /* execute method -- call the install() method in the cardlet.
     cardlet type 01 (applet, not application)
     program ID (7777)
     instance container size (0800 (1152))
     instance container ID (7778)
     instance data size (0400 (1024))
     AID length (0005 (5 byte))
     AID (7777777777) */
  
  data[0] = 0x01; /* cardlet type = 1 (applet, not application) */
  data[1] = progID[0]; /* FID, upper */
  data[2] = progID[1]; /* FID, lower */
  data[3] = cont_size / 256; /* instance container size 0x0800 (1152) byte, upper */
  data[4] = cont_size % 256; /* instance container size 0x0800 (1152) byte, lower */
  data[5] = contID[0]; /* container ID (7778), upper */
  data[6] = contID[1]; /* container ID (7778), lower */
  data[7] = inst_size / 256; /* instance size 0x0400 (1024) byte, upper */
  data[8] = inst_size % 256; /* instance size 0x0400 (1024) byte, lower */
  data[9] = 0x00; /* AID length 0x0005, upper */
  data[10] = aid_len; /* AID length 0x0005, lower */
  for (i = 0; i < aid_len; i++) data[i + 11] = (unsigned int)aid[i];
       /* AID (7777777777) */
  
  rv = scwrite(fd, cla, 0x0c, 0x13, 0, 11 + aid_len, data, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("executing install() method in applet in %02x.%02x: ",
	   progID[0], progID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

  /* That's it! :) */
  return 0; 
}

int unload_applet (int fd, unsigned char *buf)
{
  int r1, r2, rv, i;
  /*unsigned char tmp_buf[2];*/

  rv = analyze_load_options(buf);
  if (rv != 0) return rv;

  printf ("program ID              %x.%x\n", progID[0], progID[1]);
  printf ("continer ID             %x.%x\n", contID[0], contID[1]);
  /*printf ("AID                     ");
  for (i = 0 ; i < aid_len ; i ++ ) {
    printf ("%02x", (unsigned char)aid[i]);
  }
  printf ("\n");*/

  /*printf ("unload applet\n");*/
  
  /* select 3f.00 (root) */
  rv = selectfile(fd, 0x3f, 0, 0);
  if (rv < 0) return rv;

  /* select program file */
  rv = selectfile(fd, progID[0], progID[1], 0);
  if (rv < 0) {
    printf ("no program file %02x.%02x ... proceed to delete data container %02x.%02x\n",
	    progID[0], progID[1], contID[0], contID[1]);
    goto del_container;
  }
  
  /* manage program -- reset */
  rv = scwrite(fd, cla, 0x0a, 02, 0, 0x0, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("resetting applet in %02x.%02x: ", progID[0], progID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

  /* delete program file */
  /*tmp_buf[0] = 0x77;
    tmp_buf[1] = 0x77;*/
  rv = scwrite(fd, cla, 0xe4, 0, 0, 0x02, progID, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("deleting file %02x.%02x: ", progID[0], progID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

 del_container:
  /* delete data container */
  /*tmp_buf[0] = 0x77;
    tmp_buf[1] = 0x78;*/
  rv = scwrite(fd, cla, 0xe4, 0, 0, 0x02, contID, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("deleting file %02x.%02x: ", contID[0], contID[1]);
    print_r1r2(r1, r2);
    return -1; 
  }

  return 0; 
}

int select_applet (int fd, unsigned char *buf)
{
  int i, r1, r2, rv;
  unsigned char data[MAX_BUF_SIZE];

  rv = analyze_load_options(buf);
  if (rv != 0) return rv;
  
  printf ("select applet\n");
  printf ("AID                     ");
  for (i = 0 ; i < aid_len ; i ++ ) {
    printf ("%02x", (unsigned char)aid[i]);
  }
  printf ("\n");
  
  /* select data container (77.78) */
  /*rv = selectfile (fd, 0x3f, 0, 0);
  if (rv < 0) return rv;
  rv = selectfile (fd, contID[0], contID[1], 0);
  if (rv < 0) return rv;*/

  /* select the cardlet (7777777777) */
  for (i = 0; i < aid_len; i++) data[i] = (unsigned char)aid[i];
  /* quick hack in select_applet()
     even with F0 card, select applet APDU (00 a4 04)
     only accepts class byte 00 (not f0) */

  rv = scwrite(fd, cla, 0xa4, 0x04, 0, aid_len, data, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf ("selecting the cardlet: ");
    for (i = 0 ; i < aid_len ; i ++ ) {
      printf ("%02x", (unsigned char)aid[i]);
    }
  printf ("\n");
    print_r1r2 (r1, r2);
    return -1; 
  }

  return 0; 
}

int deselect_applet (int fd, unsigned char *buf)
{
  int r1, r2, rv;

  printf ("select default loader (deselect user applet)\n");
  /* select the default loader */
  rv = scwrite(fd, cla, 0xa4, 0x04, 0, 0x00, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf ("selecting the default loader: ");
    print_r1r2 (r1, r2);
    return -1; 
  }

  return 0; 
}

#define DELIMITER " :\t\n"
#define KEY_BLOCK_SIZE 14

/* download DES keys into 3f.00/00.11 */
int cyberflex_load_key (int fd, unsigned char *buf)
{
  int r1, r2, rv, argc = 0, i, j, tmp;
  unsigned char *token; 
  int key_num[2];
  unsigned char data[MAX_BUF_SIZE];
  unsigned char key[BLOCK_SIZE];

  /*printf ("load key\n");*/

  /* select the default loader */
  /*
  rv = scwrite(fd, cla, 0xa4, 0x04, 0, 0x00, NULL, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
  // error 
    printf ("selecting the default loader: ");
    print_r1r2 (r1, r2);
    return -1; 
    }*/
  printf ("ca_load_key buf=%s\n", buf);
  token = strtok (buf, DELIMITER);
  token = strtok (NULL, DELIMITER);
  if (token == NULL) {
    printf ("Usage: jk number_of_keys\n");
    return -1; 
  }
  argc = atoi (token);
  
  if (argc > 2) {
    printf ("current Cyberflex Access cannot download more than 2 keys to the key file.  Sorry. :(\n");
    return -1; 
  }

  if (argc < 0) {
    printf ("you want to down load %d keys??\n", argc);
    return -1; 
  }

  /* Now let's do it. :) */

  /* add the AUT0 */
  cyberflex_fill_key_block (data,    0, 1, AUT0);

  /* add the applet sign key */
  cyberflex_fill_key_block (data+KEY_BLOCK_SIZE, 5, 0, app_key);

  /* then add user defined keys */
  for ( i = 0 ; i < argc ; i++ ) {
    printf ("key %d : ", i);
    for ( j = 0 ; j < BLOCK_SIZE ; j++ ) {
      fscanf (cmdf, "%02x", &tmp);
      key[j] = (unsigned char)tmp; 
    }
    
    cyberflex_fill_key_block (data + 28 + i*KEY_BLOCK_SIZE, 6 + i, 0, key);
  }

  /* add the suffix */
  data[28 + argc*KEY_BLOCK_SIZE] = 0;
  data[28 + argc*KEY_BLOCK_SIZE + 1] = 0; 
  
  for ( i = 0 ; i < KEY_BLOCK_SIZE * (argc + 2) + 2; i++ )
    printf ("%02x ", data[i]);
  printf ("\n");
  
  /* select the key file */
  /* select 3f.00 (root) */
  rv = selectfile(fd, 0x3f, 0, 0);
  if (rv < 0) return rv;

  /* select 00.11 (key file) */
  rv = selectfile(fd, 0x00, 0x11, 0);
  if (rv < 0) return rv; 

  /* all righty, now let's send it to the card! :) */
  rv = scwrite(fd, cla, 0xd6, 0, 0, KEY_BLOCK_SIZE * (argc + 2) + 2,
	       data, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("writing the key file 00.11: "); 
    print_r1r2(r1, r2);
    return -1; 
  } 
  print_r1r2 (r1, r2); 
		
  return 0; 
}

/* download AUT0 key into 3f.00/00.11 */
int cyberflex_load_AUT0 (int fd, unsigned char *buf)
{
  int r1, r2, rv, argc = 0, i, tmp;
  unsigned char data[MAX_BUF_SIZE];
  unsigned char key[BLOCK_SIZE];

  printf ("load AUT0\n");

  printf ("ca_load_AUT0 buf=%s\n", buf);
  
  /* Now let's do it. :) */

  /* get the AUT0 */
  printf ("input AUT0 : ");
  for ( i = 0 ; i < BLOCK_SIZE ; i++ ) {
      fscanf (cmdf, "%02x", &tmp);
      key[i] = (unsigned char)tmp; 
  }
  cyberflex_fill_key_block (data, 0, 1, key);

  /* add the suffix */
  /*data[KEY_BLOCK_SIZE] = 0;
  data[KEY_BLOCK_SIZE + 1] = 0; */
  
  for ( i = 0 ; i < KEY_BLOCK_SIZE ; i++ )
    printf ("%02x ", data[i]);
  printf ("\n");
  
  /* select the key file */
  /* select 3f.00 (root) */
  rv = selectfile(fd, 0x3f, 0, 0);
  if (rv < 0) return rv;

  /* select 00.11 (key file) */
  rv = selectfile(fd, 0x00, 0x11, 0);
  if (rv < 0) return rv; 

  /* all righty, now let's send it to the card! :) */
  rv = scwrite(fd, cla, 0xd6, 0, 0, KEY_BLOCK_SIZE,
	       data, &r1, &r2);
  if (r1 != 0x90 && r1 != 0x61) {
    /* error */
    printf("writing the key file 00.11: "); 
    print_r1r2(r1, r2);
    return -1; 
  } 
  print_r1r2 (r1, r2); 
		
  return 0; 
}

/* fill the key block.

   Input
   dst     : destination buffer
   key_num : key number (0: AUT, 5: signed applet, etc.)
   alg_num : algorithm number
   key     : incoming 8 byte DES key
   
   The resulting format:
   00 0e key_num alg_num key(8 byte) 0a 0a

   total 14 byte
*/
void cyberflex_fill_key_block (unsigned char *dst, int key_num,
			       int alg_num, unsigned char *key)
{
  int i;
  
  *(dst+0) = 0x00; /* const */
  *(dst+1) = 0x0e; /* const */
  *(dst+2) = key_num; /* key number */
  *(dst+3) = alg_num; /* algorithm number */
  for (i = 0; i <BLOCK_SIZE ; i++) 
    *(dst+i+4) = *(key+i);
  *(dst+12) = 0x0a; /* const */
  *(dst+13) = 0x0a; /* const */

  return; 
}

#define PRV_KEY_SIZE 64*6
#define PRV_KEY_FID0 0x00
#define PRV_KEY_FID1 0x12
#define NUM_RSA_KEY_ELEMENTS 5
#define RSA_BIT_LEN 1024
#define key_number 0x10
#define key_type 0xc8 /* key type 0xc8 (1024 bit RSA private) */
#define KEY_FILE_HEADER_SIZE 8

/* download RSA private key into 3f.00/00.12 */
int cyberflex_load_rsa_priv (int fd, unsigned char *buf)
{
  int r1, r2, rv, argc = 0, i, j, tmp, offset=0, size;
  unsigned char *token; 
  int key_num[2];
  unsigned char data[MAX_KEY_FILE_SIZE];
  static char *key_names[NUM_RSA_KEY_ELEMENTS]= {"p", "q", "1/p mod q",
			       "d mod (p-1)", "d mod (q-1)"};
  unsigned char key_elements[NUM_RSA_KEY_ELEMENTS][RSA_BIT_LEN/8];
  static unsigned char key_file_header[KEY_FILE_HEADER_SIZE] =
    {0xC2, 0x06, 0xC1, 0x08, 0x13, 0x00, 0x00, 0x05};
  static unsigned char key_header[3] =
    {0xC2, 0x41, 0x00}; 
  
  printf ("ca_load_rsa_priv buf=%s\n", buf);

  printf ("input 1024 bit RSA CRT key\n");
  for (i = 0 ; i < NUM_RSA_KEY_ELEMENTS ; i ++ ) {
    printf ("%s (%d bit == %d byte) : ", key_names[i],
	    RSA_BIT_LEN/2, RSA_BIT_LEN/2/8);
    for ( j = 0 ; j < RSA_BIT_LEN/8/2 ; j++ ) {
      fscanf (cmdf, "%02x", &tmp);
      key_elements[i][j] = (unsigned char)tmp; 
    }
  }

  /* printf ("print RSA CRT key\n");
  for (i = 0 ; i < NUM_RSA_KEY_ELEMENTS ; i ++ ) {
    printf ("%s : ", key_names[i]); 
    for ( j = 0 ; j < RSA_BIT_LEN/8/2 ; j++ ) {
      printf ("%02x ", key_elements[i][j]);
    }
    }*/
  
  /* select 3f.00 */
  rv = selectfile(fd, 0x3f, 0, 0);
  if (rv < 0) return rv;

  /* select 00.12 */
  rv = selectfile(fd, 0x00, 0x12, 0);
  if (rv < 0) {
    /* rv != 0, 00.12 does not exist.  create it. */
    printf ("private key file (3f.00/00.12) does not exist.  create it.\n");

    /* create private key file */
    data[0] = (PRV_KEY_SIZE + 16) / 256; /* size, upper byte */
    data[1] = (PRV_KEY_SIZE + 16) % 256; /* size, lower byte */
    data[2] = PRV_KEY_FID0; /* FID, upper */
    data[3] = PRV_KEY_FID1; /* FID, lower */
    data[4] = 0x03; /* file type = 2 (binary file) */
    data[5] = 0x01; /* status = 1 */
    data[6] = data[7] = 0x00; /* record related */
    data[8] = 0xff; /* ACL can do everything with AUT0 */
    for (i = 9; i < 16; i++ ) {
      data[i] = 0x00; /* ACL : cannot do anything without AUT0 */
    }
    
    rv = scwrite(fd, cla, 0xe0, 0, 0, 0x10, data, &r1, &r2);
    if (r1 != 0x90 && r1 != 0x61) {
      /* error */
      printf("creating file %02x.%02x: ",
	     PRV_KEY_FID0, PRV_KEY_FID1);
      print_r1r2(r1, r2);
      return -1; 
    }
  }

  /* burn the key */
  data[0] = 0x01; /* key size, I guess */
  data[1] = 0x5b; /* key size, I guess */
  data[2] = key_number; /* key number */
  data[3] = key_type;
  offset = 4;
  for (j = 0 ; j < KEY_FILE_HEADER_SIZE ; j ++) {
    data[offset++] = key_file_header[j]; 
  }
  for (i = 0 ; i < NUM_RSA_KEY_ELEMENTS ; i ++) {
    /* put the key header */
    for (j = 0 ; j < 3 ; j ++) {
      data[offset++] = key_header[j]; 
    }
    for (j = 0 ; j < RSA_BIT_LEN/2/8 ; j ++) {
      data[offset++] = key_elements [i][j]; 
    }
  }
  for (j = 0 ; j < 2 ; j ++) data[offset++] = 0; 

  /*printf ("data:\n");
  for (i = 0 ; i < 0x015d; i ++) {
    printf ("%02x ", data[i]); 
  }
  printf ("\n");*/
  
  /* now send this to the card */
  /* select private key file */
  rv = selectfile(fd, 0x00, 0x12, 0);
  if (rv < 0) return rv;
  
  /* update binary */
  size = offset;
  
  for (i = 0; i < size; i += MAX_APDU_SIZE) {
      int send_size;
      
      /* compute the size to be sent */
      if (size - i > MAX_APDU_SIZE) send_size = MAX_APDU_SIZE;
      else send_size = size - i;

      rv = scwrite(fd, cla, 0xd6,
		   i / 256, /* offset, upper byte */
		   i % 256, /* offset, lower byte */
		   send_size,
		   data + i, /* key file */
		   &r1, &r2);
    
    if (r1 != 0x90 && r1 != 0x61) {
      /* error */
      printf("updating binary %02x.%02x: ", progID[0], progID[1]);
      print_r1r2(r1, r2);
    return -1; 
    } 
  }

  printf ("rsa key loading done! :)\n");
  return 0; 
}
