/*
 * Smartcard commander.
 * Written by Jim Rees and others at University of Michigan.
 */
static char *rcsid = "$Id: pay.c,v 1.78 2000/08/23 15:56:15 rees Exp $";

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <fcntl.h>
#include <des.h>
#include <scrw.h>

const char helpdir[] = "/usr/local/doc/lewis";
const char HELPTEXT[] =
"1/2 - number of port to which smartcard reader is attached\n"
"      also calls reset (and accepts same modifiers)\n"
"      modifers: t - \n"
"r   - issue a reset to the card\n"
"      modifers: v - verbose\n"
"		f - force open\n"
"		i - return immediately if there is no card in the reader\n"
"C   - set the instruction class\n"
"f   - select or open a file\n"
"      options:  / - select root file (30 00)\n"
"		<byte>.<byte>\n"
"		<byte> <byte> - select file designated by\n"
"				these two bytes\n"
"g   - stat currently selected file\n"
"?/h - display this help screen\n"
"      option: command you want help on\n"
"i/o/b - send an 'in/out/in-out' command\n"
"      requires ins, p1, p2, p3\n"
"      options: c - allows you to specify class byte\n"
"T   - send T=1 I block and get reply\n"
"      options: S - send R/S block\n"
"I   - find instructions\n"
"j   - Cyberflex: Verify AUT0\n"
"      options:\n"
"	r - reset to default loader\n"
"	s - set selected app as default\n"
"	a - fix broken java atr\n"
"	x - list files in selected DF\n"        
"	l - download applet (.bin)\n"
"           options -p program FID, -c instance directory FID,\n"
"                   -s data directory size, -i data container size,\n"
"                   -a applet AID\n"
"	u - unload applet\n"
"           options -p program ID, -c instance directory FID,\n"
"                   -a applet AID\n"
"	p - select applet\n"
"                   -a applet AID\n"
"	q - select default loader as current\n"
"	k - load DES key  (Usage: jk number_of_keys)\n"
"	R - load RSA private key\n"
"s   - Sm@rt Cafe:\n"
"       l - download applet (.CAP)\n"
"R   - read file\n"
"      R filesize\n"
"W   - write file\n"
"      W <filename>\n"
"x   - explore (similar to unix `ls`)\n"
"c   - dump file contents\n"
"e   - eject\n"
"q   - quit\n"
;

extern int get_input(FILE *f, unsigned char *obuf, int omin, int olen);

static unsigned char DFLTATR[] = {0x81, 0x10, 0x06, 0x01};
unsigned char AUT0[] = {0xad, 0x9f, 0x61, 0xfe, 0xfa, 0x20, 0xce, 0x63};

int cla, hflag;
FILE *cmdf;
int sleepytime;

void onhup();
char *getftyname(int ftype);
void free_arg_bufs();
int init_arg_bufs();

main(ac, av)
     int ac;
     char *av[];
{
    unsigned char c, *cp, buf[256], buf2[64], *scriptfile = NULL;
    unsigned char cc;
    int port = 0, fd = -1, oflags, rflags, i, j, x, n, ins, p1, p2, p3,r1,r2, err;
    int f0 = 0x3f, f1 = 0, fsize;
    FILE *f;

    while ((i = getopt(ac, av, "1234hf:s:")) != -1) {
	switch (i) {
	case '1':
	case '2':
	case '3':
	case '4':
	    port = i - '1';
	    break;
	case 'h':
	    hflag = 1;
	    break;
	case 'f':
	    scriptfile = optarg;
	    break;
	case 's':
	    sleepytime = atoi(optarg);
	    break;
	}
    }

    if (scriptfile != NULL) {
	cmdf = fopen(scriptfile, "r");
	if (cmdf == NULL) {
	    perror(scriptfile);
	    exit(2);
	}
    } else
	cmdf = stdin;

    signal(SIGHUP, onhup);

#ifdef FRIENDLY
    printf("\nWelcome to pay.\n");
#endif

    /* NI: malloc buffers for pay arguments */
    if (init_arg_bufs() != 0) {
	fprintf(stderr, "cannot allocate buffer");
	exit (1); 
    }

    /* The Main Loop */
    while (1) {
	fflush(stdout);
	if (sleepytime)
	    usleep(sleepytime * 1000);
	if (cmdf == stdin) {
	    fprintf(stderr, "pay> ");
	    fflush(stderr);
	}
	if (!fgets(buf, sizeof buf, cmdf))
	    break;
	if (cmdf != stdin)
	    printf("pay> %s", buf);

	c = buf[0];
	if (fd < 0 && c != '?' && c != 'h' && c != 'r' && c != 'q' && (c < '0' || c > '9')) {
	    printf("reader not open\n");
	    continue;
	}
	switch (c) {
	case '1':
	case '2':
	case '3':
	case '4':
	    if (fd >= 0) {
		scclose(fd);
		fd = -1;
	    }
	    port = c - '1';
	    oflags = 0;
	    if (!strchr(buf, 'i'))
		oflags |= SCODSR;
	    if (hflag)
		oflags |= SCOHUP;
	    /* fall through */
	case 'r':
	    if (fd < 0)
		fd = scopen(port, oflags, NULL);
	    if (fd < 0) {
		printf("can't open reader number %d\n", port);
		break;
	    }
	    rflags = 0;
	    if (strchr(buf, 'v'))
		rflags |= SCRV;
	    if (strchr(buf, 'f'))
		rflags |= SCRFORCE;
	    n = scxreset(fd, rflags, buf, &err);
	    if (n && !(rflags & SCRV))
		dump_reply(buf, n, 0, 0);
	    if (err != SCEOK)
		printf("%s\n", scerrtab[err]);
	    break;
	case 'C':
	    /* set instruction class */
	    if (sscanf(buf, "%*c %x", &i) == 1)
		cla = i;
	    break;
	case 'f':
	    /* "open" (select) file */
	    if (buf[2] == '/') {
		/* root */
		f0 = 0x3f;
		f1 = 0;
	    } else if (parse_input(&buf[2], buf2, 2) >= 2) {
		f0 = buf2[0];
		f1 = buf2[1];
	    }
	    n = selectfile(fd, f0, f1, 1);
	    break;
	case '?':
	case 'h':
	    if (sscanf(buf, "%*s %s", buf2) < 1) {
		/* display help screen */
		printf(HELPTEXT);
	    } else {
		sprintf(buf, "%s/%s", helpdir, buf2);
		f = fopen(buf, "r");
		if (f) {
		    while (fgets(buf, sizeof buf, f))
			fputs(buf, stdout);
		    fclose(f);
		} else
		    printf("Can't help you with \"%s\"\n", buf2);
	    }
	    break;
	case 'i':
	case 'n':
	    if (buf[1] == 'c')
		sscanf(buf, "%*s %x %x %x %x %x", &i, &ins, &p1, &p2, &p3);
	    else {
		sscanf(buf, "%*s %x %x %x %x", &ins, &p1, &p2, &p3);
		i = cla;
	    }
	    p3 = scan_data(buf, p3, sizeof buf);
#ifdef SCPERF
	    SetTime ("scwrite start");
#endif /* SCPERF */
	    n = scwrite(fd, i, ins, p1, p2, p3, buf, &r1, &r2);
#ifdef SCPERF
	    SetTime ("scwrite end");
#endif /* SCPERF */
	    if (n < 0)
		printf("scwrite failed 1\n");
	    else {
		if (n != p3)
		    printf("p3=%d but scwrite returns %d\n", p3, n);
		dump_reply(buf, 0, r1, r2);
	    }
	    break;
	case 'o':
	    if (buf[1] == 'c')
		sscanf(buf, "%*s %x %x %x %x %x", &i, &ins, &p1, &p2, &p3);
	    else {
		sscanf(buf, "%*s %x %x %x %x", &ins, &p1, &p2, &p3);
		i = cla;
	    }
#ifdef SCPERF
	    SetTime ("scread start");
#endif /* SCPERF */
	    n = scread(fd, i, ins, p1, p2, p3, buf, &r1, &r2);
#ifdef SCPERF
	    SetTime ("scread end");
#endif /* SCPERF */

	    if (n < 0)
		printf("scread failed\n");
	    else {
		if (n != p3)
		    printf("p3=%d but scread returns %d\n", p3, n);
		dump_reply(buf, n, r1, r2);
	    }
	    break;
	case 'b':
	    if (buf[1] == 'c')
		sscanf(buf, "%*s %x %x %x %x %x", &i, &ins, &p1, &p2, &p3);
	    else {
		sscanf(buf, "%*s %x %x %x %x", &ins, &p1, &p2, &p3);
		i = cla;
	    }
	    p3 = scan_data(buf, p3, sizeof buf);
	    n = scrw(fd, i, ins, p1, p2, p3, buf, sizeof buf2, buf2, &r1, &r2);
	    if (n < 0)
		printf("scrw failed\n");
	    else
		dump_reply(buf2, n, r1, r2);
	    break;
#ifdef T_EQ_1_BLK
	case 'T':
	    /* send T=1 packet and get reply */
	    i = (strchr(buf, 'S') != NULL);
	    sscanf(buf, "%*s %d", &p3);
	    p3 = scan_data(buf, p3, sizeof buf);
	    if (i) {
		/* Send R or S block */
		n = scioT1pkt(fd, buf, buf);
	    } else {
		/* Send I block */
		n = scioT1Iblk(fd, p3, buf, buf);
		if (n >= 2) {
		    r1 = buf[n-2];
		    r2 = buf[n-1];
		} else
		    r1 = 0;
		dump_reply(buf, n, r1, r2);
	    }
	    break;
#endif
	case 'I':
	    /* find instructions */
	    for (i = 0; i < 0xff; i += 2)
		if (scread(fd, cla, i, 0, 0, 0, buf, &r1, &r2) == 0
		    && r1 != 0x6d && r1 != 0x6e)
		    printf("%02x %s %s\n", i, lookup_cmdname(i), get_r1r2s(r1, r2));
	    break;
	case 'j':
	    /* Cyberflex: Verify AUT0 */
	    n = scwrite(fd, cla, 0x2a, 0, 0, sizeof AUT0, AUT0, &r1, &r2);
	    if (n >= 0 && cla == 0 && r1 == 0x6d) {
		/* F0 card? */
		n = scwrite(fd, 0xf0, 0x2a, 0, 0, sizeof AUT0, AUT0, &r1, &r2);
		if (r1 == 0x90) {
		    printf("class F0\n");
		    cla = 0xf0;
		}
	    }
	    printf("Verify key: ");
	    if (n < 0) {
		printf("scwrite failed\n");
		break;
	    }
	    dump_reply(buf, 0, r1, r2);

	    if (buf[1] == 'r' || buf[1] == 's') {
		/* Set default */
		scwrite(fd, cla, 0x08, ((buf[1] == 'r') ? 0x05 : 0x4), 0, 0, buf, &r1, &r2);
	    } else if (buf[1] == 'a') {
		/* change java atr */
		n = 0;
		buf2[n++] = 0x90;
		buf2[n++] = 0x94; /* TA1 */
		buf2[n++] = 0x40; /* TD1 */
		buf2[n++] = 0x28; /* TC2 (WWT=4sec) */
		cp = &buf[3];
		if (*cp) {
		    /* set historical bytes from command line */
		    n += parse_input(cp, &buf2[n], 15);
		} else {
		    /* no historical bytes given, use default */
		    memmove(&buf2[n], DFLTATR, sizeof DFLTATR);
		    n += sizeof DFLTATR;
		}
		buf2[0] |= ((n - 2) & 0xf);
		scwrite(fd, cla, 0xfa, 0, 0, n, buf2, &r1, &r2);
	    } else if (buf[1] == 'x') {
		/* eXplore (ls) */
		cyberflex_explore(fd, buf);
	    } else if (buf[1] == 'd') {
		/* get Data */
		scread(fd, cla, 0xca, 0, 1, 0x16, buf, &r1, &r2);
		if (r1 == 0x90) {
		    printf("serno ");
		    for (i = 0; i < 6; i++)
			printf("%02x ", buf[i]);
		    printf("batch %02x sver %d.%02d ", buf[6], buf[7], buf[8]);
		    if (buf[9] == 0x0c)
			printf("augmented ");
		    else if (buf[9] == 0x0b)
			;
		    else
			printf("unknown ");
		    printf("crypto %9.9s class %02x\n", &buf[10], buf[19]);
		}
	    } else if (buf[1] == 'l') {
		/* load an applet (.bin).  1/2/2000, Naomaru Itoi */
		load_applet (fd, buf);
	    } else if (buf[1] == 'u') {
		/* unload an applet (.bin) and program file and data container.
		   1/2/2000, Naomaru Itoi */
		unload_applet (fd, buf);
	    } else if (buf[1] == 'p') {
		select_applet (fd, buf);
	    } else if (buf[1] == 'q') {
		deselect_applet (fd, buf);
	    } else if (buf[1] == 'k') {
		cyberflex_load_key (fd, buf);
	    } else if (buf[1] == 'A') {
		cyberflex_load_AUT0 (fd, buf);
	    } else if (buf[1] == 'R') {
		cyberflex_load_rsa_priv (fd, buf);
	    }
	    
	    // dump_reply(buf, 0, r1, r2);
	    break;
	case 's':
	  if (buf[1] == 'l') {
	    /* load an applet (.CAP).  1/11/2000, Naomaru Itoi */
	    smartcafe_load_applet (fd, buf);
	  }
	  break;
	case 'R':
	    /* read file */
	    if (sscanf(buf, "%*s %d", &fsize) != 1) {
		printf("usage: R filesize\n");
		break;
	    }
	    for (p3 = 0; p3 < 20000; p3 += n) {
		n = (fsize < 200) ? fsize : 200;
		n = scread(fd, cla, 0xb0, p3 >> 8, p3 & 0xff, n, buf, &r1, &r2);
		if (n <= 0)
		    break;
		fwrite(buf, 1, n, stdout);
		fsize -= n;
	    }
	    break;
	case 'W':
	    /* write file */
	    if (sscanf(buf, "%*s %s", buf2) != 1) {
		printf("usage: W filename\n");
		break;
	    }
	    f = fopen(buf2, "r");
	    if (!f) {
		printf("can't open %s\n", buf2);
		break;
	    }
	    p3 = 0;
	    while ((n = fread(buf, 1, 200, f)) > 0) {
		if (scwrite(fd, cla, 0xd6, p3 >> 8, p3 & 0xff, n, buf, &r1, &r2) < 0)
		    break;
		if (r1 != 0x90) {
		    dump_reply(buf, 0, r1, r2);
		    break;
		}
		p3 += n;
	    }
	    fclose(f);
	    break;
	case 'e':
	    /* "eject" */
	    if (fd >= 0) {
		scclose(fd);
		fd = -1;
	    }
	    break;
	case '#':
	    /* comment */
	    continue;
	case 'q':
	    /* quit */
	    goto out;
	}
    }

 out:
    if (fd >= 0)
	scclose(fd);

    /* NI: free buffers for pay arguments */
    free_arg_bufs();
#ifdef SCPERF
    print_time();
#endif /* SCPERF */
    exit(0);
}

selectfile(int fd, int f0, int f1, int verbose)
{
    int n, r1, r2, code;
    unsigned char buf[2], obuf[256];

    buf[0] = f0;
    buf[1] = f1;
    n = scrw(fd, cla, 0xa4, 0, 0, 2, buf, sizeof obuf, obuf, &r1, &r2);
    if (n < 0) {
	printf("selectfile: scwrite failed\n");
	return -2;
    }
    if (r1 == 0x90 || r1 == 0x61)
	code = 0;
    else if (r1 == 0x6a && r2 == 0x82)
	/* file not found */
	code = -1;
    else
	code = -2;
    if (verbose && n > 0)
	dump_reply(obuf, n, 0, 0);
    if (verbose || code == -2) {
	printf("%x.%x: %s\n", f0, f1, get_r1r2s(r1, r2));
    }
    return code;
}

get_response(fd, buf, len, dumpit)
int fd, len, dumpit;
unsigned char *buf;
{
    int n, r1, r2;

    n = scread(fd, cla, 0xc0, 0, 0, len, buf, &r1, &r2);
    if (r1 == 144) {
	if (dumpit)
	    dump_reply(buf, n, r1, r2);
	return 0;
    }
    return -1;
}

scan_data(obuf, omin, olen)
unsigned char *obuf;
int omin, olen;
{
    if (!omin)
	return 0;
    printf("Enter %d data bytes (hex):\n", omin);
    return get_input(cmdf, obuf, omin, olen);
}

void
onhup()
{
    printf("\nCard removed\n");
}
