/*
 * parse atr from a card
 *
 * Jim Rees, May 1998
 */
static char *rcsid = "$Id: atr.c,v 1.14 2000/08/03 21:05:20 rees Exp $";

#include <unistd.h>
#include <stdlib.h>
#include <stdio.h>
#include <scrw.h>

#define ATRTO 120

extern struct {
    short F, D, Dr;
} xtab[];

extern int scatrto;

extern int scxreset(int ttyn, int flags, unsigned char *atr, int *ep);

int fflag;

int
main(ac, av)
int ac;
char *av[];
{
    unsigned char buf[100];
    int port = 0, fd, i, n, c, err;
    int flags = SCODSR;
    struct scparam param;

    while ((i = getopt(ac, av, "12tf")) != -1) {
	switch (i) {
	case '1':
	case '2':
	    port = i - '1';
	    break;
	case 't':
	    /* Todos reader */
	    flags = SCOXCTS | SCOXDTR;
	    break;
	case 'f':
	    fflag = 1;
	    break;
	}
    }

    if (fflag) {
	/* get atr from command line, not from a card */
	fd = 0;
	n = ac - optind;
	for (i = 0; i < n; i++) {
	    sscanf(av[optind + i], "%x", &c);
	    buf[i] = c;
	}
    } else {
	/* open reader */
	fd = scopen(port, flags, NULL);
	if (fd < 0) {
	    printf("can't open reader\n");
	    exit(1);
	}
	n = scxreset(fd, 0, buf, &err);
	if (err != SCEOK)
	    printf("%s\n", scerrtab[err]);
	scclose(fd);
    }

    parse_atr(0, SCRV, buf, n, &param);

    exit(0);
}

/*
copyright 1999
the regents of the university of michigan
all rights reserved

permission is granted to use, copy, create derivative works 
and redistribute this software and such derivative works 
for any purpose, so long as the name of the university of 
michigan is not used in any advertising or publicity 
pertaining to the use or distribution of this software 
without specific, written prior authorization.  if the 
above copyright notice or any other identification of the 
university of michigan is included in any copy of any 
portion of this software, then the disclaimer below must 
also be included.

this software is provided as is, without representation 
from the university of michigan as to its fitness for any 
purpose, and without warranty by the university of 
michigan of any kind, either express or implied, including 
without limitation the implied warranties of 
merchantability and fitness for a particular purpose. the 
regents of the university of michigan shall not be liable 
for any damages, including special, indirect, incidental, or 
consequential damages, with respect to any claim arising 
out of or in connection with the use of the software, even 
if it has been or is hereafter advised of the possibility of 
such damages.
*/
