/*
 * Copyright (c) 2002-2003, Network Appliance, Inc. All rights reserved.
 *
 * This Software is licensed under both of the following two licenses:
 *
 * 1) under the terms of the "Common Public License 1.0" a copy of which is
 *    in the file LICENSE.txt in the root directory. The license is also
 *    available from the Open Source Initiative, see
 *    http://www.opensource.org/licenses/cpl.php.
 * OR
 *
 * 2) under the terms of the "The BSD License" a copy of which is in the file
 *    LICENSE2.txt in the root directory. The license is also available from
 *    the Open Source Initiative, see
 *    http://www.opensource.org/licenses/bsd-license.php.
 *
 * Licensee has the right to choose either one of the above two licenses.
 *
 * Redistributions of source code must retain both the above copyright
 * notice and either one of the license notices.
 *
 * Redistributions in binary form must reproduce both the above copyright
 * notice, either one of the license notices in the documentation
 * and/or other materials provided with the distribution.
 */

/**********************************************************************
 *
 * HEADER: kdat_redirection.h
 *
 * PURPOSE: Kernel DAT macro definitions
 *
 * Description:
 *
 * Mapping rules:
 *      All global symbols are prepended with "DAT_" or "dat_"
 *      All DAT objects have an 'api' tag which, such as 'ep' or 'lmr'
 *      The method table is in the provider definition structure.
 *
 *
 *
 **********************************************************************/

#ifndef _KDAT_REDIRCTION_H_
#define _KDAT_REDIRCTION_H_



/* ia_memtype_hint macro */

#define dat_ia_memtype_hint(ia, mem_type, len, mem_opt, pref_len, pref_align) \
        (DAT_HANDLE_TO_PROVIDER(ia)->ia_memtype_hint_func)(\
                (ia), \
                (mem_type), \
                (len), \
                (mem_opt), \
                (pref_len), \
                (pref_align))

/* evd_modify_upcall macro */

#define dat_evd_modify_upcall(evd, policy, upcall) \
        (*DAT_HANDLE_TO_PROVIDER(evd)->evd_modify_upcall_func)(\
                (evd), \
                (policy), \
                (upcall))

/* evd_create macro */

#define dat_evd_kcreate(ia, qlen, policy, upcall, flags, handle) \
        (*DAT_HANDLE_TO_PROVIDER(ia)->evd_kcreate_func)(\
                (ia), \
                (qlen), \
                (policy), \
                (upcall), \
                (flags), \
                (handle))

/* lmr_create macro */

#define dat_lmr_kcreate(ia, mtype, reg_desc, len, pz, priv, mem_opt, \
                       lmr, context, rmr_context, reg_len, reg_addr) \
         (*DAT_HANDLE_TO_PROVIDER(ia)->lmr_kcreate_func)(\
                (ia), \
                (mtype), \
                (reg_desc), \
                (len), \
                (pz), \
                (priv), \
                (mem_opt), \
                (lmr), \
                (context), \
                (rmr_context), \
                (reg_len), \
                (reg_addr))


#include "dat_redirection.h"

struct dat_provider
{
    const char *                        device_name;
    DAT_PVOID                           extension;

    DAT_IA_OPEN_FUNC                    ia_open_func;
    DAT_IA_QUERY_FUNC                   ia_query_func;
    DAT_IA_CLOSE_FUNC                   ia_close_func;
    DAT_IA_MEMTYPE_HINT_FUNC            ia_memtype_hint_func;	/* kdat only */

    DAT_SET_CONSUMER_CONTEXT_FUNC       set_consumer_context_func;
    DAT_GET_CONSUMER_CONTEXT_FUNC       get_consumer_context_func;
    DAT_GET_HANDLE_TYPE_FUNC            get_handle_type_func;

    DAT_CR_QUERY_FUNC                   cr_query_func;
    DAT_CR_ACCEPT_FUNC                  cr_accept_func;
    DAT_CR_REJECT_FUNC                  cr_reject_func;

    DAT_EVD_KCREATE_FUNC                evd_kcreate_func;
    DAT_EVD_QUERY_FUNC                  evd_query_func;

    DAT_EVD_MODIFY_UPCALL_FUNC          evd_modify_upcall_func; /* kdat only */

    DAT_EVD_RESIZE_FUNC                 evd_resize_func;
    DAT_EVD_POST_SE_FUNC                evd_post_se_func;
    DAT_EVD_DEQUEUE_FUNC                evd_dequeue_func;
    DAT_EVD_FREE_FUNC                   evd_free_func;

    DAT_EP_CREATE_FUNC                  ep_create_func;
    DAT_EP_QUERY_FUNC                   ep_query_func;
    DAT_EP_MODIFY_FUNC                  ep_modify_func;
    DAT_EP_CONNECT_FUNC                 ep_connect_func;
    DAT_EP_DUP_CONNECT_FUNC             ep_dup_connect_func;
    DAT_EP_DISCONNECT_FUNC              ep_disconnect_func;
    DAT_EP_POST_SEND_FUNC               ep_post_send_func;
    DAT_EP_POST_RECV_FUNC               ep_post_recv_func;
    DAT_EP_POST_RDMA_READ_FUNC          ep_post_rdma_read_func;
    DAT_EP_POST_RDMA_WRITE_FUNC         ep_post_rdma_write_func;
    DAT_EP_GET_STATUS_FUNC              ep_get_status_func;
    DAT_EP_FREE_FUNC                    ep_free_func;

    DAT_LMR_KCREATE_FUNC                lmr_kcreate_func;
    DAT_LMR_QUERY_FUNC                  lmr_query_func;
    DAT_LMR_FREE_FUNC                   lmr_free_func;

    DAT_RMR_CREATE_FUNC                 rmr_create_func;
    DAT_RMR_QUERY_FUNC                  rmr_query_func;
    DAT_RMR_BIND_FUNC                   rmr_bind_func;
    DAT_RMR_FREE_FUNC                   rmr_free_func;

    DAT_PSP_CREATE_FUNC                 psp_create_func;
    DAT_PSP_QUERY_FUNC                  psp_query_func;
    DAT_PSP_FREE_FUNC                   psp_free_func;

    DAT_RSP_CREATE_FUNC                 rsp_create_func;
    DAT_RSP_QUERY_FUNC                  rsp_query_func;
    DAT_RSP_FREE_FUNC                   rsp_free_func;

    DAT_PZ_CREATE_FUNC                  pz_create_func;
    DAT_PZ_QUERY_FUNC                   pz_query_func;
    DAT_PZ_FREE_FUNC                    pz_free_func;

    /* udat-1.1 */
    DAT_EP_RESET_FUNC                   ep_reset_func;
    DAT_PSP_CREATE_ANY_FUNC             psp_create_any_func;
};

#endif /* _KDAT_REDIRCTION_H_ */

