/*
 * Copyright (c) 2002-2003, Network Appliance, Inc. All rights reserved.
 *
 * This Software is licensed under both of the following two licenses:
 *
 * 1) under the terms of the "Common Public License 1.0" a copy of which is
 *    in the file LICENSE.txt in the root directory. The license is also
 *    available from the Open Source Initiative, see
 *    http://www.opensource.org/licenses/cpl.php.
 * OR
 *
 * 2) under the terms of the "The BSD License" a copy of which is in the file
 *    LICENSE2.txt in the root directory. The license is also available from
 *    the Open Source Initiative, see
 *    http://www.opensource.org/licenses/bsd-license.php.
 *
 * Licensee has the right to choose either one of the above two licenses.
 *
 * Redistributions of source code must retain both the above copyright
 * notice and either one of the license notices.
 *
 * Redistributions in binary form must reproduce both the above copyright
 * notice, either one of the license notices in the documentation
 * and/or other materials provided with the distribution.
 */

/**********************************************************************
 *
 * HEADER: kdat_config.h
 *
 * PURPOSE: Provides kDAPL configuration information
 *
 * Description: Header file for "uDAPL: User Direct Access Programming
 *		Library, Version: 1.1"
 *
 **********************************************************************/

#ifndef _KDAT_CONFIG_H_
#define _UDAT_CONFIG_H_

#define DAT_VERSION_MAJOR 1
#define DAT_VERSION_MINOR 1


/*
 * The official header files will default DAT_THREADSAFE to DAT_TRUE. If
 * your project does not wish to use this default, you must ensure that
 * DAT_THREADSAFE will be set to DAT_FALSE. This may be done by an
 * explicit #define in a common project header file that is included
 * before any DAT header files, or through command line directives to the
 * compiler (presumably controlled by the make environment).
 */

/*
 * A site, project or platform may consider setting an alternate default
 * via their make rules, but are discouraged from doing so by editing
 * the official header files.
 */

/*
 * The Reference Implementation is not Thread Safe.  The Reference
 * Implementation has chosen to go with the first method and define it
 * explicitly in the header file.
 */

#define DAT_THREADSAFE DAT_FALSE

#ifndef DAT_THREADSAFE
#define DAT_THREADSAFE DAT_TRUE
#endif /* DAT_THREADSAFE */

/*
 * Including this file results in __KDAPL__ being defined, causing
 * a different set of include files and code modules than the user
 * version.
 */
#ifndef __KDAPL__
#define __KDAPL__
#endif /* __KDAPL__ */


#endif /* _KDAT_CONFIG_H_ */
