#define _GNU_SOURCE
#include <sys/param.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <errno.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>

#include "rpc_gssd.h"
#include "err_util.h"

extern struct pollfd *pollarray;
extern int pollsize;

#define POLL_MILLISECS	500

static volatile int dir_changed = 1;

static void dir_notify_handler(int sig, siginfo_t *si, void *data)
{
	dir_changed = 1;
}

static void
scan_poll_results(int ret)
{
	int			i,j;
	struct clnt_info	*clp;

	for (clp = clnt_list.tqh_first; clp != NULL; clp = clp->list.tqe_next)
	{
		i = clp->krb5_poll_index;
		j = clp->spkm3_poll_index;

		if (i == -1) goto do_spkm3; 
		if (pollarray[i].revents) {
			if (pollarray[i].revents & POLLHUP)
				dir_changed = 1;
			if (pollarray[i].revents & POLLIN)
				handle_krb5_upcall(clp);
			pollarray[clp->krb5_poll_index].revents = 0;
			ret--;
			if (!ret)
				break;
		}
do_spkm3:
#ifdef SPKM
		if (j == -1) continue; 
		if (pollarray[j].revents) {
			if (pollarray[j].revents & POLLHUP)
				dir_changed = 1;
			if (pollarray[j].revents & POLLIN)
				handle_spkm3_upcall(clp);
			pollarray[clp->spkm3_poll_index].revents = 0;
			ret--;
			if (!ret)
				break;
		}
#endif /* SPKM */
	}
};

void
gssd_run()
{
	unsigned int		ret = 0;
	struct sigaction	dn_act;
	int			fd;

	/* Taken from linux/Documentation/dnotify.txt: */
	dn_act.sa_sigaction = dir_notify_handler;
	sigemptyset(&dn_act.sa_mask);
	dn_act.sa_flags = SA_SIGINFO;
	sigaction(DNOTIFY_SIGNAL, &dn_act, NULL);

	if ((fd = open(pipefsdir, O_RDONLY)) == -1) {
		printerr(0, "failed to open %s\n", pipefsdir);
		exit(1);
	}
	fcntl(fd, F_SETSIG, DNOTIFY_SIGNAL);
	fcntl(fd, F_NOTIFY, DN_CREATE|DN_DELETE|DN_MODIFY|DN_MULTISHOT);

	init_client_list();

	while (1) {
		while (dir_changed) {
			dir_changed = 0;
			if (update_client_list()) {
				printerr(0, "couldn't update client list\n");
				exit(1);
			}
		}
		/* race condition here: dir_changed could be set before we
		 * enter the poll, and we'd never notice if it weren't for the
		 * timeout. */
		ret = poll(pollarray, pollsize, POLL_MILLISECS);
		if (ret < 0) {
			if (errno != EINTR)
				printerr(0, "error return from poll\n");
		} else if (ret == 0) {
			/* timeout */
		} else { /* ret > 0 */
			scan_poll_results(ret);
		}
	}
	close(fd);
	return;
}
