#include <stdio.h>
#include <stdarg.h>
#include <syslog.h>
#include "err_util.h"

static int verbosity = 0;
static int fg = 0;

void initerr(int set_verbosity, int set_fg)
{
	verbosity = set_verbosity;
	fg = set_fg;
	if (!fg)
		openlog("gssd", LOG_PID, LOG_DAEMON);
}

void printerr(int priority, char *format, ...)
{
	va_list args;

	va_start(args, format);
	priority -= verbosity;
	if (priority < 0)
		priority = 0;
	if (fg) {
		if (priority == 0) 
			vfprintf(stderr, format, args);
	} else {
		int sys_pri;
		switch (priority) {
			case 0:
				sys_pri = LOG_ERR;
				break;
			case 1:
			default:
				sys_pri = LOG_DEBUG;
				break;
		}
		syslog(sys_pri, format, args);
	}
	va_end(args);
}
