#include <sys/param.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#include "rpc_svcgssd.h"
#include "err_util.h"

void
gssd_run()
{
	unsigned int		ret = 0;
	FILE			*f;
	struct pollfd		pollfd;

#define NULLRPC_FILE "/proc/net/rpc/auth.rpcsec.init/channel"
	
	f = fopen(NULLRPC_FILE, "rw");

	if (!f) {
		printerr(0, "failed to open %s\n", NULLRPC_FILE);
		exit(1);
	}
	pollfd.fd = fileno(f);
	pollfd.events = POLLIN;
	while (1) {
		pollfd.revents = 0;
		printerr(1, "entering poll\n");
		ret = poll(&pollfd, 1, -1);
		printerr(1, "leaving poll\n");
		if (ret < 0) {
			if (errno != EINTR)
				printerr(0, "error return from poll\n");
		} else if (ret == 0) {
			/* timeout; shouldn't happen. */
		} else {
			if (ret != 1) {
				printerr(0, "bug: unexpected poll return\n");
				exit(1);
			}
			if (pollfd.revents & POLLIN)
				handle_nullreq(f);
		}
	}
}
