/*
 *  Adapted in part from MIT Kerberos 5-1.2.1 slave/kprop.c and from
 *  http://docs.sun.com/?p=/doc/816-1331/6m7oo9sms&a=view
 *
 *  Copyright (c) 2002 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *  J. Bruce Fields <bfields@umich.edu>
 *  Marius Aamodt Eriksen <marius@umich.edu>
 */

/*
 * slave/kprop.c
 *
 * Copyright 1990,1991 by the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 */

/*
 * Copyright 1994 by OpenVision Technologies, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of OpenVision not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. OpenVision makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * OPENVISION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL OPENVISION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <netdb.h>
#include <fcntl.h>
#include "krb5.h"
#ifdef HAVE_KRB5
#include <gssapi/gssapi.h>
#include <gssapi/gssapi_generic.h>
#elif HAVE_HEIMDAL
#include <gssapi.h>
#define gss_nt_service_name GSS_C_NT_HOSTBASED_SERVICE
#endif
#include "gss_util.h"
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <stdlib.h>

gss_OID g_mechOid = GSS_C_NULL_OID;;

/* XXX check if no error; print GSS vs. MECH */
static void
display_status_1(char *m, u_int32_t code, int type)
{
	u_int32_t maj_stat, min_stat;
	gss_buffer_desc msg = GSS_C_EMPTY_BUFFER;
	u_int32_t msg_ctx = 0;
	char *typestr;	

	switch (type) {
	case GSS_C_GSS_CODE:
		typestr = "GSS";
		break;
	case GSS_C_MECH_CODE:
		typestr = "mechanism";
		break;
	default:
		return;
		/* NOTREACHED */
	}

	for (;;) {
		maj_stat = gss_display_status(&min_stat, code,
		    type, g_mechOid, &msg_ctx, &msg);
		if (maj_stat != GSS_S_COMPLETE) {
			printerr(1, "error in "
				"gss_display_status called from <%s>\n", m);
			break;
		} else {
			printerr(1, "GSS-API: (%s) error in %s(): %s\n",
			    typestr, m, (char *)msg.value);
		}
		
		printerr(1, "GSS-API: (%s) error in %s(): %s\n",
		    typestr, m, (char *)msg.value);

		if (msg.length != 0)
			(void) gss_release_buffer(&min_stat, &msg);

		if (msg_ctx == 0)
			break;
	}
}

void
pgsserr(char *msg, u_int32_t maj_stat, u_int32_t min_stat)
{
	display_status_1(msg, maj_stat, GSS_C_GSS_CODE);
	display_status_1(msg, min_stat, GSS_C_MECH_CODE);
}

krb5_ccache ccache;
krb5_creds  creds;

int
krb5_kt_get_tickets(void)
{
	krb5_error_code retval;
	krb5_context context;
	static char tkstring[] = "/tmp/krb5cc_machine";
	krb5_keytab keytab = NULL;
	krb5_keytab_entry entry;
	krb5_kt_cursor cur;
	krb5_principal  my_principal;   
	char *srvtab = "/etc/krb5.keytab", *realm, buf[BUFSIZ];

	retval = krb5_init_context(&context);
	if (retval) {
		com_err("GSSD", retval, "while initializing krb5");
		goto out;
	}

	/* XXX get in !default realm. */
	retval = krb5_get_default_realm(context, &realm);
	if (retval) {
		com_err("GSSD", retval, "while getting default realm");
		goto out;
	}

	printerr(1, "Using (default) Kerberos realm: \"%s\"\n", realm);

	retval = krb5_sname_to_principal(context, NULL, "nfs",
	    KRB5_NT_SRV_HST, &my_principal);
	if (retval) {
		com_err("GSSD", errno, "while setting client principal name");
		goto out;
	}

	/*
	 * Initialize cache file which we're going to be using
	 */

	sprintf(buf, "FILE:%s", tkstring);
	if ((retval = krb5_cc_resolve(context, buf, &ccache))) {
		com_err("GSSD", retval, "while opening credential cache %s", buf);
		goto out;
	}
	if ((retval = krb5_cc_initialize(context, ccache, my_principal))) {
		com_err("GSSD", retval, "when initializing cache %s", buf);
		goto out;
	} 
	else
		printerr(1, "Initialized credentials cache\n");

	printerr(1, "Using credentials cache: \"%s\"\n", tkstring);

	memset((char *)&creds, 0, sizeof(creds));
	retval = krb5_build_principal(context, &creds.server, strlen(realm),
	    realm, KRB5_TGS_NAME, realm, 0);
	if (retval) {
		com_err("GSSD", errno, "while setting server principal name");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}

	/*
	 * Now fill in the client....
	 */
	if ((retval = krb5_copy_principal(context, my_principal,
					  &creds.client))) {
		com_err("GSSD", retval, "While copying client principal");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	if ((retval = krb5_kt_resolve(context, srvtab, &keytab))) {
		com_err("GSSD", retval, "while resolving keytab");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	/* ANDROS add etype to specify DES cbc mode with CRC-32 */
	if ((retval = krb5_kt_start_seq_get(context, keytab, &cur))) {
		com_err("GSSD", retval, "while starting keytab scan");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	retval = krb5_kt_next_entry(context, keytab, &entry, &cur);
	if (retval) {
		com_err("GSSD", retval, "while getting keytab entry\n");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	/* (in == initial) */
	retval = krb5_get_in_tkt_with_keytab(context, 0, 0, &entry.key.enctype,
	    NULL, keytab, ccache, &creds, 0);
	if (retval) {
		com_err("GSSD", retval, "while getting initial ticket\n");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	else 
		printerr(1, "Acquired initial kerberos ticket\n");

 out:
	if (keytab != NULL)
		(void)krb5_kt_close(context, keytab);
	
	return (retval == 0);
}

void
gss_kt_destroy_tickets(void)
{
	fprintf(stderr,"gss_kt_destroy_tickets\n");
}

int
gssd_acquire_cred(char *server_name)
{
	gss_buffer_desc name;
	gss_name_t target_name;
	u_int32_t maj_stat, min_stat;

	name.value = (void *)server_name;
	name.length = strlen(server_name);

	maj_stat = gss_import_name(&min_stat, &name, gss_nt_service_name,
			&target_name);

	if (maj_stat != GSS_S_COMPLETE) {
		pgsserr("gss_import_name", maj_stat, min_stat);
		return (FALSE);
	}

	maj_stat = gss_acquire_cred(&min_stat, target_name, 0,
			GSS_C_NULL_OID_SET, GSS_C_ACCEPT,
			&gssd_creds, NULL, NULL);

	(void)gss_release_name(&min_stat, &target_name);

	if (maj_stat != GSS_S_COMPLETE)
		pgsserr("gss_acquire_cred", maj_stat, min_stat);

	return (maj_stat == GSS_S_COMPLETE);
}
