#include <sys/types.h>
#include <sys/queue.h>
#include <gssapi/gssapi.h>

#define MAX_FILE_NAMELEN	32
#define FD_ALLOC_BLOCK		32	
#ifndef PIPEFS_DIR
#define PIPEFS_DIR		"/var/lib/rpc_pipes"
#endif
#define INFO			"info"
#define KRB5			"krb5"

char				pipefsdir[PATH_MAX];
int				root_machine_creds;

TAILQ_HEAD(clnt_list_head, clnt_info) clnt_list;

struct clnt_info {
	TAILQ_ENTRY(clnt_info)	list;
	char			*dirname;
	int			dir_fd;
	char			*servicename;
	char			*servername;
	int			prog;
	int			vers;
	char			*protocol;
	int			krb5_fd;
	int			krb5_poll_index;
	int			spkm3_fd;
	int			spkm3_poll_index;
};

void init_client_list(void);
int update_client_list(void);
void handle_krb5_upcall(struct clnt_info *clp);
void handle_spkm3_upcall(struct clnt_info *clp);
int gssd_acquire_cred(char *server_name);
void gssd_run(void);
