#include <sys/param.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <netinet/in.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>

#include "rpc_svcgssd.h"
#include "err_util.h"

void
gssd_run()
{
	unsigned int		ret = 0;
	int			nullfd, ctxfd;
	struct pollfd		pollfd;
	char			nullrpc_file[PATH_MAX + 16];
	char			ctx_file[PATH_MAX + 16];

	strcpy(nullrpc_file, pipefsdir);
	strcat(nullrpc_file, "/nullrpc");
	nullfd = open(nullrpc_file, O_RDWR);
	if (nullfd == -1) {
		printerr(0, "failed to open %s\n", nullrpc_file);
		exit(1);
	}
	strcpy(ctx_file, pipefsdir);
	strcat(ctx_file, "/init_context");
	ctxfd = open(ctx_file, O_WRONLY);
	if (ctxfd == -1) {
		printerr(0, "failed to open %s\n", ctx_file);
		exit(1);
	}
	pollfd.fd = nullfd;
	pollfd.events = POLLIN;
	while (1) {
		pollfd.revents = 0;
		fprintf(stderr, "XXXJBF:entering poll\n");
		ret = poll(&pollfd, 1, -1);
		fprintf(stderr, "XXXJBF:leaving poll\n");
		if (ret < 0) {
			if (errno != EINTR)
				printerr(0, "error return from poll\n");
		} else if (ret == 0) {
			/* timeout; shouldn't happen. */
		} else {
			if (ret != 1) {
				printerr(0, "bug: unexpected poll return\n");
				exit(1);
			}
			if (pollfd.revents & POLLIN)
				handle_nullreq(nullfd, ctxfd);
		}
	}
}
