/*
  gssd.c

  Copyright (c) 2000 The Regents of the University of Michigan.
  All rights reserved.

  Copyright (c) 2000 Dug Song <dugsong@UMICH.EDU>.
  Copyright (c) 2002 Andy Adamson <andros@UMICH.EDU>.
  Copyright (c) 2002 Marius Aamodt Eriksen <marius@UMICH.EDU>.
  Copyright (c) 2002 J. Bruce Fields <bfields@UMICH.EDU>.
  All rights reserved, all wrongs reversed.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of the University nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  $Id: rpc_svcgssd.c,v 1.3 2003/03/10 22:39:05 rees Exp $
*/

#include <sys/param.h>
#include <sys/socket.h>
#include <rpc/rpc.h>

#include <unistd.h>
#include <err.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "rpc_svcgssd.h"
#include "gss_util.h"
#include "err_util.h"

#define GSS_SERVER_NAME		"nfs"

char pipefsdir [PATH_MAX] = PIPEFS_DIR;

void
sig_die(int signal)
{
	/* destroy krb5 machine creds */
	gss_kt_destroy_tickets();
	printerr(1, "exiting on signal %d\n", signal);
	exit(1);
}

static void
usage(char *progname)
{
	fprintf(stderr, "usage: %s [-n] [-f] [-v] [-p pipefsdir]\n",
		progname);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int get_creds = 1;
	int fg = 0;
	int verbosity = 0;
	int opt;
	extern char *optarg;

	while ((opt = getopt(argc, argv, "fvnp:")) != -1) {
		switch (opt) {
			case 'f':
				fg = 1;
				break;
			case 'n':
				get_creds = 0;
				break;
			case 'v':
				verbosity++;
				break;
			case 'p':
				strncpy(pipefsdir, optarg, sizeof(pipefsdir));
				if (pipefsdir[sizeof(pipefsdir)-1] != '\0')
					errx(1, "pipefs path name too long");
				break;
			default:
				usage(argv[0]);
				break;
		}
	}

	initerr(verbosity, fg);

	if (!fg && daemon(0, 0) < 0)
		errx(1, "fork");

	signal(SIGINT, sig_die);
	signal(SIGTERM, sig_die);
	signal(SIGHUP, sig_die);

	if (get_creds && !gssd_acquire_cred(GSS_SERVER_NAME)) {
		printerr(0, "couldn't get credentials\n");
		exit(1);
	}
	if (get_creds && !krb5_kt_get_tickets()) {
		printerr(0, "couldn't get krb5 machine tickets\n");
		exit(1);
	}

	gssd_run();
	printerr(0, "gssd_run returned!\n");
	abort();
}
