#include <stdlib.h>
#include <rpc/rpc.h>

gss_cred_id_t	gssd_creds;

int gssd_acquire_cred(char *server_name);
int krb5_kt_get_tickets(void);
void gss_kt_destroy_tickets(void);

inline static int
write_bytes(char **ptr, const char *end, const void *arg, int arg_len)
{
	char *p = *ptr, *arg_end;

	arg_end = p + arg_len;
	if (arg_end > end || arg_end < p)
		return -1;
	memcpy(p, arg, arg_len);
	*ptr = arg_end;
	return 0;
}

#define WRITE_BYTES(p, end, arg) write_bytes(p, end, &arg, sizeof(arg))

inline static int
write_buffer(char **p, char *end, gss_buffer_desc *arg)
{
	if (WRITE_BYTES(p, end, arg->length))
		return -1;
	if (*p + arg->length > end)
		return -1;
	memcpy(*p, arg->value, arg->length);
	*p += arg->length;
	return 0;
}

static inline int
get_bytes(char **ptr, const char *end, void *res, int len)
{
	char *p, *q;
	p = *ptr;
	q = p + len;
	if (q > end || q < p)
		return -1;
	memcpy(res, p, len);
	*ptr = q;
	return 0;
}

static inline int
get_buffer(char **ptr, const char *end, gss_buffer_desc *res)
{
	char *p, *q;
	p = *ptr;
	if (get_bytes(&p, end, &res->length, sizeof(res->length)))
		return -1;
	q = p + res->length;
	if (q > end || q < p)
		return -1;
	if (!(res->value = malloc(res->length)))
		return -1;
	memcpy(res->value, p, res->length);
	*ptr = q;
	return 0;
}

static inline int
xdr_get_u32(u_int32_t **ptr, const u_int32_t *end, u_int32_t *res)
{
	if (get_bytes((char **)ptr, (char *)end, res, sizeof(res)))
		return -1;
	*res = ntohl(*res);
	return 0;
}

static inline int
xdr_get_buffer(u_int32_t **ptr, const u_int32_t *end, gss_buffer_desc *res)
{
	u_int32_t *p, *q;
	p = *ptr;
	if (xdr_get_u32(&p, end, &res->length))
		return -1;
	q = p + ((res->length + 3) >> 2);
	if (q > end || q < p)
		return -1;
	if (!(res->value = malloc(res->length)))
		return -1;
	memcpy(res->value, p, res->length);
	*ptr = q;
	return 0;
}

static inline int
xdr_write_u32(u_int32_t **ptr, const u_int32_t *end, u_int32 arg)
{
	u_int32 tmp;

	tmp = htonl(arg);
	return WRITE_BYTES((char **)ptr, (char *)end, tmp);
}

static inline int
xdr_write_buffer(u_int32_t **ptr, const u_int32_t *end, gss_buffer_desc *arg)
{
	if (xdr_write_u32(ptr, end, arg->length))
		return -1;
	return write_bytes((char **)ptr, (char *)end, arg->value,
			   (arg->length + 3) & ~3);
}
