#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <netinet/in.h>
#include <syslog.h>
#include <errno.h>
#include <sys/types.h>
#include <fcntl.h>
#include <signal.h>
#include <unistd.h>
#include "in_gssd.h"

extern struct pollfd *pollkrb5;
extern int pollsize;

#define POLL_MILLISECS	500

static volatile int dir_changed = 1;

static void dir_notify_handler(int sig, siginfo_t *si, void *data)
{
	dir_changed = 1;
}

static void
scan_poll_results(int ret)
{
	int			i;
	struct clnt_info	*clp;

	for (clp = clnt_list.tqh_first; clp != NULL; clp = clp->list.tqe_next)
	{
		i = clp->krb5_poll_index;
		if (i == -1) continue;
		if (pollkrb5[i].revents) {
			if (pollkrb5[i].revents & POLLHUP)
				dir_changed = 1;
			if (pollkrb5[i].revents & POLLIN)
				handle_upcall(clp);
			pollkrb5[clp->krb5_poll_index].revents = 0;
			ret--;
			if (!ret)
				break;
		}
	}
};

void
gssd_run()
{
	unsigned int		ret = 0;
	struct sigaction	dn_act;
	int			fd;

	/* Taken from linux/Documentation/dnotify.txt: */
	dn_act.sa_sigaction = dir_notify_handler;
	sigemptyset(&dn_act.sa_mask);
	dn_act.sa_flags = SA_SIGINFO;
	sigaction(SIGRTMIN, &dn_act, NULL);

	if ((fd = open(pipefsdir, O_RDONLY)) == -1) {
		syslog(LOG_ERR, "failed to open %s", pipefsdir);
		exit(1);
	}
	fcntl(fd, F_SETSIG, SIGRTMIN);
	fcntl(fd, F_NOTIFY, DN_CREATE|DN_DELETE|DN_MODIFY|DN_MULTISHOT);

	init_client_list();

	while (1) {
		while (dir_changed) {
			dir_changed = 0;
			if (update_client_list()) {
				syslog(LOG_ERR, "couldn't update client list");
				exit(1);
			}
		}
		/* race condition here: dir_changed could be set before we
		 * enter the poll, and we'd never notice if it weren't for the
		 * timeout. */
		ret = poll(pollkrb5, pollsize, POLL_MILLISECS);
		if (ret < 0) {
			if (errno != EINTR)
				syslog(LOG_ERR, "error return from poll");
		} else if (ret == 0) {
			/* timeout */
		} else { /* ret > 0 */
			scan_poll_results(ret);
		}
	}
	close(fd);
	return;
}
