/*
  gssd.c

  Copyright (c) 2000 The Regents of the University of Michigan.
  All rights reserved.

  Copyright (c) 2000 Dug Song <dugsong@UMICH.EDU>.
  Copyright (c) 2002 Andy Adamson <andros@UMICH.EDU>.
  Copyright (c) 2002 Marius Aamodt Eriksen <marius@UMICH.EDU>.
  All rights reserved, all wrongs reversed.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:

  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of the University nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

  $Id: gssd.c,v 1.18 2002/09/03 20:22:28 marius Exp $
*/

#include <sys/types.h>
#include <sys/socket.h>
#include <rpc/rpc.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include <syslog.h>
#include "in_gssd.h"

#define GSS_SERVER_NAME		"nfs"

/* extern'd in gss_aux.c */
gss_OID g_mechOid = GSS_C_NULL_OID;

/* gss_aux.c */
extern FILE *errf;

char pipefsdir[PATH_MAX] = PIPEFS_DIR;

void
sig_die(int signal)
{
	/* destroy krb5 machine creds */
	gss_kt_destroy_tickets();
	syslog(LOG_INFO, "exiting on signal %d", signal);
	exit(1);
}

static void
usage(char *progname)
{
	fprintf(stderr, "usage: %s [-n|--no-krb5] [-d domain_name]\n",
		progname);
	exit(1);
}

int
main(int argc, char *argv[])
{
	int get_creds = 1;
	int opt;
	extern char *optarg;

#ifdef DEBUG
	errf = stderr;
#endif

	openlog("gssd", LOG_PID, LOG_DAEMON);

	while ((opt = getopt(argc, argv, "np:")) != -1) {
		switch (opt) {
			case 'n':
				get_creds = 0;
			case 'p':
				strncpy(pipefsdir, optarg, sizeof(pipefsdir));
				if (pipefsdir[sizeof(pipefsdir)-1] != '\0')
					errx(1, "pipefs path name too long");
				break;
			default:
				usage(argv[0]);
				break;
		}
	}

#ifndef DEBUG
	if (daemon(0, 0) < 0) {
		perror("fork");
		exit(1);
	}
#endif

	signal(SIGINT, sig_die);
	signal(SIGTERM, sig_die);
	signal(SIGHUP, sig_die);

	if (get_creds && !gssd_acquire_cred(GSS_SERVER_NAME)) {
		syslog(LOG_ERR, "couldn't get credentials");
		exit(1);
	}
	if (get_creds && !krb5_kt_get_tickets()) {
		syslog(LOG_ERR, "couldn't get krb5 machine tickets");
		exit(1);
	}

	/* Run server. */
	gssd_run();
	
	syslog(LOG_ERR, "gssd_run returned!");
	
	abort();
	
	/* NOTREACHED */
}
