#include <syslog.h>
#include <krb5.h>
#include "context.h"
#include "util.h"

extern gss_OID_desc krb5oid;

/* XXX argggg, there's gotta be a better way than just duplicating this
 * whole struct: */

typedef struct _krb5_gss_ctx_id_rec {
	int initiate;
	u_int32_t gss_flags;
	int seed_init;
	unsigned char seed[16];
	krb5_principal here;
	krb5_principal there;
	krb5_keyblock *subkey;
	int signalg;
	int cksum_size;
	int sealalg;
	krb5_keyblock *enc;
	krb5_keyblock *seq;
	krb5_timestamp endtime;
	krb5_flags krb_flags;
	krb5_ui_4 seq_send;
	krb5_ui_4 seq_recv;
	void *seqstate;
	int established;
	int big_endian;
	krb5_auth_context auth_context;
	gss_buffer_desc *mech_used;
	int nctypes;
	krb5_cksumtype *ctypes;
} krb5_gss_ctx_id_rec, *krb5_gss_ctx_id_t;

/* adapted from mit kerberos 5 ../lib/gssapi/mechglue/mglueP.h 
 * this is what gets passed around when the mechglue code is enabled : */
typedef struct gss_union_ctx_id_t {
	gss_OID		mech_type;
	gss_ctx_id_t	internal_ctx_id;
} gss_union_ctx_id_desc, *gss_union_ctx_id_t;

static int
write_keyblock(char **p, char *end, struct _krb5_keyblock *arg)
{
	gss_buffer_desc tmp;

	if (WRITE_BYTES(p, end, arg->enctype)) return -1;
	tmp.length = arg->length;
	tmp.value = arg->contents; 
	if (write_buffer(p, end, &tmp)) return -1;
	return 0;
}

/* Should be overkill; figure out the right number some day: */
#define MAX_CTX_LEN 1024
static int
export_krb5_ctx_to_kernel(gss_ctx_id_t ctx, gss_buffer_desc *buf)
{
	krb5_gss_ctx_id_t       kctx = (krb5_gss_ctx_id_t)ctx;
	char *p, *end;

	if (!(buf->value = calloc(1, MAX_CTX_LEN)))
		goto out_err;
	p = buf->value;
	end = buf->value + MAX_CTX_LEN;

	if (WRITE_BYTES(&p, end, kctx->initiate)) goto out_err;
	if (WRITE_BYTES(&p, end, kctx->seed_init)) goto out_err;
	if (write_bytes(&p, end, &kctx->seed, sizeof(kctx->seed)))
		goto out_err;
	if (WRITE_BYTES(&p, end, kctx->signalg)) goto out_err;
	if (WRITE_BYTES(&p, end, kctx->sealalg)) goto out_err;
	if (WRITE_BYTES(&p, end, kctx->endtime)) goto out_err;
	if (WRITE_BYTES(&p, end, kctx->seq_send)) goto out_err;
	if (write_buffer(&p, end, kctx->mech_used)) goto out_err;
	if (write_keyblock(&p, end, kctx->enc)) goto out_err;
	if (write_keyblock(&p, end, kctx->seq)) goto out_err;

	buf->length = p - (char *)buf->value;
	return 0;
out_err:
	if (buf->value) free(buf->value);
	buf->length = 0;
	return -1;
}

#define g_OID_equal(o1, o2) \
	(((o1)->length == (o2)->length) && \
	 (memcmp((o1)->elements,(o2)->elements,(o1)->length) == 0))

int
export_ctx_to_kernel(gss_ctx_id_t ctx, gss_buffer_desc *buf)
{
	gss_union_ctx_id_t      uctx = (gss_union_ctx_id_t)ctx;

	if (g_OID_equal(&krb5oid, uctx->mech_type))
		return export_krb5_ctx_to_kernel(uctx->internal_ctx_id, buf);
	else { /* will switch on other mechanisms here */
		syslog(LOG_ERR, "attempting to export context with unknown"
				" mechanism oid\n");
		return -1;
	}
}
