/*
 * gss_aux.c
 *
 * Adopted from http://docs.sun.com/?p=/doc/816-1331/6m7oo9sms&a=view
 * with appropriate modifications.
 *
 * Copyright (c) 2002 Marius Aamodt Eriksen <marius@UMICH.EDU>
 *
 * $Id: gss_aux.c,v 1.6 2002/08/28 05:31:10 marius Exp $
 */

/*
 * Copyright 1994 by OpenVision Technologies, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software
 * and its documentation for any purpose is hereby granted without fee,
 * provided that the above copyright notice appears in all copies and
 * that both that copyright notice and this permission notice appear in
 * supporting documentation, and that the name of OpenVision not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission. OpenVision makes no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * OPENVISION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL OPENVISION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */

#include <stdio.h>
#include <sys/types.h>
#include <netinet/in.h>
#include <errno.h>
#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif
#include <string.h>
#include <syslog.h>

#include <gssapi/gssapi.h>
#include "gss_aux.h"
#include <stdlib.h>

FILE *errf = NULL;
extern gss_OID g_mechOid;

/* XXX check if no error; print GSS vs. MECH */
static void
display_status_1(char *m, u_int32_t code, int type)
{
	u_int32_t maj_stat, min_stat;
	gss_buffer_desc msg = GSS_C_EMPTY_BUFFER;
	u_int32_t msg_ctx = 0;
	char *typestr;	

	switch (type) {
	case GSS_C_GSS_CODE:
		typestr = "GSS";
		break;
	case GSS_C_MECH_CODE:
		typestr = "mechanism";
		break;
	default:
		return;
		/* NOTREACHED */
	}

	for (;;) {
		maj_stat = gss_display_status(&min_stat, code,
		    type, g_mechOid, &msg_ctx, &msg);
		if (maj_stat != GSS_S_COMPLETE) {
			if (errf != NULL)
				fprintf(errf, "error in "
				    "gss_display_status called from <%s>\n", m);
			break;
		} else if (errf != NULL) {
			fprintf(errf, "GSS-API: (%s) error in %s(): %s\n",
			    typestr, m, (char *)msg.value);
		}
		
		syslog(LOG_ERR, "GSS-API: (%s) error in %s(): %s\n",
		    typestr, m, (char *)msg.value);

		if (msg.length != 0)
			(void) gss_release_buffer(&min_stat, &msg);

		if (msg_ctx == 0)
			break;
	}
}

void
pgsserr(char *msg, u_int32_t maj_stat, u_int32_t min_stat)
{
	display_status_1(msg, maj_stat, GSS_C_GSS_CODE);
	display_status_1(msg, min_stat, GSS_C_MECH_CODE);
}
