#ifdef HAVE_KRB5
#include <gssapi/gssapi.h>
#include <gssapi/gssapi_generic.h>
#elif HAVE_HEIMDAL
#include <gssapi.h>
#define gss_nt_service_name GSS_C_NT_HOSTBASED_SERVICE
#endif
#include "util.h"

int
gssd_acquire_cred(char *server_name)
{
	gss_buffer_desc name;
	gss_name_t target_name;
	u_int32_t maj_stat, min_stat;

	name.value = (void *)server_name;
	name.length = strlen(server_name);

	maj_stat = gss_import_name(&min_stat, &name, gss_nt_service_name,
			&target_name);

	if (maj_stat != GSS_S_COMPLETE) {
		pgsserr("gss_import_name", maj_stat, min_stat);
		return (FALSE);
	}

	maj_stat = gss_acquire_cred(&min_stat, target_name, 0,
			GSS_C_NULL_OID_SET, GSS_C_ACCEPT,
			&gssd_creds, NULL, NULL);

	(void)gss_release_name(&min_stat, &target_name);

	if (maj_stat != GSS_S_COMPLETE)
		pgsserr("gss_acquire_cred", maj_stat, min_stat);

	return (maj_stat == GSS_S_COMPLETE);
}
