/*
	Connectathon Testsuite  RPCSEC_GSS User Level API
      		 list_procs.c
*/

#include <stdlib.h>
#include <string.h>
#include "list.h"

typedef struct addrlist_s {
	struct addrlist_s *next;	/* pointer to next list item */
	addr_entry entry;		/* address entry */
} addrlist_t;

static addrlist_t *addrlist = NULL;


/*
 * addrlist_set_1_svc: adds a name/address record to the list.  If
 *	addition is successful, "TRUE" result is returned, else
 *	"FALSE" result is returned.
 */
bool_t *
addrlist_set_1_svc(entry, rqstp)
	addr_entry *entry;
	struct svc_req *rqstp;
{
	static bool_t res = TRUE;
	addrlist_t *list;

	for (list = addrlist; list != NULL; list = list->next) {
		if (strcmp(list->entry.name, entry->name) == 0) {
			free(list->entry.address);
			list->entry.address = (char *)
				malloc(strlen(entry->address) + 1);
			strcpy(list->entry.address, entry->address);
			return (&res);
		}
	}

	list = (addrlist_t *) malloc(sizeof (addrlist_t));
	if (list != NULL) {
		list->entry.name = (char *) malloc(strlen(entry->name)+1);
		strcpy(list->entry.name, entry->name);
		list->entry.address = (char *)
			malloc(strlen(entry->address) + 1);
		strcpy(list->entry.address, entry->address);
		if (list->entry.name != NULL && list->entry.address != NULL) {
			list->next = addrlist;
			addrlist = list;
			return (&res);
		}
		free(list->entry.name);
		free(list->entry.address);
		free(list);
	}
	res = FALSE;
	return (&res);
}


/*
 * addrlist_get_1_svc: given a name, a name/address record is returned.
 *	if the given name is not in the list, a NULL is returned.
 */
addr_entry *
addrlist_get_1_svc(name, rqstp)
	name_t	*name;
	struct svc_req *rqstp;
{
	addr_entry *entry;
	addrlist_t *list;

	entry = NULL;
	for (list = addrlist; list != NULL; list = list->next) {
		if (strcmp(list->entry.name, *name) == 0) {
			entry = &list->entry;
			break;
		}
	}
	return (entry);
}


/*
 * addrlist_del_1_svc: given a name, the corresponding name/address record
 *	is deleted.  If the name exists in the list, "TRUE" result is
 *	returned, else "FALSE" result is returned.
 */
bool_t *
addrlist_del_1_svc(name, rqstp)
	name_t	*name;
	struct svc_req *rqstp;
{
	static bool_t res = TRUE;
	addrlist_t *list, *prev;

	for (prev = NULL, list = addrlist; list != NULL;
					prev = list, list = list->next) {
		if (strcmp(list->entry.name, *name) == 0) {
			if (!prev)
				addrlist = list->next;
			else
				prev->next = list->next;
			free(list->entry.name);
			free(list->entry.address);
			free(list);
			return (&res);
		}
	}
	res = FALSE;
	return (&res);
}

