#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>
#include <sys/socket.h>
#include <sys/poll.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <netinet/in.h>
#include <syslog.h>
#include <errno.h>
#include <sys/types.h>
#include <unistd.h>
#include "svc_in_gssd.h"

#define NULLRPC_FILE	"/rpc_svc_gss_pipefs/nullrpc"
#define CTX_FILE	"/rpc_svc_gss_pipefs/init_context"

void
gssd_run()
{
	unsigned int		ret = 0;
	int			nullfd, ctxfd;
	struct pollfd		pollfd;

	nullfd = open(NULLRPC_FILE, O_RDWR);
	if (!nullfd) {
		syslog(LOG_ERR, "failed to open %s", NULLRPC_FILE);
		exit(1);
	}
	ctxfd = open(CTX_FILE, O_WRONLY);
	if (!ctxfd) {
		syslog(LOG_ERR, "failed to open %s", CTX_FILE);
		exit(1);
	}
	pollfd.fd = nullfd;
	pollfd.events = POLLIN;
	while (1) {
		pollfd.revents = 0;
		ret = poll(&pollfd, 1, -1);
		if (ret < 0) {
			if (errno != EINTR)
				syslog(LOG_ERR, "error return from poll");
		} else {
			if (ret != 1) {
				syslog(LOG_ERR, "bug: unexpected poll return");
				exit(1);
			}
			if (pollfd.revents & POLLIN)
				handle_nullreq(nullfd, ctxfd);
		}
	}
}
