inline static int
write_bytes(char **ptr, const char *end, const void *arg, int arg_len)
{
	char *p = *ptr, *arg_end;

	arg_end = p + arg_len;
	if (arg_end > end || arg_end < p)
		return -1;
	memcpy(p, arg, arg_len);
	*ptr = arg_end;
	return 0;
}

#define WRITE_BYTES(p, end, arg) write_bytes(p, end, &arg, sizeof(arg))

inline static int
write_buffer(char **p, char *end, gss_buffer_desc *arg)
{
	if (WRITE_BYTES(p, end, arg->length))
		return -1;
	if (*p + arg->length > end)
		return -1;
	memcpy(*p, arg->value, arg->length);
	*p += arg->length;
	return 0;
}
