/*
 *  gss_kt_login.c
 *
 *  Adapted from MIT Kerberos 5-1.2.1 slave/kprop.c
 *
 *  Copyright (c) 2002 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 */

/*
 * slave/kprop.c
 *
 * Copyright 1990,1991 by the Massachusetts Institute of Technology.
 * All Rights Reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 *
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 */

#include <errno.h>
#include <stdio.h>
#include <ctype.h>
#include <sys/file.h>
#include <signal.h>
#include <string.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <sys/param.h>
#include <netdb.h>
#include <fcntl.h>
#include "krb5.h"

krb5_ccache ccache;
krb5_creds  creds;

#ifdef MACH_LOGIN
/* build this as the mach_log executable */
main(int ac, char **av)
{

	krb5_kt_get_tickets();

}
#endif /* MACH_LOGIN */

int
krb5_kt_get_tickets(void)
{
	krb5_error_code retval;
	krb5_context context;
	krb5_creds *my_creds;
	static char tkstring[] = "/tmp/krb5cc_machine";
	krb5_keytab keytab = NULL;
	krb5_keytab_entry entry;
	krb5_kt_cursor cur;
	krb5_principal  my_principal;   
	char *srvtab = "/etc/krb5.keytab", *realm, buf[BUFSIZ];

	retval = krb5_init_context(&context);
	if (retval) {
		com_err("GSSD", retval, "while initializing krb5");
		goto out;
	}

	/* XXX get in !default realm. */
	retval = krb5_get_default_realm(context, &realm);
	if (retval) {
		com_err("GSSD", retval, "while getting default realm");
		goto out;
	}

#ifdef DEBUG
	fprintf(stderr, "Using (default) Kerberos realm: \"%s\"\n", realm);
#endif /* DEBUG */

	retval = krb5_sname_to_principal(context, NULL, "nfs",
	    KRB5_NT_SRV_HST, &my_principal);
	if (retval) {
		com_err("GSSD", errno, "while setting client principal name");
		goto out;
	}

	/*
	 * Initialize cache file which we're going to be using
	 */

	sprintf(buf, "FILE:%s", tkstring);
	if (retval = krb5_cc_resolve(context, buf, &ccache)) {
		com_err("GSSD", retval, "while opening credential cache %s", buf);
		goto out;
	}
	if (retval = krb5_cc_initialize(context, ccache, my_principal)) {
		com_err ("GSSD", retval, "when initializing cache %s", buf);
		goto out;
	} 
#ifdef DEBUG
	else
		fprintf(stderr, "Initialized credentials cache\n");
#endif /* DEBUG */

#ifdef DEBUG
	fprintf(stderr, "Using credentials cache: \"%s\"\n", tkstring);
#endif /* DEBUG */

	memset((char *)&creds, 0, sizeof(creds));
	retval = krb5_build_principal(context, &creds.server, strlen(realm),
	    realm, KRB5_TGS_NAME, realm, 0);
	if (retval) {
		com_err("GSSD", errno, "while setting server principal name");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}

	/*
	 * Now fill in the client....
	 */
	if (retval = krb5_copy_principal(context, my_principal, &creds.client)) {
		com_err("GSSD", retval, "While copying client principal");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	if (retval = krb5_kt_resolve(context, srvtab, &keytab)) {
		com_err("GSSD", retval, "while resolving keytab");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	/* ANDROS add etype to specify DES cbc mode with CRC-32 */
	if ((retval = krb5_kt_start_seq_get(context, keytab, &cur))) {
		com_err("GSSD", retval, "while starting keytab scan");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	retval = krb5_kt_next_entry(context, keytab, &entry, &cur);
	if (retval) {
		com_err("GSSD", retval, "while getting keytab entry\n");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}
	/* (in == initial) */
	retval = krb5_get_in_tkt_with_keytab(context, 0, 0, &entry.key.enctype,
	    NULL, keytab, ccache, &creds, 0);
	if (retval) {
		com_err("GSSD", retval, "while getting initial ticket\n");
		(void) krb5_cc_destroy(context, ccache);
		goto out;
	}

#ifdef DEBUG
	else 
		fprintf(stderr, "Acquired initial kerberos ticket\n");
#endif /* DEBUG */

 out:
	if (keytab != NULL)
		(void)krb5_kt_close(context, keytab);
	
	return (retval == 0);
}


void
gss_kt_destroy_tickets(void)
{
	fprintf(stderr,"gss_kt_destroy_tickets\n");
}
