/*
 *  RPC portmap client.
 *
 *  Copyright (c) 2000 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Weston Andros Adamson   <muzzle@citi.umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: rpc_pmap.h,v 1.1 2002/10/16 05:04:26 muzzle Exp $
 */
#ifndef _RPC_PMAP_H_
#define _RPC_PMAP_H_

/* pmap procs */
#define PMAP_SET                1
#define PMAP_UNSET              2
#define PMAP_GETPORT            3

#define RPC_PMAP_PROGRAM     	100000
#define RPC_PMAP_VERSION     	2
#define PMAP_PORT		111

#define RPC_GSSD_PROGRAM        100666
#define RPC_GSSD_VERSION        1


struct rpc_pmap_map {
	u_int32_t 	program;
	u_int32_t 	version;
	u_int32_t	prot; 		/* IPPROTO_* from netinet/in.h */
	u_int32_t 	port;
};

void sys_rpc_pmap_test(void);

/* no need to set the sin_port member of sockaddr_in before calling 
 * this function... as it is fixed, it is automatically set */
int rpc_pmap_getport( u_int32_t, u_int32_t, u_int32_t, struct sockaddr_in *, 
	int *);

/* XXX interface should probably be this: */
#if 0
int rpc_pmap_getport(struct rpcclnt *);
int rpc_pmap_set(struct rpcclnt *);
int rpc_pmap_unset(struct rpcclnt *);
#endif

#endif /* _RPC_PMAP_H_ */
