/*
 *  RPC portmap client.
 *
 *  Copyright (c) 2000 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Weston Andros Adamson   <muzzle@citi.umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: rpc_pmap.c,v 1.3 2003/03/02 07:09:52 rees Exp $
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/socket.h>
#include <sys/mbuf.h>
#include <sys/socketvar.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <rpc/rpcclnt.h>
#include <rpc/rpcv2.h>
#include <rpc/rpc_pmap.h>

//#if 0
/* a simple test of the gssd client. 
 * to use it add this as a system call */
void
sys_rpc_pmap_test(void)
{
	struct sockaddr_in sin;
	int error, port = 0;

	sin.sin_family = AF_INET;
	sin.sin_addr.s_addr = INADDR_LOOPBACK;	
	sin.sin_len = sizeof(struct sockaddr_in);

	/* rpc_pmap() sets sin_port to the well known portmap port */
	error = rpc_pmap_getport(RPC_PMAP_PROGRAM, RPC_PMAP_VERSION, 
			IPPROTO_UDP, &sin, &port);

	printf("rpc_pmap returned port %d w/ error %d\n", port, error);
}
//#endif


/* returns *port=0 if no program is not found by portmapper */
/* no need to set the sin_port member of sockaddr_in before calling 
 * this function... it is automatically set */

/* XXX curruntly uses its own rpcclnt{}, while it should use a preexisting 
 *  rpcclnt{} as its only argument. */
int
rpc_pmap_getport(program, version, prot, sin, port)
	u_int32_t program;
	u_int32_t version;
	u_int32_t prot;
	struct sockaddr_in * sin;
	int * port;
{
	int status = 0;
	struct mbuf *nam, *m;
	struct rpcclnt * rpc;
	struct rpc_reply rep;
	int offp;
	struct rpc_pmap_map * mp;
	u_int32_t * p;

	if (sin == NULL) {
		RPCDEBUG("NULL sockaddr_in");
		return EFAULT;
	}

	sin->sin_port = htons(PMAP_PORT);

	if (sin->sin_family != AF_INET) {
		return EINVAL;
 	}
	
	if ((u_int)sin->sin_len > MCLBYTES) {
		return EINVAL;
	}

	nam = m_get(M_WAIT, MT_SONAME);	
	if ((u_int)sin->sin_len > MLEN) {
		MCLGET(nam, M_WAITOK);
		if ((nam->m_flags & M_EXT) == 0) {
			m_free(nam);
			return ENOBUFS;
		}
	}

	bcopy(sin, mtod(nam, void *), sin->sin_len);
	nam->m_len = sin->sin_len;
	
	rpcclnt_get(rpc);
	bzero(rpc, sizeof(struct rpcclnt));	

	RPCDEBUG("CALL SETUP/CONNECT");
	status = rpcclnt_setup(rpc, RPCCLNT_SOFT, nam,
		SOCK_DGRAM, 0, RPC_PMAP_PROGRAM, RPC_PMAP_VERSION,  "portmap", 
		sizeof(struct rpc_pmap_map), sizeof(struct rpc_pmap_map));

	if (status) {
		RPCDEBUG("rpcclnt_setup returns error %d", status);
		m_free(nam);
		rpcclnt_put(rpc);
		return status;
	}

	/* marshall the parameters */
	m = m_get(M_WAIT, MT_DATA);
	m->m_len = sizeof(struct rpc_pmap_map);
	mp = mtod(m, struct rpc_pmap_map *);

	mp->program = htonl(program);
	mp->version = htonl(version);
	mp->prot = htonl(prot);
	mp->port = 0;
		
	/* set root creds */
	rpcclnt_setauth(rpc, RPCAUTH_UNIX, 0, NULL, 0, NULL, curproc->p_ucred);

	RPCDEBUG("CALL REQUEST\n");
	status = rpcclnt_request(rpc, m, PMAP_GETPORT, curproc, &rep);

	if (status) {
		RPCDEBUG("rpcclnt_request returned error %d", status);
		m_freem(m);
		goto out;
	}
	/* if _request succeeds, it will free m */

	status = rpcclnt_err(&rep);	
	
	if (status) {
		RPCDEBUG("error returned from portmapper.");
		goto out;
	}

	m = m_pulldown(rep.result_md, rep.result_dpos - 
		mtod(rep.result_md, caddr_t), RPCX_UNSIGNED, &offp);

	if (m == NULL) {
		RPCDEBUG("m_pulldown seems to have failed!");
		status = EFAULT;
		goto out;
	}

	p = (u_int32_t *)(mtod(m, caddr_t) + offp);

	*port = ntohl(*p);	
	rpcclnt_disconnect(rpc);
	rpcclnt_put(rpc);
	m_freem(rep.mrep);
	m_free(nam);
	return 0;
out:
	rpcclnt_disconnect(rpc);
	rpcclnt_put(rpc);
	m_freem(nam);
	return status;
}
