/*	$Id: nfs4_socket.c,v 1.20 2003/06/20 17:05:10 rees Exp $	*/
/*	$OpenBSD: nfs_socket.c,v 1.26 2002/04/11 18:44:24 millert Exp $	*/
/*	$NetBSD: nfs_socket.c,v 1.27 1996/04/15 20:20:00 thorpej Exp $	*/

/*
 * Copyright (c) 1989, 1991, 1993, 1995
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Rick Macklem at The University of Guelph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)nfs_socket.c	8.5 (Berkeley) 3/30/95
 */

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 *
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 *
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

/*
 * Socket operations for use by nfs
 */

#include <sys/param.h>
#include <sys/systm.h>
#include <sys/proc.h>
#include <sys/mount.h>
#include <sys/kernel.h>
#include <sys/mbuf.h>
#include <sys/vnode.h>
#include <sys/domain.h>
#include <sys/protosw.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/syslog.h>
#include <sys/namei.h>
#include <sys/malloc.h>

#include <netinet/in.h>
#include <netinet/tcp.h>

#include <rpc/rpcclnt.h>

#include <nfs/rpcv2.h>
#include <nfs/nfsproto.h>
#include <nfs/nfs.h>

#include <rpc/xdr_subs.h>

#include <nfs4/list.h>
#include <nfs4/nfs4_prot.h>
#include <nfs4/nfs4_debug.h>
#include <nfs4/nfs4.h>
#include <nfs4/nfs4mount.h>
#include <nfs4/nfs4fs.h>
#include <nfs4/nfs4node.h>
#include <nfs4/nfsm_subs.h>
#include <nfs4/nfs4_var.h>

#define	TRUE	1
#define	FALSE	0

/*
 * External data, mostly RPC constants in XDR form
 */
extern u_int32_t rpc_reply, rpc_msgdenied, rpc_mismatch, rpc_vers,
	rpc_auth_unix, rpc_msgaccepted, rpc_call, rpc_autherr,
	rpc_auth_kerb;
extern u_int32_t nfs_prog;
extern int nfsv3_procid[NFS_NPROCS];

struct nfsstats nfsstats;

/* XXX:  having different rtts depending on proc # doesn't make sense,
     because everything is a compound call in v4 */
#if 0
/*
 * Defines which timer to use for the procnum.
 * 0 - default
 * 1 - getattr
 * 2 - lookup
 * 3 - read
 * 4 - write
 */
static int proct[NFS_NPROCS] = {
	0, 1, 0, 2, 1, 3, 3, 4, 0, 0, 0, 0, 0, 0, 0, 0, 3, 3, 0, 0, 0, 0, 0,
	0, 0, 0,
};
#endif

/*
 * Initialize sockets and congestion for a new NFS connection.
 * We do not free the sockaddr if error.
 */
int
nfs_connect(nmp, rep)
	struct nfs4mount *nmp;
	struct rpctask *rep;
{
	struct rpcclnt * rpc = &nmp->nm_rpcclnt;

	rpc->rc_progid = NFS_PROG;
	rpc->rc_progvers = NFS_VER4;
	rpc->rc_flag = nmp->nm_flag;

	rpc->rc_servername = nmp->nm_mountp->mnt_stat.f_mntfromname;

	rpc->rc_rsize = (rpc->rc_rsize > nmp->nm_readdirsize) ?
			rpc->rc_rsize : nmp->nm_readdirsize;

	/* set per rpc proc rtt setting */
	rpc->rc_rtton = 0;
#if 0
	rpc->rc_proctlen = NFS_NPROCS;
	rpc->rc_proct = proct;
#else
	rpc->rc_proctlen = 0;
	rpc->rc_proct = NULL;
#endif

	return rpcclnt_connect(rpc);
}

/*
 * NFS disconnect. Clean up and unlink.
 */
void
nfs_disconnect(nmp)
	struct nfs4mount *nmp;
{
	rpcclnt_disconnect(&nmp->nm_rpcclnt);
}

/*
 * nfs_request - goes something like this
 * 	- initialize rpc_reply structure
 * 	- calls rpc_request
 * 	- frees reply upon error
 * 	- always frees mrest
 *
 */
int
nfs_request(nmp, mrest, procnum, procp, cred, mrep, mdp, dposp)
	struct nfs4mount *nmp;
	struct mbuf *mrest;
	int procnum;
	struct proc *procp;
	struct ucred *cred;
	struct mbuf ** mrep;
	struct mbuf ** mdp;
	caddr_t * dposp;
{
	int error = 0;
	int auth_len, auth_type;
	int failed_auth = 0;
	int verf_len;
	char *auth_str, *verf_str;
	struct rpc_reply reply;

	/*
	 * Get the RPC header with authorization.
	 */
kerbauth:
	verf_str = auth_str = NULL;
	if (nmp->nm_flag & NFSMNT_KERB) {
#if 0
		struct rpctask *rep;
		char nickv[RPCX_NICKVERF];
		NFSKERBKEY_T key;		/* save session key */

		verf_str = nickv;
		verf_len = sizeof (nickv);
		auth_type = RPCAUTH_KERB4;
		bzero((caddr_t)key, sizeof (key));
		if (failed_auth || nfs_getnickauth(nmp, cred, &auth_str,
			&auth_len, verf_str, verf_len)) {
			error = nfs_getauth(nmp, rep, cred, &auth_str,
				&auth_len, verf_str, &verf_len, key);
			if (error) {
				free((caddr_t)rep, M_NFSREQ);
				m_freem(mrest);
				return (error);
			}
		}
#else
		printf("auth_kerb\n");
#endif
	} else {
		auth_type = RPCAUTH_UNIX;
		auth_len = (((cred->cr_ngroups > nmp->nm_numgrps) ?
			nmp->nm_numgrps : cred->cr_ngroups) << 2) +
			5 * NFSX_UNSIGNED;
	}


	rpcclnt_setauth(&nmp->nm_rpcclnt, auth_type, auth_len, auth_str,
			verf_len, verf_str, cred);


	if ((error = rpcclnt_request(&nmp->nm_rpcclnt, mrest, procnum, procp,
	     &reply)) != 0) {
		if (auth_str)
 	               FREE(auth_str, M_TEMP);
       		if (verf_str)
               		 FREE(verf_str, M_TEMP);

		goto out;
	}

	if (auth_str)
		FREE(auth_str, M_TEMP);

	if (verf_str)
		FREE(verf_str, M_TEMP);

	error = rpcclnt_err(&reply);

	if ((nmp->nm_flag & NFSMNT_KERB) && error == EACCES && !failed_auth) {
			failed_auth++;
			/* try again */
			goto kerbauth;
	}

#if 0
	if (reply.stat.type == RPC_MSGACCEPTED && (nmp->nm_flag & NFSMNT_KERB)
		&& (reply.verf_type == RPCAUTH_KERB4)) {
		error = nfs_savenickauth(nmp, cred, reply.verf_size, key,
			&reply.verf_md, &reply.verf_dpos, reply.mrep);
	}
#endif

	if (error)
		goto out;

	m_freem(mrest);
	*mrep = reply.mrep;
	*mdp = reply.result_md;
	*dposp = reply.result_dpos;
	return (0);
out:
	m_freem(mrest);
	m_freem(reply.mrep);
	*mrep = NULL;
	*mdp = NULL;
        return (error);
}

/*
 * Test for a termination condition pending on the process.
 * This is used for NFSMNT_INT mounts.
 */
int
nfs_sigintr(nmp, rep, p)
	struct nfs4mount *nmp;
        struct rpctask *rep;
	struct proc *p;
{
        return rpcclnt_sigintr(&nmp->nm_rpcclnt, rep, p);
}
