/*	$Id: nfs4_prot.h,v 1.12 2003/06/20 17:05:09 rees Exp $	*/

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

/*
 * This file was originally generated using rpcgen, but has been heavily modified.
 */

#ifndef _NFS4_PROT_H_RPCGEN
#define _NFS4_PROT_H_RPCGEN

#ifndef NFS_VER4
#define NFS_VER4	4
#endif

#define xdr_uint32_t xdr_u_int32_t

#ifndef XDR_QUADLEN
# define XDR_QUADLEN(l) (((l) + 3) >> 2)
#endif

#define XDR_LEN(l)   (((l) + 3) & ~0x3)

#define NFS4_FHSIZE 128
#define NFS4_VERIFIER_SIZE 8

#define NFS4_PROGRAM 100003

#define NFSPROC4_NULL 0
#define NFSPROC4_COMPOUND 1
#define NFS4_CALLBACK 40000000
#define NFS_CB 1

#define CB_NULL 0
#define CB_COMPOUND 1

enum nfs_ftype4 {
	NF4NON = 0,
	NF4REG = 1,
	NF4DIR = 2,
	NF4BLK = 3,
	NF4CHR = 4,
	NF4LNK = 5,
	NF4SOCK = 6,
	NF4FIFO = 7,
	NF4ATTRDIR = 8,
	NF4NAMEDATTR = 9,
	NF4BAD = 10
};
typedef enum nfs_ftype4 nfs_ftype4;

enum nfsstat4 {
	NFS4_OK                 = 0,    /* everything is okay      */
	NFS4ERR_PERM            = 1,    /* caller not privileged   */
	NFS4ERR_NOENT           = 2,    /* no such file/directory  */
	NFS4ERR_IO              = 5,    /* hard I/O error          */
	NFS4ERR_NXIO            = 6,    /* no such device          */
	NFS4ERR_ACCESS          = 13,   /* access denied           */
	NFS4ERR_EXIST           = 17,   /* file already exists     */
	NFS4ERR_XDEV            = 18,   /* different filesystems   */
	NFS4ERR_NODEV           = 19,   /* no such device          */
	NFS4ERR_NOTDIR          = 20,   /* should be a directory   */
	NFS4ERR_ISDIR           = 21,   /* should not be directory */
	NFS4ERR_INVAL           = 22,   /* invalid argument        */
	NFS4ERR_FBIG            = 27,   /* file exceeds server max */
	NFS4ERR_NOSPC           = 28,   /* no space on filesystem  */
	NFS4ERR_ROFS            = 30,   /* read-only filesystem    */
	NFS4ERR_MLINK           = 31,   /* too many hard links     */
	NFS4ERR_NAMETOOLONG     = 63,   /* name exceeds server max */
	NFS4ERR_NOTEMPTY        = 66,   /* directory not empty     */
	NFS4ERR_DQUOT           = 69,   /* hard quota limit reached*/
	NFS4ERR_STALE           = 70,   /* file no longer exists   */
	NFS4ERR_BADHANDLE       = 10001,/* Illegal filehandle      */
	NFS4ERR_BAD_COOKIE      = 10003,/* READDIR cookie is stale */
	NFS4ERR_NOTSUPP         = 10004,/* operation not supported */
	NFS4ERR_TOOSMALL        = 10005,/* buffer too small        */
	NFS4ERR_SERVERFAULT     = 10006,/* undefined server error  */
	NFS4ERR_BADTYPE         = 10007,/* type invalide for CREATE*/
	NFS4ERR_DELAY           = 10008,/* file "busy" - retry     */
	NFS4ERR_SAME            = 10009,/* nverify says attrs same */
	NFS4ERR_DENIED          = 10010,/* lock unavailable        */
	NFS4ERR_EXPIRED         = 10011,/* lock lease expired      */
	NFS4ERR_LOCKED          = 10012,/* I/O failed due to lock  */
	NFS4ERR_GRACE           = 10013,/* in grace period         */
	NFS4ERR_FHEXPIRED       = 10014,/* filehandle expired      */
	NFS4ERR_SHARE_DENIED    = 10015,/* share reserve denied    */
	NFS4ERR_WRONGSEC        = 10016,/* wrong security flavor   */
	NFS4ERR_CLID_INUSE      = 10017,/* clientid in use         */
	NFS4ERR_RESOURCE        = 10018,/* resource exhaustion     */
	NFS4ERR_MOVED           = 10019,/* filesystem relocated    */
	NFS4ERR_NOFILEHANDLE    = 10020,/* current FH is not set   */
	NFS4ERR_MINOR_VERS_MISMATCH = 10021,/* minor vers not supp */
	NFS4ERR_STALE_CLIENTID  = 10022,/* server has rebooted     */
	NFS4ERR_STALE_STATEID   = 10023,/* server has rebooted     */
	NFS4ERR_OLD_STATEID     = 10024,/* state is out of sync    */
	NFS4ERR_BAD_STATEID     = 10025,/* incorrect stateid       */
	NFS4ERR_BAD_SEQID       = 10026,/* request is out of seq.  */
	NFS4ERR_NOT_SAME        = 10027,/* verify - attrs not same */
	NFS4ERR_LOCK_RANGE      = 10028,/* lock range not supported*/
	NFS4ERR_SYMLINK         = 10029,/* should be file/directory*/
	NFS4ERR_READDIR_NOSPC   = 10030,/* response limit exceeded */
	NFS4ERR_LEASE_MOVED     = 10031,/* some filesystem moved   */
	NFS4ERR_ATTRNOTSUPP     = 10032,/* recommended attr not sup*/
	NFS4ERR_NO_GRACE        = 10033,/* reclaim outside of grace*/
	NFS4ERR_RECLAIM_BAD     = 10034,/* reclaim error at server */
	NFS4ERR_RECLAIM_CONFLICT = 10035,/* conflict on reclaim    */
	NFS4ERR_BADXDR          = 10036,/* XDR decode failed       */
	NFS4ERR_LOCKS_HELD      = 10037,/* file lcoks held at CLOSE*/
	NFS4ERR_OPENMODE        = 10038,/* conflict in OPEN and I/O*/
	NFS4ERR_BADOWNER        = 10039,/* owner translation bad   */
	NFS4ERR_BADCHAR         = 10040,/* utf-8 char not supported*/
	NFS4ERR_BADNAME         = 10041,/* name not supported      */
	NFS4ERR_BAD_RANGE       = 10042,/* lock range not supported*/
	NFS4ERR_LOCK_NOTSUPP    = 10043,/* no atomic up/downgrade  */
	NFS4ERR_OP_ILLEGAL      = 10044,/* undefined operation     */
	NFS4ERR_DEADLOCK        = 10045,/* file locking deadlock   */
	NFS4ERR_FILE_OPEN       = 10046,/* open file blocks op.    */
	NFS4ERR_RETRY_COMPOUND  = 20001
};

typedef enum nfsstat4 nfsstat4;

typedef struct {
	u_int bitmap4_len;
	uint32_t *bitmap4_val;
} bitmap4;
#define BLEN bitmap4_len
#define BVAL bitmap4_val

typedef uint64_t offset4;

typedef uint32_t count4;

typedef uint64_t length4;

typedef uint64_t clientid4;

typedef char stateid4[16];

typedef uint32_t seqid4;

typedef struct {
	u_int utf8string_len;
	char *utf8string_val;
} utf8string;

typedef utf8string component4;

typedef struct {
	u_int pathname4_len;
	component4 *pathname4_val;
} pathname4;

typedef uint64_t nfs_lockid4;

typedef uint64_t nfs_cookie4;

typedef utf8string linktext4;

typedef struct {
	u_int sec_oid4_len;
	char *sec_oid4_val;
} sec_oid4;

typedef uint32_t qop4;

typedef uint32_t mode4;

typedef uint64_t changeid4;

typedef char verifier4[NFS4_VERIFIER_SIZE];

struct nfstime4 {
	int64_t seconds;
	uint32_t nseconds;
};
typedef struct nfstime4 nfstime4;

enum time_how4 {
	SET_TO_SERVER_TIME4 = 0,
	SET_TO_CLIENT_TIME4 = 1
};
typedef enum time_how4 time_how4;

struct settime4 {
	time_how4 set_it;
	union {
		nfstime4 time;
	} settime4_u;
};
typedef struct settime4 settime4;

typedef struct {
	u_int nfs_fh4_len;
	char *nfs_fh4_val;
} nfs_fh4;

struct fsid4 {
	uint64_t major;
	uint64_t minor;
};
typedef struct fsid4 fsid4;

struct fs_location4 {
	struct {
		u_int server_len;
		utf8string *server_val;
	} server;
	pathname4 rootpath;
};
typedef struct fs_location4 fs_location4;

struct fs_locations4 {
	pathname4 fs_root;
	struct {
		u_int locations_len;
		fs_location4 *locations_val;
	} locations;
};
typedef struct fs_locations4 fs_locations4;
#define ACL4_SUPPORT_ALLOW_ACL 0x00000001
#define ACL4_SUPPORT_DENY_ACL 0x00000002
#define ACL4_SUPPORT_AUDIT_ACL 0x00000004
#define ACL4_SUPPORT_ALARM_ACL 0x00000008

typedef uint32_t acetype4;
#define ACE4_ACCESS_ALLOWED_ACE_TYPE 0x00000000
#define ACE4_ACCESS_DENIED_ACE_TYPE 0x00000001
#define ACE4_SYSTEM_AUDIT_ACE_TYPE 0x00000002
#define ACE4_SYSTEM_ALARM_ACE_TYPE 0x00000003

typedef uint32_t aceflag4;
#define ACE4_FILE_INHERIT_ACE 0x00000001
#define ACE4_DIRECTORY_INHERIT_ACE 0x00000002
#define ACE4_NO_PROPAGATE_INHERIT_ACE 0x00000004
#define ACE4_INHERIT_ONLY_ACE 0x00000008
#define ACE4_SUCCESSFUL_ACCESS_ACE_FLAG 0x00000010
#define ACE4_FAILED_ACCESS_ACE_FLAG 0x00000020
#define ACE4_IDENTIFIER_GROUP 0x00000040

typedef uint32_t acemask4;
#define ACE4_READ_DATA 0x00000001
#define ACE4_LIST_DIRECTORY 0x00000001
#define ACE4_WRITE_DATA 0x00000002
#define ACE4_ADD_FILE 0x00000002
#define ACE4_APPEND_DATA 0x00000004
#define ACE4_ADD_SUBDIRECTORY 0x00000004
#define ACE4_READ_NAMED_ATTRS 0x00000008
#define ACE4_WRITE_NAMED_ATTRS 0x00000010
#define ACE4_EXECUTE 0x00000020
#define ACE4_DELETE_CHILD 0x00000040
#define ACE4_READ_ATTRIBUTES 0x00000080
#define ACE4_WRITE_ATTRIBUTES 0x00000100
#define ACE4_DELETE 0x00010000
#define ACE4_READ_ACL 0x00020000
#define ACE4_WRITE_ACL 0x00040000
#define ACE4_WRITE_OWNER 0x00080000
#define ACE4_SYNCHRONIZE 0x00100000
#define ACE4_GENERIC_READ 0x00120081
#define ACE4_GENERIC_WRITE 0x00160106
#define ACE4_GENERIC_EXECUTE 0x001200A0

struct nfsace4 {
	acetype4 type;
	aceflag4 flag;
	acemask4 access_mask;
	utf8string who;
};
typedef struct nfsace4 nfsace4;

struct specdata4 {
	uint32_t specdata1;
	uint32_t specdata2;
};
typedef struct specdata4 specdata4;
#define FH4_PERSISTENT 0x00000000
#define FH4_NOEXPIRE_WITH_OPEN 0x00000001
#define FH4_VOLATILE_ANY 0x00000002
#define FH4_VOL_MIGRATION 0x00000004
#define FH4_VOL_RENAME 0x00000008

typedef bitmap4 fattr4_supported_attrs;

typedef nfs_ftype4 fattr4_type;

typedef uint32_t fattr4_fh_expire_type;

typedef changeid4 fattr4_change;

typedef uint64_t fattr4_size;




typedef fsid4 fattr4_fsid;


typedef uint32_t fattr4_lease_time;

typedef nfsstat4 fattr4_rdattr_error;

typedef struct {
	u_int fattr4_acl_len;
	nfsace4 *fattr4_acl_val;
} fattr4_acl;
#define FLEN    fattr4_acl_len
#define FVAL    fattr4_acl_val

typedef uint32_t fattr4_aclsupport;






typedef uint64_t fattr4_fileid;

typedef uint64_t fattr4_files_avail;

typedef nfs_fh4 fattr4_filehandle;

typedef uint64_t fattr4_files_free;

typedef uint64_t fattr4_files_total;

typedef fs_locations4 fattr4_fs_locations;



typedef uint64_t fattr4_maxfilesize;

typedef uint32_t fattr4_maxlink;

typedef uint32_t fattr4_maxname;

typedef uint64_t fattr4_maxread;

typedef uint64_t fattr4_maxwrite;

typedef utf8string fattr4_mimetype;

typedef mode4 fattr4_mode;


typedef uint32_t fattr4_numlinks;

typedef utf8string fattr4_owner;

typedef utf8string fattr4_owner_group;

typedef uint64_t fattr4_quota_hard;

typedef uint64_t fattr4_quota_soft;

typedef uint64_t fattr4_quota_used;

typedef specdata4 fattr4_rawdev;

typedef uint64_t fattr4_space_avail;

typedef uint64_t fattr4_space_free;

typedef uint64_t fattr4_space_total;

typedef uint64_t fattr4_space_used;


typedef nfstime4 fattr4_time_access;

typedef settime4 fattr4_time_access_set;

typedef nfstime4 fattr4_time_backup;

typedef nfstime4 fattr4_time_create;

typedef nfstime4 fattr4_time_delta;

typedef nfstime4 fattr4_time_metadata;

typedef nfstime4 fattr4_time_modify;

typedef settime4 fattr4_time_modify_set;
#define FATTR4_SUPPORTED_ATTRS 0
#define FATTR4_TYPE 1
#define FATTR4_FH_EXPIRE_TYPE 2
#define FATTR4_CHANGE 3
#define FATTR4_SIZE 4
#define FATTR4_LINK_SUPPORT 5
#define FATTR4_SYMLINK_SUPPORT 6
#define FATTR4_NAMED_ATTR 7
#define FATTR4_FSID 8
#define FATTR4_UNIQUE_HANDLES 9
#define FATTR4_LEASE_TIME 10
#define FATTR4_RDATTR_ERROR 11
#define FATTR4_ACL 12
#define FATTR4_ACLSUPPORT 13
#define FATTR4_ARCHIVE 14
#define FATTR4_CANSETTIME 15
#define FATTR4_CASE_INSENSITIVE 16
#define FATTR4_CASE_PRESERVING 17
#define FATTR4_CHOWN_RESTRICTED 18
#define FATTR4_FILEHANDLE 19
#define FATTR4_FILEID 20
#define FATTR4_FILES_AVAIL 21
#define FATTR4_FILES_FREE 22
#define FATTR4_FILES_TOTAL 23
#define FATTR4_FS_LOCATIONS 24
#define FATTR4_HIDDEN 25
#define FATTR4_HOMOGENEOUS 26
#define FATTR4_MAXFILESIZE 27
#define FATTR4_MAXLINK 28
#define FATTR4_MAXNAME 29
#define FATTR4_MAXREAD 30
#define FATTR4_MAXWRITE 31
#define FATTR4_MIMETYPE 32
#define FATTR4_MODE 33
#define FATTR4_NO_TRUNC 34
#define FATTR4_NUMLINKS 35
#define FATTR4_OWNER 36
#define FATTR4_OWNER_GROUP 37
#define FATTR4_QUOTA_HARD 38
#define FATTR4_QUOTA_SOFT 39
#define FATTR4_QUOTA_USED 40
#define FATTR4_RAWDEV 41
#define FATTR4_SPACE_AVAIL 42
#define FATTR4_SPACE_FREE 43
#define FATTR4_SPACE_TOTAL 44
#define FATTR4_SPACE_USED 45
#define FATTR4_SYSTEM 46
#define FATTR4_TIME_ACCESS 47
#define FATTR4_TIME_ACCESS_SET 48
#define FATTR4_TIME_BACKUP 49
#define FATTR4_TIME_CREATE 50
#define FATTR4_TIME_DELTA 51
#define FATTR4_TIME_METADATA 52
#define FATTR4_TIME_MODIFY 53
#define FATTR4_TIME_MODIFY_SET 54
#define FATTR4_ATTR_MAX 55

#define FATTR4_SET(n, p)	((p)[(n)/32] |= (1 << ((n) % 32)))
#define FATTR4_CLR(n, p)	((p)[(n)/32] &= ~(1 << ((n) % 32)))
#define FATTR4_ISSET(n, p)	((p)[(n)/32] & (1 << ((n) % 32)))
#define FATTR4_ZERO(p)		bzero((p), 8)
#define FATTR4_SKIP(p)		((p) += 2)
#define FATTR4_XDR_BITMAP(p, nw)		\
	do {					\
		int i;				\
		for (i=0; i<(nw); i++)		\
			(p)[i] = htonl((p)[i]);	\
	} while (0)

typedef struct {
	u_int attrlist4_len;
	char *attrlist4_val;
} attrlist4;

struct fattr4 {
	bitmap4 attrmask;
	attrlist4 attr_vals;
};
typedef struct fattr4 fattr4;
#define FATTRSLEN attr_vals.attrlist4_len
#define FATTRSVAL attr_vals.attrlist4_val

struct change_info4 {
	u_int atomic;
	changeid4 before;
	changeid4 after;
};
typedef struct change_info4 change_info4;

struct clientaddr4 {
	char *r_netid;
	char *r_addr;
};
typedef struct clientaddr4 clientaddr4;

struct cb_client4 {
	u_int cb_program;
	clientaddr4 cb_location;
};
typedef struct cb_client4 cb_client4;

struct nfs_client_id4 {
	verifier4 verifier;
	struct {
		u_int id_len;
		char *id_val;
	} id;
};
typedef struct nfs_client_id4 nfs_client_id4;

struct nfs_lockowner4 {
	clientid4 clientid;
	struct {
		u_int owner_len;
		char *owner_val;
	} owner;
};
typedef struct nfs_lockowner4 nfs_lockowner4;

enum nfs_lock_type4 {
	READ_LT = 1,
	WRITE_LT = 2,
	READW_LT = 3,
	WRITEW_LT = 4
};
typedef enum nfs_lock_type4 nfs_lock_type4;
#define ACCESS4_READ 0x00000001
#define ACCESS4_LOOKUP 0x00000002
#define ACCESS4_MODIFY 0x00000004
#define ACCESS4_EXTEND 0x00000008
#define ACCESS4_DELETE 0x00000010
#define ACCESS4_EXECUTE 0x00000020

struct ACCESS4args {
	uint32_t access;
};
typedef struct ACCESS4args ACCESS4args;

struct ACCESS4resok {
	uint32_t supported;
	uint32_t access;
};
typedef struct ACCESS4resok ACCESS4resok;
#define SUPPORTED ACCESS4res_u.resok4.supported
#define ACCESS ACCESS4res_u.resok4.access

struct ACCESS4res {
	nfsstat4 status;
	union {
		ACCESS4resok resok4;
	} ACCESS4res_u;
};
typedef struct ACCESS4res ACCESS4res;

struct CLOSE4args {
	seqid4 seqid;
	stateid4 stateid;
};
typedef struct CLOSE4args CLOSE4args;

struct CLOSE4res {
	nfsstat4 status;
	union {
		stateid4 stateid;
	} CLOSE4res_u;
};
typedef struct CLOSE4res CLOSE4res;

struct COMMIT4args {
	offset4 offset;
	count4 count;
};
typedef struct COMMIT4args COMMIT4args;

struct COMMIT4resok {
	verifier4 writeverf;
};
typedef struct COMMIT4resok COMMIT4resok;

struct COMMIT4res {
	nfsstat4 status;
	union {
		COMMIT4resok resok4;
	} COMMIT4res_u;
};
typedef struct COMMIT4res COMMIT4res;
#define COMMITVERF COMMIT4res_u.resok4.writeverf

struct createtype4 {
	nfs_ftype4 type;
	union {
		linktext4 linkdata;
		specdata4 devdata;
	} createtype4_u;
};
typedef struct createtype4 createtype4;

struct CREATE4args {
	component4 objname;
	createtype4 objtype;
};
typedef struct CREATE4args CREATE4args;

struct CREATE4resok {
	change_info4 cinfo;
};
typedef struct CREATE4resok CREATE4resok;

struct CREATE4res {
	nfsstat4 status;
	union {
		CREATE4resok resok4;
	} CREATE4res_u;
};
typedef struct CREATE4res CREATE4res;
#define CREATEinfo CREATE4res_u.resok4.cinfo

struct DELEGPURGE4args {
	clientid4 clientid;
};
typedef struct DELEGPURGE4args DELEGPURGE4args;

struct DELEGPURGE4res {
	nfsstat4 status;
};
typedef struct DELEGPURGE4res DELEGPURGE4res;

struct DELEGRETURN4args {
	stateid4 stateid;
};
typedef struct DELEGRETURN4args DELEGRETURN4args;

struct DELEGRETURN4res {
	nfsstat4 status;
};
typedef struct DELEGRETURN4res DELEGRETURN4res;

struct GETATTR4args {
	bitmap4 attr_request;
};
typedef struct GETATTR4args GETATTR4args;

struct GETATTR4resok {
	fattr4 obj_attributes;
};
typedef struct GETATTR4resok GETATTR4resok;
#define GFATTR4 GETATTR4res_u.resok4.obj_attributes

struct GETATTR4res {
	nfsstat4 status;
	union {
		GETATTR4resok resok4;
	} GETATTR4res_u;
};
typedef struct GETATTR4res GETATTR4res;

struct GETFH4resok {
	nfs_fh4 object;
};
typedef struct GETFH4resok GETFH4resok;
#define GETFH4FH GETFH4res_u.resok4.object

struct GETFH4res {
	nfsstat4 status;
	union {
		GETFH4resok resok4;
	} GETFH4res_u;
};
typedef struct GETFH4res GETFH4res;

struct LINK4args {
	component4 newname;
};
typedef struct LINK4args LINK4args;

struct LINK4resok {
	change_info4 cinfo;
};
typedef struct LINK4resok LINK4resok;
#define LINK_RES_INFO LINK4res_u.resok4.cinfo

struct LINK4res {
	nfsstat4 status;
	union {
		LINK4resok resok4;
	} LINK4res_u;
};
typedef struct LINK4res LINK4res;

struct LOCK4args {
	nfs_lock_type4 locktype;
	seqid4 seqid;
	stateid4 stateid;
	offset4 offset;
	length4 length;
};
typedef struct LOCK4args LOCK4args;

struct LOCK4denied {
	nfs_lockowner4 owner;
	offset4 offset;
	length4 length;
};
typedef struct LOCK4denied LOCK4denied;
#define DENIED_CLID    owner.clientid
#define DENIED_IDLEN   owner.owner.owner_len
#define DENIED_IDVAL   owner.owner.owner_val

struct LOCK4res {
	nfsstat4 status;
	union {
		stateid4 stateid;
		LOCK4denied denied;
	} LOCK4res_u;
};
typedef struct LOCK4res LOCK4res;
#define LOCK_DENIED    LOCK4res_u.denied

struct LOCKT4args {
	nfs_lock_type4 locktype;
	nfs_lockowner4 owner;
	offset4 offset;
	length4 length;
};
typedef struct LOCKT4args LOCKT4args;

struct LOCKT4res {
	nfsstat4 status;
	union {
		LOCK4denied denied;
	} LOCKT4res_u;
};
typedef struct LOCKT4res LOCKT4res;
#define LOCKT_DENIED    LOCKT4res_u.denied

struct LOCKU4args {
	nfs_lock_type4 type;
	seqid4 seqid;
	stateid4 stateid;
	offset4 offset;
	length4 length;
};
typedef struct LOCKU4args LOCKU4args;

struct LOCKU4res {
	nfsstat4 status;
	union {
		stateid4 stateid;
	} LOCKU4res_u;
};
typedef struct LOCKU4res LOCKU4res;

struct LOOKUP4args {
	pathname4 path;
};
typedef struct LOOKUP4args LOOKUP4args;
#define PLEN path.pathname4_len
#define PVAL path.pathname4_val

struct LOOKUP4res {
	nfsstat4 status;
};
typedef struct LOOKUP4res LOOKUP4res;

struct LOOKUPP4res {
	nfsstat4 status;
};
typedef struct LOOKUPP4res LOOKUPP4res;

struct NVERIFY4args {
	fattr4 obj_attributes;
};
typedef struct NVERIFY4args NVERIFY4args;

struct NVERIFY4res {
	nfsstat4 status;
};
typedef struct NVERIFY4res NVERIFY4res;

enum createmode4 {
	UNCHECKED4 = 0,
	GUARDED4 = 1,
	EXCLUSIVE4 = 2
};
typedef enum createmode4 createmode4;

struct createhow4 {
	createmode4 mode;
	union {
		fattr4 createattrs;
		verifier4 createverf;
	} createhow4_u;
};
typedef struct createhow4 createhow4;
#define CREATE_VERF createhow4_u.createverf
#define CREATE_ATTR createhow4_u.createattrs

enum opentype4 {
	OPEN4_NOCREATE = 0,
	OPEN4_CREATE = 1
};
typedef enum opentype4 opentype4;

struct openflag4 {
	opentype4 opentype;
	union {
		createhow4 how;
	} openflag4_u;
};
typedef struct openflag4 openflag4;
#define HOW_MODE openflag4_u.how.mode
#define HOW openflag4_u.how

enum limit_by4 {
	NFS_LIMIT_SIZE = 1,
	NFS_LIMIT_BLOCKS = 2
};
typedef enum limit_by4 limit_by4;

struct nfs_modified_limit4 {
	uint32_t num_blocks;
	uint32_t bytes_per_block;
};
typedef struct nfs_modified_limit4 nfs_modified_limit4;

struct nfs_space_limit4 {
	limit_by4 limitby;
	union {
		uint64_t filesize;
		nfs_modified_limit4 mod_blocks;
	} nfs_space_limit4_u;
};
typedef struct nfs_space_limit4 nfs_space_limit4;
#define OPEN4_SHARE_ACCESS_READ 0x00000001
#define OPEN4_SHARE_ACCESS_WRITE 0x00000002
#define OPEN4_SHARE_ACCESS_BOTH 0x00000003
#define OPEN4_SHARE_DENY_NONE 0x00000000
#define OPEN4_SHARE_DENY_READ 0x00000001
#define OPEN4_SHARE_DENY_WRITE 0x00000002
#define OPEN4_SHARE_DENY_BOTH 0x00000003

enum open_delegation_type4 {
	OPEN_DELEGATE_NONE = 0,
	OPEN_DELEGATE_READ = 1,
	OPEN_DELEGATE_WRITE = 2
};
typedef enum open_delegation_type4 open_delegation_type4;

enum open_claim_type4 {
	CLAIM_NULL = 0,
	CLAIM_PREVIOUS = 1,
	CLAIM_DELEGATE_CUR = 2,
	CLAIM_DELEGATE_PREV = 3
};
typedef enum open_claim_type4 open_claim_type4;

struct open_claim_delegate_cur4 {
	pathname4 file;
	stateid4 delegate_stateid;
};
typedef struct open_claim_delegate_cur4 open_claim_delegate_cur4;

struct open_claim4 {
	open_claim_type4 claim;
	union {
		pathname4 file;
		uint32_t delegate_type;
		open_claim_delegate_cur4 delegate_cur_info;
		pathname4 file_delegate_prev;
	} open_claim4_u;
};
typedef struct open_claim4 open_claim4;
#define CLAIM_FILE open_claim4_u.file
#define CLAIM_PATH_LEN open_claim4_u.file.pathname4_len
#define CLAIM_PATH_VAL open_claim4_u.file.pathname4_val

struct OPEN4args {
	open_claim4 claim;
	openflag4 openhow;
	nfs_lockowner4 owner;
	seqid4 seqid;
	uint32_t share_access;
	uint32_t share_deny;
};
typedef struct OPEN4args OPEN4args;
#define OWNER_LEN owner.owner.owner_len
#define OWNER_VAL owner.owner.owner_val

struct open_read_delegation4 {
	stateid4 stateid;
	nfsace4 permissions;
};
typedef struct open_read_delegation4 open_read_delegation4;

struct open_write_delegation4 {
	stateid4 stateid;
	nfs_space_limit4 space_limit;
	nfsace4 permissions;
};
typedef struct open_write_delegation4 open_write_delegation4;

struct open_delegation4 {
	open_delegation_type4 delegation_type;
	union {
		open_read_delegation4 read;
		open_write_delegation4 write;
	} open_delegation4_u;
};
typedef struct open_delegation4 open_delegation4;
#define OPEN4_RESULT_MLOCK 0x00000001
#define OPEN4_RESULT_CONFIRM 0x00000002

struct OPEN4resok {
	stateid4 stateid;
	change_info4 cinfo;
	uint32_t rflags;
	verifier4 open_confirm;
	open_delegation4 delegation;
};
typedef struct OPEN4resok OPEN4resok;
#define DEL_READ delegation.open_delegation4_u.read

struct OPEN4res {
	nfsstat4 status;
	union {
		OPEN4resok result;
	} OPEN4res_u;
};
typedef struct OPEN4res OPEN4res;
#define OPEN_RES OPEN4res_u.result
#define OPEN_VERF OPEN4res_u.result.open_confirm

struct OPENATTR4res {
	nfsstat4 status;
};
typedef struct OPENATTR4res OPENATTR4res;

struct OPEN_CONFIRM4args {
	seqid4 seqid;
	verifier4 open_confirm;
};
typedef struct OPEN_CONFIRM4args OPEN_CONFIRM4args;

struct OPEN_CONFIRM4resok {
	stateid4 stateid;
};
typedef struct OPEN_CONFIRM4resok OPEN_CONFIRM4resok;

struct OPEN_CONFIRM4res {
	nfsstat4 status;
	union {
		OPEN_CONFIRM4resok resok4;
	} OPEN_CONFIRM4res_u;
};
typedef struct OPEN_CONFIRM4res OPEN_CONFIRM4res;
#define OPEN_CON_RES OPEN_CONFIRM4res_u.resok4

struct OPEN_DOWNGRADE4args {
	stateid4 stateid;
	seqid4 seqid;
	uint32_t share_access;
	uint32_t share_deny;
};
typedef struct OPEN_DOWNGRADE4args OPEN_DOWNGRADE4args;

struct OPEN_DOWNGRADE4resok {
	stateid4 stateid;
};
typedef struct OPEN_DOWNGRADE4resok OPEN_DOWNGRADE4resok;

struct OPEN_DOWNGRADE4res {
	nfsstat4 status;
	union {
		OPEN_DOWNGRADE4resok resok4;
	} OPEN_DOWNGRADE4res_u;
};
typedef struct OPEN_DOWNGRADE4res OPEN_DOWNGRADE4res;

struct PUTFH4args {
	nfs_fh4 object;
};
typedef struct PUTFH4args PUTFH4args;

struct PUTFH4res {
	nfsstat4 status;
};
typedef struct PUTFH4res PUTFH4res;

struct PUTPUBFH4res {
	nfsstat4 status;
};
typedef struct PUTPUBFH4res PUTPUBFH4res;

struct PUTROOTFH4res {
	nfsstat4 status;
};
typedef struct PUTROOTFH4res PUTROOTFH4res;

struct READ4args {
	stateid4 stateid;
	offset4 offset;
	count4 count;
};
typedef struct READ4args READ4args;

struct READ4resok {
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct READ4resok READ4resok;

struct READ4res {
	nfsstat4 status;
	union {
		READ4resok resok4;
	} READ4res_u;
};
typedef struct READ4res READ4res;
#define READLEN READ4res_u.resok4.data.data_len
#define READVAL READ4res_u.resok4.data.data_val
#define READEOF READ4res_u.resok4.eof
#define READDATA READ4res_u.resok4.data

struct READDIR4args {
	nfs_cookie4 cookie;
	verifier4 cookieverf;
	count4 dircount;
	count4 maxcount;
	bitmap4 attr_request;
};
typedef struct READDIR4args READDIR4args;

struct entry4 {
	nfs_cookie4 cookie;
	component4 name;
	fattr4 attrs;
	struct entry4 *nextentry;
};
typedef struct entry4 entry4;

struct dirlist4 {
	entry4 *entries;
};
typedef struct dirlist4 dirlist4;

struct READDIR4resok {
	verifier4 cookieverf;
#ifndef __linux__
	dirlist4 reply;
#else
	int reply_len;
	char *reply_buf;
#endif
};
typedef struct READDIR4resok READDIR4resok;
#define DIR4 READDIR4res_u.resok4.reply
#define REOF READDIR4res_u.resok4.reply.eof
#define ENTRIES READDIR4res_u.resok4.reply.entries

struct READDIR4res {
	nfsstat4 status;
	union {
		READDIR4resok resok4;
	} READDIR4res_u;
};
typedef struct READDIR4res READDIR4res;

struct READLINK4resok {
	linktext4 link;
};
typedef struct READLINK4resok READLINK4resok;

struct READLINK4res {
	nfsstat4 status;
	union {
		READLINK4resok resok4;
	} READLINK4res_u;
};
typedef struct READLINK4res READLINK4res;
#define LINKVAL READLINK4res_u.resok4.link.utf8string_val

struct REMOVE4args {
	component4 target;
};
typedef struct REMOVE4args REMOVE4args;

struct REMOVE4resok {
	change_info4 cinfo;
};
typedef struct REMOVE4resok REMOVE4resok;

struct REMOVE4res {
	nfsstat4 status;
	union {
		REMOVE4resok resok4;
	} REMOVE4res_u;
};
typedef struct REMOVE4res REMOVE4res;

struct RENAME4args {
	component4 oldname;
	component4 newname;
};
typedef struct RENAME4args RENAME4args;
#define OLDNAME_VAL oldname.utf8string_val
#define NEWNAME_VAL newname.utf8string_val
#define OLDNAME_LEN oldname.utf8string_len
#define NEWNAME_LEN newname.utf8string_len

struct RENAME4resok {
	change_info4 source_cinfo;
	change_info4 target_cinfo;
};
typedef struct RENAME4resok RENAME4resok;

struct RENAME4res {
	nfsstat4 status;
	union {
		RENAME4resok resok4;
	} RENAME4res_u;
};
typedef struct RENAME4res RENAME4res;
#define RENAME_RES_SRC RENAME4res_u.resok4.source_cinfo
#define RENAME_RES_TAR RENAME4res_u.resok4.target_cinfo

struct RENEW4args {
	stateid4 stateid;
};
typedef struct RENEW4args RENEW4args;

struct RENEW4res {
	nfsstat4 status;
};
typedef struct RENEW4res RENEW4res;

struct RESTOREFH4res {
	nfsstat4 status;
};
typedef struct RESTOREFH4res RESTOREFH4res;

struct SAVEFH4res {
	nfsstat4 status;
};
typedef struct SAVEFH4res SAVEFH4res;

struct SECINFO4args {
	component4 name;
};
typedef struct SECINFO4args SECINFO4args;

enum rpc_gss_svc_t {
	RPC_GSS_SVC_NONE = 1,
	RPC_GSS_SVC_INTEGRITY = 2,
	RPC_GSS_SVC_PRIVACY = 3
};
typedef enum rpc_gss_svc_t rpc_gss_svc_t;

struct rpcsec_gss_info {
	sec_oid4 oid;
	qop4 qop;
	rpc_gss_svc_t service;
};
typedef struct rpcsec_gss_info rpcsec_gss_info;

struct secinfo4 {
	uint32_t flavor;
	struct {
		u_int flavor_info_len;
		char *flavor_info_val;
	} flavor_info;
};
typedef struct secinfo4 secinfo4;

typedef struct {
	u_int SECINFO4resok_len;
	secinfo4 *SECINFO4resok_val;
} SECINFO4resok;

struct SECINFO4res {
	nfsstat4 status;
	union {
		SECINFO4resok resok4;
	} SECINFO4res_u;
};
typedef struct SECINFO4res SECINFO4res;
#define SECRES SECINFO4res_u.resok4

struct SETATTR4args {
	stateid4 stateid;
	fattr4 obj_attributes;
};
typedef struct SETATTR4args SETATTR4args;

struct SETATTR4res {
	nfsstat4 status;
	bitmap4 attrsset;
};
typedef struct SETATTR4res SETATTR4res;

struct SETCLIENTID4args {
	nfs_client_id4 client;
	cb_client4 callback;
};
typedef struct SETCLIENTID4args SETCLIENTID4args;

struct SETCLIENTID4resok {
	clientid4 clientid;
	verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID4resok SETCLIENTID4resok;

struct SETCLIENTID4res {
	nfsstat4 status;
	union {
		SETCLIENTID4resok resok4;
		clientaddr4 client_using;
	} SETCLIENTID4res_u;
};
typedef struct SETCLIENTID4res SETCLIENTID4res;
#define CLIDOK SETCLIENTID4res_u.resok4

struct SETCLIENTID_CONFIRM4args {
	verifier4 setclientid_confirm;
};
typedef struct SETCLIENTID_CONFIRM4args SETCLIENTID_CONFIRM4args;

struct SETCLIENTID_CONFIRM4res {
	nfsstat4 status;
};
typedef struct SETCLIENTID_CONFIRM4res SETCLIENTID_CONFIRM4res;

struct VERIFY4args {
	fattr4 obj_attributes;
};
typedef struct VERIFY4args VERIFY4args;

struct VERIFY4res {
	nfsstat4 status;
};
typedef struct VERIFY4res VERIFY4res;

enum stable_how4 {
	UNSTABLE4 = 0,
	DATA_SYNC4 = 1,
	FILE_SYNC4 = 2
};
typedef enum stable_how4 stable_how4;

struct WRITE4args {
	stateid4 stateid;
	offset4 offset;
	stable_how4 stable;
	struct {
		u_int data_len;
		char *data_val;
	} data;
};
typedef struct WRITE4args WRITE4args;
#define WRITELEN data.data_len
#define WRITEVAL data.data_val

struct WRITE4resok {
	count4 count;
	stable_how4 committed;
	verifier4 writeverf;
};
typedef struct WRITE4resok WRITE4resok;

struct WRITE4res {
	nfsstat4 status;
	union {
		WRITE4resok resok4;
	} WRITE4res_u;
};
typedef struct WRITE4res WRITE4res;
#define WRITERES WRITE4res_u.resok4

enum nfs_opnum4 {
	OP_ACCESS = 3,
	OP_CLOSE = 4,
	OP_COMMIT = 5,
	OP_CREATE = 6,
	OP_DELEGPURGE = 7,
	OP_DELEGRETURN = 8,
	OP_GETATTR = 9,
	OP_GETFH = 10,
	OP_LINK = 11,
	OP_LOCK = 12,
	OP_LOCKT = 13,
	OP_LOCKU = 14,
	OP_LOOKUP = 15,
	OP_LOOKUPP = 16,
	OP_NVERIFY = 17,
	OP_OPEN = 18,
	OP_OPENATTR = 19,
	OP_OPEN_CONFIRM = 20,
	OP_OPEN_DOWNGRADE = 21,
	OP_PUTFH = 22,
	OP_PUTPUBFH = 23,
	OP_PUTROOTFH = 24,
	OP_READ = 25,
	OP_READDIR = 26,
	OP_READLINK = 27,
	OP_REMOVE = 28,
	OP_RENAME = 29,
	OP_RENEW = 30,
	OP_RESTOREFH = 31,
	OP_SAVEFH = 32,
	OP_SECINFO = 33,
	OP_SETATTR = 34,
	OP_SETCLIENTID = 35,
	OP_SETCLIENTID_CONFIRM = 36,
	OP_VERIFY = 37,
	OP_WRITE = 38
};
typedef enum nfs_opnum4 nfs_opnum4;

struct nfs_argop4 {
	nfs_opnum4 argop;
	union {
		ACCESS4args opaccess;
		CLOSE4args opclose;
		COMMIT4args opcommit;
		CREATE4args opcreate;
		DELEGPURGE4args opdelegpurge;
		DELEGRETURN4args opdelegreturn;
		GETATTR4args opgetattr;
		LINK4args oplink;
		LOCK4args oplock;
		LOCKT4args oplockt;
		LOCKU4args oplocku;
		LOOKUP4args oplookup;
		NVERIFY4args opnverify;
		OPEN4args opopen;
		OPEN_CONFIRM4args opopen_confirm;
		OPEN_DOWNGRADE4args opopen_downgrade;
		PUTFH4args opputfh;
		READ4args opread;
		READDIR4args opreaddir;
		REMOVE4args opremove;
		RENAME4args oprename;
		RENEW4args oprenew;
		SECINFO4args opsecinfo;
		SETATTR4args opsetattr;
		SETCLIENTID4args opsetclientid;
		SETCLIENTID_CONFIRM4args opsetclientid_confirm;
		VERIFY4args opverify;
		WRITE4args opwrite;
	} nfs_argop4_u;
};
typedef struct nfs_argop4 nfs_argop4;

struct nfs_resop4 {
	nfs_opnum4 resop;
	union {
		ACCESS4res opaccess;
		CLOSE4res opclose;
		COMMIT4res opcommit;
		CREATE4res opcreate;
		DELEGPURGE4res opdelegpurge;
		DELEGRETURN4res opdelegreturn;
		GETATTR4res opgetattr;
		GETFH4res opgetfh;
		LINK4res oplink;
		LOCK4res oplock;
		LOCKT4res oplockt;
		LOCKU4res oplocku;
		LOOKUP4res oplookup;
		LOOKUPP4res oplookupp;
		NVERIFY4res opnverify;
		OPEN4res opopen;
		OPENATTR4res opopenattr;
		OPEN_CONFIRM4res opopen_confirm;
		OPEN_DOWNGRADE4res opopen_downgrade;
		PUTFH4res opputfh;
		PUTPUBFH4res opputpubfh;
		PUTROOTFH4res opputrootfh;
		READ4res opread;
		READDIR4res opreaddir;
		READLINK4res opreadlink;
		REMOVE4res opremove;
		RENAME4res oprename;
		RENEW4res oprenew;
		RESTOREFH4res oprestorefh;
		SAVEFH4res opsavefh;
		SECINFO4res opsecinfo;
		SETATTR4res opsetattr;
		SETCLIENTID4res opsetclientid;
		SETCLIENTID_CONFIRM4res opsetclientid_confirm;
		VERIFY4res opverify;
		WRITE4res opwrite;
	} nfs_resop4_u;
};
typedef struct nfs_resop4 nfs_resop4;

struct COMPOUND4args {
	utf8string tag;
	uint32_t minorversion;
	struct {
		u_int argarray_len;
		nfs_argop4 *argarray_val;
	} argarray;
};
typedef struct COMPOUND4args COMPOUND4args;
#define OPVAL argarray.argarray_val
#define OPCNT argarray.argarray_len
#define OPU nfs_argop4_u

struct COMPOUND4res {
	nfsstat4 status;
	utf8string tag;
	struct {
		u_int resarray_len;
		nfs_resop4 *resarray_val;
	} resarray;
};
typedef struct COMPOUND4res COMPOUND4res;
#define RESCNT resarray.resarray_len
#define RESVAL resarray.resarray_val
#define RESU nfs_resop4_u

struct CB_GETATTR4args {
	nfs_fh4 fh;
	bitmap4 attr_request;
};
typedef struct CB_GETATTR4args CB_GETATTR4args;

struct CB_GETATTR4resok {
	fattr4 obj_attributes;
};
typedef struct CB_GETATTR4resok CB_GETATTR4resok;

struct CB_GETATTR4res {
	nfsstat4 status;
	union {
		CB_GETATTR4resok resok4;
	} CB_GETATTR4res_u;
};
typedef struct CB_GETATTR4res CB_GETATTR4res;

struct CB_RECALL4args {
	stateid4 stateid;
	nfs_fh4 fh;
};
typedef struct CB_RECALL4args CB_RECALL4args;

struct CB_RECALL4res {
	nfsstat4 status;
};
typedef struct CB_RECALL4res CB_RECALL4res;

enum nfs_cb_opnum4 {
	OP_CB_GETATTR = 3,
	OP_CB_RECALL = 4
};
typedef enum nfs_cb_opnum4 nfs_cb_opnum4;

struct nfs_cb_argop4 {
	u_int argop;
	union {
		CB_GETATTR4args opcbgetattr;
		CB_RECALL4args opcbrecall;
	} nfs_cb_argop4_u;
};
typedef struct nfs_cb_argop4 nfs_cb_argop4;

struct nfs_cb_resop4 {
	u_int resop;
	union {
		CB_GETATTR4res opcbgetattr;
		CB_RECALL4res opcbrecall;
	} nfs_cb_resop4_u;
};
typedef struct nfs_cb_resop4 nfs_cb_resop4;

struct CB_COMPOUND4args {
	utf8string tag;
	uint32_t minorversion;
	struct {
		u_int argarray_len;
		nfs_cb_argop4 *argarray_val;
	} argarray;
};
typedef struct CB_COMPOUND4args CB_COMPOUND4args;

struct CB_COMPOUND4res {
	nfsstat4 status;
	utf8string tag;
	struct {
		u_int resarray_len;
		nfs_cb_resop4 *resarray_val;
	} resarray;
};
typedef struct CB_COMPOUND4res CB_COMPOUND4res;

#endif /* !_NFS4_PROT_H_RPCGEN */
