/*
 *  GSSD client.
 *
 *  Copyright (c) 2000 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Weston Andros Adamson   <muzzle@citi.umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * $Id: nfs4_gss.h,v 1.2 2003/02/20 00:28:23 rees Exp $
 */

#ifndef _RPC_GSSD_CLNT_H_
#define _RPC_GSSD_CLNT_H_

#define GSSD_MAX_NAMELEN	1024
#define RPC_GSSD_PROGRAM        100666
#define RPC_GSSD_VERSION        1

#define GSS_OWNER              0
#define GSS_GROUP              1
#define GSS_NAME_MAX         256

/* procs */
#define GSSD_NULLPROC 		0
#define GSSD_NAME_TO_UID	1
#define GSSD_UID_TO_NAME	2
#define GSSD_NAME_TO_GID	3
#define GSSD_GID_TO_NAME	4

#if 0
/* NOTE: these structures mirror those declared in gssd's gss.x */
struct gssd_init_sec_context_arg {
	u32		uid;
	u32   flags;
	GSS_BUFFER_T	ctx_id;
	GSS_BUFFER_T	target_name;
	GSS_OID		mech;
	GSS_BUFFER_T	input_token;
};

struct gssd_init_sec_context_res {
	GSS_BUFFER_T	ctx_id;
	u32		maj_stat;
	u32		min_stat;
	GSS_BUFFER_T	output_token;
	u32		ret_flags;
};

struct gssd_accept_sec_context_arg {
	GSS_BUFFER_T	ctx_id;
	GSS_BUFFER_T	input_token;
};

struct gssd_accept_sec_context_res {
	GSS_BUFFER_T	ctx_id;
	u32		maj_stat;
	u32		min_stat;
	GSS_BUFFER_T	src_name;
	GSS_BUFFER_T	output_token;
	u32		ret_flags;
};

struct gssd_import_sec_context_arg {
	GSS_BUFFER_T	ctx_id;
};

struct gssd_import_sec_context_res {
	u32		maj_stat;
	u32		min_stat;
	GSS_BUFFER_T	ctx_token;
};
#endif

struct gss_name {
	char * name;  /* points to pulled up region in 'rep' */
	unsigned int len;
#if 0
	struct rpc_reply rep;
#endif
};

int  gss_create(void);
void gss_destroy(void);
int  gss_string_to_uint32(int type, unsigned int l, char *s, u_int32_t *u);
int  gss_uint32_to_string(int type, u_int32_t u, struct gss_name **s);
void gss_free_name(struct gss_name *n);



#endif /* _RPC_GSSD_CLNT_H_ */
