/*	$Id: nfs4.h,v 1.13 2003/06/20 17:05:09 rees Exp $	*/

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#ifndef _LINUX_NFS4_NFS4_H
#define _LINUX_NFS4_NFS4_H

#define __KERNEL__

#define GFP_KERNEL 0

#define printk(args...) printf(args)
#define memcpy(d, s, l) bcopy((s), (d), (l))

#define rw_semaphore semaphore
#define up(x)
#define up_write(x)
#define up_read(x)
#define down(x)
#define down_write(x)
#define down_read(x)
#define get_fast_time(tvp) microtime(tvp)

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint32_t __u32;
typedef uint64_t u64;
typedef uint64_t __u64;
typedef dev_t kdev_t;
typedef off_t loff_t;
typedef mode_t umode_t;
typedef int rwlock_t;
typedef int atomic_t;

#define ATTR_MODE	0x1
#define ATTR_UID	0x2
#define ATTR_GID	0x4
#define ATTR_SIZE	0x8
#define ATTR_ATIME	0x10
#define ATTR_MTIME	0x20

struct semaphore {
    int count;
    int waking;
    void * wait;
};

struct qstr {
    unsigned char * name;
    unsigned int len, hash;
};

struct iattr {
    unsigned int ia_valid;
    mode_t ia_mode;
    uid_t ia_uid;
    gid_t ia_gid;
    off_t ia_size;
    time_t ia_atime;
    time_t ia_mtime;
};

struct rpc_rqst {
	struct iovec *rq_svec;
	struct iovec *rq_rvec;
	uint32_t rq_slen;
	uint32_t rq_rlen;
};

extern void *kmalloc(size_t, int);
extern void kfree(void *);
extern char *nfs4_strchr(char *sp, char c);

/*
 * In a seqid-mutating op, this macro controls which error return
 * values trigger incrementation of the seqid.
 */
#if 1
#define seqid_mutating_err(err)	    ((err) == 0)
#else
#define seqid_mutating_err(err)		\
(((err) != NFS4ERR_STALE_CLIENTID) &&	\
 ((err) != NFS4ERR_BAD_SEQID) &&	\
 ((err) != NFS4ERR_STALE_STATEID) &&	\
 ((err) != NFS4ERR_BAD_STATEID))
#endif

static inline u32
opaque_hashval(const void *ptr, int nbytes)
{
	unsigned char *cptr = (unsigned char *) ptr;
	u32 x = 0;

	while (nbytes--) {
		x *= 37;
		x += *cptr++;
	}
	return x;
}

/* nfs4util.c */
extern int kernerrno(nfsstat4 err);
extern int nfserrno(int errno);
extern int utf8dup(utf8string *dest, utf8string *src);
extern int utf8cmp(utf8string *s1, utf8string *s2);
extern void ip_to_clientaddr4(u32 ip_addr, clientaddr4 *cp);
extern void hex_dump(void *ptr, int nbytes);
extern void print_rpcsec_gss_info(rpcsec_gss_info *ptr);
extern void print_bm(bitmap4 *bm);
extern void print_fattr(fattr4 *fp);
extern void print_lockowner(nfs_lockowner4 *lp);
extern void print_pathname(pathname4 *p);
extern void print_fh(nfs_fh4 *fh);

/* other global data */
extern struct rpcstats rpcstats;
extern struct nfsstats nfsstats;

#endif
