/*	$OpenBSD: nfsmount.h,v 1.11 2002/03/14 01:27:13 millert Exp $	*/
/*	$NetBSD: nfsmount.h,v 1.10 1996/02/18 11:54:03 fvdl Exp $	*/

/*
 * Copyright (c) 1989, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * This code is derived from software contributed to Berkeley by
 * Rick Macklem at The University of Guelph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *	This product includes software developed by the University of
 *	California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)nfsmount.h	8.3 (Berkeley) 3/30/95
 */


#ifndef _RPCCLNT_H_
#define _RPCCLNT_H_

#define RPCDEBUG(args...) do{	\
	if(rpcdebugon != 0){	\
		printf("%s(): ", __FUNCTION__);\
		printf(args);	\
		printf("\n");	\
	}}while(0)
	
/* from nfs/nfs.h */
#define NFS_TICKINTVL     5


/* from nfs/nfsproto.h */
#define RPC_MAXDATA     32768
#define RPC_MAXPKTHDR   404
#define RPC_MAXPACKET   (RPC_MAXPKTHDR + RPC_MAXDATA)

#define RPCX_UNSIGNED   4

/* defines for rpcclnt's rc_flags
   note that these flags are equivalent to NFSMNT_* flags in sys/mount.h */
#define RPCCLNT_SOFT             NFSMNT_SOFT
#define RPCCLNT_INT              NFSMNT_INT
#define RPCCLNT_NOCONN           NFSMNT_NOCONN
#define RPCCLNT_KERB             NFSMNT_KERB
#define RPCCLNT_DUMBTIMR         NFSMNT_DUMBTIMR
#define RPCCLNT_SNDLOCK          NFSMNT_SNDLOCK
#define RPCCLNT_WANTSND          NFSMNT_WANTSND
#define RPCCLNT_RCVLOCK          NFSMNT_RCVLOCK
#define RPCCLNT_WANTRCV          NFSMNT_WANTRCV

/* Flag values for r_flags */
#define R_TIMING        0x01            /* timing request (in mntp) */
#define R_SENT          0x02            /* request has been sent */
#define R_SOFTTERM      0x04            /* soft mnt, too many retries */
#define R_INTR          0x08            /* intr mnt, signal pending */
#define R_SOCKERR       0x10            /* Fatal error on socket */
#define R_TPRINTFMSG    0x20            /* Did a tprintf msg. */
#define R_MUSTRESEND    0x40            /* Must resend request */
#define R_GETONEREP     0x80            /* Probe for one reply only */


#define	nfs_ticks	rpcclnt_ticks
#define RPC_HZ          (hz / rpcclnt_ticks) /* Ticks/sec */
#define RPC_TIMEO       (1 * RPC_HZ)    /* Default timeout = 1 second */

#define RPC_MAXREXMIT   100             /* Stop counting after this many */

#define RPCIGNORE_SOERROR(s, e) \
                ((e) != EINTR && (e) != ERESTART && (e) != EWOULDBLOCK && \
                ((s) & PR_CONNREQUIRED) == 0)

#define RPCINT_SIGMASK  (sigmask(SIGINT)|sigmask(SIGTERM)|sigmask(SIGKILL)| \
                         sigmask(SIGHUP)|sigmask(SIGQUIT))

#define RPCMADV(m, s)   (m)->m_data += (s)


struct rpcstats {
	int	rpcretries;
        int     rpcrequests;
        int     rpctimeouts;
        int     rpcunexpected;
        int     rpcinvalid;
};

struct rpctask {
	TAILQ_ENTRY(rpctask) r_chain;
	struct mbuf     *r_mreq;
	struct mbuf     *r_mrep;
	struct mbuf     *r_md;
	caddr_t         r_dpos;
	
	struct rpcclnt  *r_rpcclnt;	
	
	/* not needed! */ 
	//struct vnode    *r_vp;

	u_int32_t       r_xid;
	int             r_flags;        /* flags on request, see below */
	int             r_retry;        /* max retransmission count */
	int             r_rexmit;       /* current retrans count */
	int             r_timer;        /* tick counter on reply */
	int             r_procnum;      /* NFS procedure number */
	int             r_rtt;          /* RTT for rpc */
	struct proc     *r_procp;       /* Proc that did I/O system call */
};



struct rpc_reply {
	struct {
		u_int32_t type;	
		u_int32_t status;
	
		/* used only when reply == RPC_MSGDENIED and 
		 * status == RPC_AUTHERR */
		u_int32_t autherr;
	
		/* rpc mismatch info if reply == RPC_MSGDENIED and 
	 	* status == RPC_MISMATCH */
		struct {
			u_int32_t low;
			u_int32_t high;
		} mismatch_info;
	} stat;

	/* head of the mbuf chain */
	struct mbuf * mrep;

	/* mbuf and position of the verification opaque data
	 * note that this is only valid when stat.reply == RPC_MSGACCEPTED */
	u_int32_t verf_type;
	u_int32_t verf_size;
	struct mbuf * verf_md;
	caddr_t verf_dpos;

	/* mbuf and postion of the result of the rpc request */
	struct mbuf * result_md;
	caddr_t result_dpos;
};


/*
 * RPC Client connection context.
 * One allocated on every NFS mount.
 * Holds RPC specific information for mount.
 */
struct	rpcclnt {
	/* XXX: do the nfs flags ever change after calling nfs_connect()? 
	 *	if so the flag variable should probably be a pointer....
	 */
	int	rc_flag;		/* For RPCCLNT_* flags  */

	/* sizes to reserve for socket */
	int	rc_wsize;		/* Max size of the request data */
	int	rc_rsize;		/* Max size of the response data */

	/* socket state */
	struct	mbuf *rc_name;		/* Addr of server */
	struct	socket *rc_so;		/* Rpc socket */
	int	rc_sotype;		/* Type of socket */
	int	rc_soproto;		/* and protocol */
	int	rc_soflags;		/* pr_flags for socket protocol */

	/* timing */
	int	rc_timeo;		/* Init timer for NFSMNT_DUMBTIMR */
	int	rc_retry;		/* Max retries */
	int	rc_srtt[4];		/* Timers for rpcs */
	int	rc_sdrtt[4];
	int	rc_sent;		/* Request send count */
	int	rc_cwnd;		/* Request send window */
	int	rc_timeouts;		/* Request timeouts */
	int	rc_deadthresh;		/* Threshold of timeouts-->dead server*/

	
	/* authentication: */
	/* currently can be RPCAUTH_NULL, RPCAUTH_KERBV4, RPCAUTH_UNIX */
	/* should be kept in XDR form */
	int	rc_authtype;		/* Authenticator type */

	/* RPCAUTH_KERB4 */
	int	rc_authlen;		/* and length */
	char	*rc_authstr;		/* Authenticator string */
	int	rc_verflen;
	char	*rc_verfstr;		/* and the verifier */

	/* RPCAUTH_UNIX*/	
	struct ucred * rc_cr;		/* user credentials */

	/* stored in XDR form */
	unsigned int rc_progid;		/* program id */
	unsigned int rc_progvers;	/* program version */

	/* XXX: name of server for log messages */ 
	char	*rc_servername;		/* for printing error messages */

	int rc_rtton;

	int rc_proctlen;		/* if == 0 then rc_proct == NULL */
	int * rc_proct;
};

extern struct pool rpcreply_pool;

void rpcclnt_init(void);
void rpcclnt_destroy(struct rpcclnt *);
int rpcclnt_send(struct socket *, struct mbuf *, struct mbuf *, struct rpctask *);
int rpcclnt_receive(struct rpctask *, struct mbuf **, struct mbuf **);
int rpcclnt_reply(struct rpctask *);
void rpcclnt_timer(void *);
int rpcclnt_sigintr(struct rpcclnt *, struct rpctask *, struct proc *);
int rpcclnt_sndlock(int *, struct rpctask *);
void rpcclnt_sndunlock(int *);
int rpcclnt_rcvlock(struct rpctask *);
void rpcclnt_rcvunlock(int *);
void rpcclnt_realign(struct mbuf *, int);
int rpcclnt_msg(struct proc *, char *, char *);
struct mbuf * rpcclnt_buildheader(struct rpcclnt *, int, struct mbuf *, u_int32_t, int *, struct mbuf **);
int rpcm_disct(struct mbuf **, caddr_t *, int, int, caddr_t *);
u_int32_t rpcclnt_proct(struct rpcclnt *, u_int32_t);
int rpc_adv(struct mbuf **, caddr_t *, int, int);



/* rpcclnt interface; */
int rpcclnt_connect(struct rpcclnt *, int, struct mbuf *, int, int, int, int, const char *, int, int);
int rpcclnt_reconnect(struct rpctask *);
void rpcclnt_disconnect(struct rpcclnt *);
void rpcclnt_setauth(struct rpcclnt *, u_int32_t,  u_int32_t, char *, u_int32_t, char *, struct ucred *);
int rpcclnt_request(struct rpcclnt *, struct mbuf *, int, struct proc *, struct rpc_reply *);
int rpcclnt_err(struct rpc_reply *);


#endif /* _RPCCLNT_H_ */
