/*	$Id: nfs4_proc.c,v 1.15 2002/08/31 20:39:32 muzzle Exp $	*/

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

/*
 *  nfs version 4 client side procedure stub
 *
 *  Andy Adamson <andros@citi.umich.edu>
 *  Jim Rees <rees@umich.edu>
 *
 */

#include <sys/param.h>
#include <sys/conf.h>
#include <sys/ioctl.h>
#include <sys/signal.h>
#include <sys/proc.h>
#include <sys/namei.h>
#include <sys/vnode.h>
#include <sys/kernel.h>
#include <sys/mount.h>
#include <sys/buf.h>
#include <sys/mbuf.h>
#include <sys/socket.h>
#include <sys/socketvar.h>
#include <sys/systm.h>

#include <net/if.h>
#include <net/route.h>
#include <netinet/in.h>

#include <nfs/rpcv2.h>
#include <nfs/nfsproto.h>
#include <nfs/nfs.h>
#include <nfs/xdr_subs.h>
#include <nfs4/list.h>
#include <nfs4/nfs4mount.h>
#include <nfs4/nfs4_prot.h>
#include <nfs4/nfs4_debug.h>
#include <nfs4/nfs4.h>
#include <nfs4/nfs4fs.h>
#include <nfs4/nfs4node.h>
#include <nfs4/nfsm_subs.h>
#include <nfs4/nfs4_var.h>


/* Global State */

int
nfs4fs_call_compound(struct nfs4fs_compound *cp)
{
	struct nfs4fs_lockowner *lp;
	struct nfs4fs_file_data *fp;
	int i, status;

 tryagain:
	nfsv4_printk(level2, "nfs4_call_compound starting: \"%s\" %d ops %d len\n",
		     cp->tag, cp->req_nops, cp->mreq->m_len);
	*cp->nopsp = htonl(cp->req_nops);

	/* Backfill (temporary) */
	lp = cp->seqid_holder;
	if (lp) {
		*cp->seqidp = htonl(lp->lo_seqid);
		nfsv4_printk(seqid, "nfs4fs: using seqid %d, lockowner %d\n",
			     lp->lo_seqid, lp->lo_id);
	}
	fp = cp->stateid_holder;
	if (fp) {
		for (i = 0; i < cp->nstateids; i++)
			memcpy(cp->stateidp[i], fp->fi_stateid, sizeof(stateid4));
	}

	cp->mrep = NULL;

	status = nfs_request(cp->nmp, cp->mreq, NFSPROC4_COMPOUND,
			     cp->procp, cp->cred, &cp->mrep, &cp->md, &cp->dpos);

	/* nfs_request always frees mreq */
	cp->mreq = NULL;

	if (status != 0)
		goto out;


	/* handle_compound sets cp->toplevel_status, cp->nops */
	status = nfs4_handle_compound(cp);

	if (status == NFS4ERR_RETRY_COMPOUND)
		goto tryagain;
	else if (status)
		goto out;
	if ((cp->resp_nops <= 0) || (cp->resp_nops > cp->req_nops))
		goto out;

	/*
	 * If necessary, increment the seqid and release the seqid semaphore.
	 */
	lp = cp->seqid_holder;
	if (lp) {
#if 0
		if (!(cp->flags & CA_SEQID_LOCKED))
			printf("nfs4fs_call_compound(): !(cp->flags & CA_SEQID_LOCKED)\n");
#endif
		if (cp->resp_nops > cp->seqid_index ||
		    (cp->resp_nops == cp->seqid_index &&
		     seqid_mutating_err(cp->toplevel_status)))
			lp->lo_seqid++;
		if (cp->flags & CA_SEQID_RELEASE) {
			up(&lp->lo_sema);
			cp->flags &= ~CA_SEQID_LOCKED;
		}
	}

	/*
	 * If necessary, release the stateid semaphore.
	 */
	fp = cp->stateid_holder;
	if (fp && (cp->flags & CA_STATEID_RELEASE)) {
#if 0
		if (!(cp->flags & CA_STATEID_LOCKED))
			printf("nfs4fs_call_compound(): !(cp->flags & CA_STATEID_LOCKED)\n");
#endif
		up_read(&fp->fi_sema);
		cp->flags &= ~CA_STATEID_LOCKED;
	}

#if 0
	/*
	 * Update the renewal information for this server.
	 */
	if (cp->renew_index && (!cp->toplevel_status || (cp->resp_nops > cp->renew_index))) {
		if (NFS4_LAST_RENEWAL(cp->nmp) < cp->timestamp)
			NFS4_LAST_RENEWAL(cp->nmp) = cp->timestamp;
	}
#endif

 out:
	return -status;
}

void
nfs4fs_release_compound(struct nfs4fs_compound *cp)
{
	if (cp->mreq) {
		m_freem(cp->mreq);
		cp->mreq = cp->mb = NULL;
	}
	if (cp->mrep) {
		m_freem(cp->mrep);
		cp->mrep = cp->md = NULL;
	}
}
