/*	$Id: rpc.h,v 1.3 2002/08/20 21:49:24 rees Exp $	*/

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#include <sys/param.h>
#include <sys/systm.h>

#define GFP_KERNEL 0
#define KERN_INFO
#define printk(args...) printf(args)
#define memcpy(d, s, l) bcopy((s), (d), (l))

extern void *kmalloc(size_t, int);
extern void kfree(const void *);

typedef uint8_t u8;
typedef uint16_t u16;
typedef uint32_t u32;
typedef uint32_t __u32;
typedef uint64_t u64;
typedef uint64_t __u64;
typedef dev_t kdev_t;

#define xdr_uint32_t xdr_u_int32_t

#define mem_alloc(bsize)	kmalloc(bsize, GFP_KERNEL)
#define mem_free(ptr, bsize)	kfree(ptr)
#define bool_t			unsigned int
#define enum_t			unsigned int

#ifndef __P
# define __P(x) x
#endif

#ifndef FALSE
# define FALSE 0
#endif
#ifndef TRUE
# define TRUE 1
#endif

enum xdr_op {
	XDR_ENCODE=0,
	XDR_DECODE=1,
	XDR_FREE=2
};

#define BYTES_PER_XDR_UNIT	(4)
#define RNDUP(x)  ((((x) + BYTES_PER_XDR_UNIT - 1) / BYTES_PER_XDR_UNIT) \
		    * BYTES_PER_XDR_UNIT)

#ifndef XDR_QUADLEN
# define XDR_QUADLEN(l) (((l) + 3) >> 2)
#endif

#define XDR_LEN(l)   ((((l) + 3) >> 2) << 2)

typedef struct __rpc_xdr {
	enum xdr_op	x_op;		/* operation; fast additional param */
	struct xdr_ops {
		/* get a long from underlying stream */
		bool_t	(*x_getlong) __P((struct __rpc_xdr *, long *));
		/* put a long to " */
		bool_t	(*x_putlong) __P((struct __rpc_xdr *, long *));
		/* get some bytes from " */
		bool_t	(*x_getbytes) __P((struct __rpc_xdr *, caddr_t, u_int));
		/* put some bytes to " */
		bool_t	(*x_putbytes) __P((struct __rpc_xdr *, caddr_t, u_int));
		/* returns bytes off from beginning */
		u_int	(*x_getpostn) __P((struct __rpc_xdr *));
		/* lets you reposition the stream */
		bool_t  (*x_setpostn) __P((struct __rpc_xdr *, u_int));
		/* buf quick ptr to buffered data */
		int32_t	*(*x_inline) __P((struct __rpc_xdr *, u_int));
		/* free privates of this xdr_stream */
		void	(*x_destroy) __P((struct __rpc_xdr *));
	} *x_ops;
	caddr_t 	x_public;	/* users' data */
	caddr_t		x_private;	/* pointer to private data */
	caddr_t 	x_base;		/* private used for position info */
	int		x_handy;	/* extra private word */
} XDR;

/*
 * A xdrproc_t exists for each data type which is to be encoded or decoded.
 *
 * The second argument to the xdrproc_t is a pointer to an opaque pointer.
 * The opaque pointer generally points to a structure of the data type
 * to be decoded.  If this pointer is 0, then the type routines should
 * allocate dynamic storage of the appropriate size and return it.
 *
 */
typedef	bool_t (*xdrproc_t) __P((XDR *, void *));
