/*	$Id: nfs4_debug.h,v 1.2 2002/08/20 21:49:20 rees Exp $	*/

/*
 * copyright (c) 2002
 * the regents of the university of michigan
 * all rights reserved
 * 
 * permission is granted to use, copy, create derivative works and redistribute
 * this software and such derivative works for any purpose, so long as the name
 * of the university of michigan is not used in any advertising or publicity
 * pertaining to the use or distribution of this software without specific,
 * written prior authorization.  if the above copyright notice or any other
 * identification of the university of michigan is included in any copy of any
 * portion of this software, then the disclaimer below must also be included.
 * 
 * this software is provided as is, without representation from the university
 * of michigan as to its fitness for any purpose, and without warranty by the
 * university of michigan of any kind, either express or implied, including
 * without limitation the implied warranties of merchantability and fitness for
 * a particular purpose. the regents of the university of michigan shall not be
 * liable for any damages, including special, indirect, incidental, or
 * consequential damages, with respect to any claim arising out of or in
 * connection with the use of the software, even if it has been or is hereafter
 * advised of the possibility of such damages.
 */

#ifndef _LINUX_NFS4_NFS4_DEBUG_H
#define _LINUX_NFS4_NFS4_DEBUG_H

#define NFS4_DEBUG       1
#define RPCDBG_FACILITY  0

/* XXX : do memory alloction with GFP_NFS instead of GFP_KERNEL?? */

#if NFS4_DEBUG
# define nfsv4_printk(fac,args...)   do { if (nfsv4_debug_##fac) printk(args); } while (0)
# define nfsv4_hexdump(fac,ptr,len)  do { if (nfsv4_debug_##fac) hex_dump(ptr,len); } while (0)
# define nfsv4_print_fh(fac,fh)      do { if (nfsv4_debug_##fac) print_fh(fh); } while (0)
# define nfsv4_print_svcfh(fac,fh)   do { if (nfsv4_debug_##fac) print_svcfh(fh); } while (0)
# define nfsv4_print_bm(fac,bm)      do { if (nfsv4_debug_##fac) print_bm(bm); } while (0)
# define nfsv4_print_fattr(fac,fp)   do { if (nfsv4_debug_##fac) print_fattr(fp); } while (0)
# define nfsv4_print_lockowner(fac,lp)  do { if (nfsv4_debug_##fac) \
	print_lockowner(lp); } while (0)
# define nfsv4_print_pathname(fac,p)    do { if (nfsv4_debug_##fac) \
	print_pathname(p); } while (0)
# define NFS4_ALLOC(nbytes)	__NFS4_ALLOC(nbytes, __FILE__, __LINE__)
# define NFS4_FREE(ptr)		__NFS4_FREE(ptr, __FILE__, __LINE__)
# define IGET(s, i) __IGET(s, i, __FILE__, __LINE__)
# define IPUT(i) __IPUT(i, __FILE__, __LINE__)
# define IGRAB(i) __IGRAB(i, __FILE__, __LINE__)
# define DGET(d) __DGET(d, __FILE__, __LINE__)
# define DGET_LOCKED(d) __DGET_LOCKED(d, __FILE__, __LINE__)
# define D_ALLOC(d, q) __D_ALLOC(d, q, __FILE__, __LINE__)
# define D_ALLOC_ROOT(i) __D_ALLOC_ROOT(i, __FILE__, __LINE__)
# define DPUT(d) __DPUT(d, __FILE__, __LINE__)
# define D_LOOKUP(d, q) __D_LOOKUP(d, q, __FILE__, __LINE__)
# define LOOKUP_ONE(n, d) __LOOKUP_ONE(n, d, __FILE__, __LINE__)
# define FOLLOW_DOWN(m, d) __FOLLOW_DOWN(m, d, __FILE__, __LINE__)
#else
# define nfsv4_printk(fac,args...)	do { } while (0)
# define nfsv4_hexdump(fac,ptr,len)	do { } while (0)
# define nfsv4_print_fh(fac,fh)		do { } while (0)
# define nfsv4_print_svcfh(fac,fh)	do { } while (0)
# define nfsv4_print_bm(fac,bm)		do { } while (0)
# define nfsv4_print_fattr(fac,fp)	do { } while (0)
# define nfsv4_print_lockowner(fac,lp)	do { } while (0)
# define nfsv4_print_pathname(fac,p)	do { } while (0)
# define NFS4_ALLOC(nbytes)	kmalloc(nbytes, GFP_KERNEL)
# define NFS4_FREE(ptr)		kfree(ptr)
# define IGET(s, i)		iget(s, i)
# define IPUT(i)		iput(i)
# define IGRAB(i)		igrab(i)
# define DGET(d)		dget(d)
# define DGET_LOCKED(d)		dget_locked(d)
# define D_ALLOC(d, q)		d_alloc(d, q)
# define D_ALLOC_ROOT(i)	d_alloc_root(i)
# define DPUT(d)		dput(d)
# define D_LOOKUP(d, q)		d_lookup(d, q)
# define LOOKUP_ONE(n, d)	lookup_one(n, d)
# define FOLLOW_DOWN(m, d)	follow_down(m, d)
#endif

#if NFS4_DEBUG

extern void *__NFS4_ALLOC(int nbytes, char *file, int line);
extern void __NFS4_FREE(void *ptr, char *file, int line);
extern void NFS4_COMPLAIN(void);
#ifdef __linux__
extern struct inode *__IGET(struct super_block *sb, unsigned long ino, char *file, int line);
extern void __IPUT(struct inode *inode, char *file, int line);
extern struct inode * __IGRAB(struct inode *inode, char *file, int line);
extern struct dentry *__DGET(struct dentry *dentry, char *file, int line);
extern struct dentry *__DGET_LOCKED(struct dentry *dentry, char *file, int line);
extern struct dentry *__D_ALLOC(struct dentry *dentry, const struct qstr *str,
				char *file, int line);
extern struct dentry *__D_ALLOC_ROOT(struct inode *inode, char *file, int line);
extern void __DPUT(struct dentry *dentry, char *file, int line);
extern struct dentry *__D_LOOKUP(struct dentry *dentry, struct qstr *str,
				 char *file, int line);
extern struct dentry *__LOOKUP_ONE(const char *str, struct dentry *dentry,
				   char *file, int line);
extern int __FOLLOW_DOWN(struct vfsmount **, struct dentry **, char *file, int line);
#endif

extern int nfsv4_debug_level1;
extern int nfsv4_debug_level2;
extern int nfsv4_debug_level3;
extern int nfsv4_debug_mount;
extern int nfsv4_debug_ctl;
extern int nfsv4_debug_dispatcher;
extern int nfsv4_debug_fh;
extern int nfsv4_debug_getattr;
extern int nfsv4_debug_setattr;
extern int nfsv4_debug_lookup;
extern int nfsv4_debug_readdir;
extern int nfsv4_debug_create;
extern int nfsv4_debug_xdr;
extern int nfsv4_debug_gss;
extern int nfsv4_debug_remove;
extern int nfsv4_debug_link;
extern int nfsv4_debug_readlink;
extern int nfsv4_debug_rename;
extern int nfsv4_debug_open;
extern int nfsv4_debug_read;
extern int nfsv4_debug_write;
extern int nfsv4_debug_lock;
extern int nfsv4_debug_seqid;
extern int nfsv4_debug_lockowner;
extern int nfsv4_debug_stateid;
extern int nfsv4_debug_clientid;
extern int nfsv4_debug_reval;
extern int nfsv4_debug_auth;
#define nfsv4_debug_ctl2		(nfsv4_debug_ctl || nfsv4_debug_level2)
#define nfsv4_debug_mount2		(nfsv4_debug_mount || nfsv4_debug_level2)
#define nfsv4_debug_fh2			(nfsv4_debug_fh || nfsv4_debug_level2)
#define nfsv4_debug_getattr2		(nfsv4_debug_getattr || nfsv4_debug_level2)
#define nfsv4_debug_setattr2		(nfsv4_debug_setattr || nfsv4_debug_level2)
#define nfsv4_debug_readdir2		(nfsv4_debug_readdir || nfsv4_debug_level2)
#define nfsv4_debug_create2		(nfsv4_debug_create || nfsv4_debug_level2)
#define nfsv4_debug_xdr2		(nfsv4_debug_xdr || nfsv4_debug_level2)
#define nfsv4_debug_lookup2		(nfsv4_debug_lookup || nfsv4_debug_level2)
#define nfsv4_debug_remove2		(nfsv4_debug_remove || nfsv4_debug_level2)
#define nfsv4_debug_link2		(nfsv4_debug_link || nfsv4_debug_level2)
#define nfsv4_debug_readlink2		(nfsv4_debug_readlink || nfsv4_debug_level2)
#define nfsv4_debug_rename2		(nfsv4_debug_rename || nfsv4_debug_level2)
#define nfsv4_debug_open2		(nfsv4_debug_open || nfsv4_debug_level2)
#define nfsv4_debug_read2		(nfsv4_debug_read || nfsv4_debug_level2)
#define nfsv4_debug_write2		(nfsv4_debug_write || nfsv4_debug_level2)
#define nfsv4_debug_lock2		(nfsv4_debug_lock || nfsv4_debug_level2)
#define nfsv4_debug_seqid2		(nfsv4_debug_seqid || nfsv4_debug_level2)
#define nfsv4_debug_lockowner2		(nfsv4_debug_lockowner || nfsv4_debug_level2)
#define nfsv4_debug_stateid2		(nfsv4_debug_stateid || nfsv4_debug_level2)
#define nfsv4_debug_clientid2		(nfsv4_debug_clientid || nfsv4_debug_level2)
#define nfsv4_debug_reval2		(nfsv4_debug_reval || nfsv4_debug_level2)
#define nfsv4_debug_gss2		(nfsv4_debug_gss || nfsv4_debug_level2)

#endif  /* NFS4_DEBUG */

#endif
