/*
	Connectathon Testsuite  RPCSEC_GSS User Level API
      		 client_main.c
*/

#include <sys/types.h>
#include <rpc/rpc.h>
#include <gssapi/gssapi.h>
#include <syslog.h>
#include <signal.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include "list.h"

#define ADDR_SET	1
#define ADDR_GET	2
#define ADDR_DEL	3
#define	SVC_SET		4
#define	CREATE		5
#define	DESTROY		6
#define	LOOP		8
#define	QUIT		7

/* from kerberos source, gssapi_krb5.c */
static gss_OID_desc krb5oid =
   {9, "\052\206\110\206\367\022\001\002\002"};
static gss_OID_desc spkm3oid =
      {7, "\053\006\001\005\005\001\003"};

/* Global list of mechanisms supported by underlying gssapi */
gss_OID_set mechs_supported;


static int
mechanism_supported(gss_OID m)
{
	int i;

	for (i = 0; i < mechs_supported->count; i++) {
		if ((m->length == mechs_supported->elements[i].length) &&
		     !memcmp(m->elements,
		     	     mechs_supported->elements[i].elements, m->length))
		     return 1;
	}
	return 0;
}

static void
usage()
{
	printf("\ncommands are:\n");
	printf("\tset <name> <value>\n");
	printf("\tget <name>\n");
	printf("\tdel <name>\n");
	printf("\tservice (integrity | privacy | none)\n");
	printf("\tcreate-context(cc)\n");
	printf("\tdestroy-context(dc)\n");
	printf("\tloop\n");
	printf("\tquit\n");
}

static char *args[100];
static char argbuf[512];

static void
parseargs()
{
	int i, j, n;
	char s[512];

	usage();
	printf(" enter cmd -> ");
	if (fgets(argbuf, sizeof(argbuf), stdin) == NULL) {
		perror("gets");
		exit(1);
	}

	n = i = 0;
	while (argbuf[i] != '\0') {
		while (isspace(argbuf[i]))
			i++;
		j = 0;
		while (argbuf[i] != '\0' && !isspace(argbuf[i]))
			s[j++] = argbuf[i++];
		s[j] = '\0';
		if (j == 0)
			break;
		else {
			args[n] = (char *) malloc(strlen(s)+1);
			strcpy(args[n++], s);
		}
	}
	args[n] = NULL;
}

static void
freeargs()
{
	int i;

	for (i = 0; i < 100 && args[i]; i++)
		free(args[i]);
}

int
main(argc, argv)
	int argc;
	char **argv;
{
	int i;
	int k = 0;
	int op, anon = 0;
	addr_entry *recp, rec;
	bool_t *resp;
	name_t name;
	addr_t addr = NULL;
	char hostname[128];  
	char service_name[128];
	rpc_gss_svc_t svc;
	struct rpc_gss_sec sec;
	CLIENT *clnt;
	AUTH *oldauth = NULL;
	AUTH *auth = NULL;
	char *svcstr = NULL;
	gss_OID mech;
	OM_uint32 min_stat;

	if (argc == 1) {
		fprintf(stderr, "Usage: %s [hostname] [service] [-m mechanism (1 for Krb5, 2 for SPKM3)] [-a anonymous SPKM3]\n",
			argv[0]);
		exit(1);
	}
	
	if (argc > 1) {
		strcpy(hostname, argv[1]);
	} else if (gethostname(hostname, sizeof(hostname)) == -1) {
			perror("gethostname");
			exit(1);
	}

	if (argc > 2)
		strcpy(service_name, argv[2]);
	else
		strcpy(service_name, "sample");
	strcat(service_name, "@");
	strcat(service_name, hostname);

	//authgss_set_debug_level(5);
	svc = RPCSEC_GSS_SVC_NONE;

	if (gss_indicate_mechs(&min_stat, &mechs_supported) != GSS_S_COMPLETE) {
		printf("Could not get set of supported mechanisms!\n");
		exit(1);
	}
	if ( (argc > 3) && (!strcmp(argv[3], "-m")) ) {
		if ( (argc > 4) && (!strcmp(argv[4], "1")) ) {
			printf("Kerberos mechanism requested\n");
			if (mechanism_supported(&krb5oid))
				mech = (gss_OID)&krb5oid;
			else {
				printf("Kerberos not supported by GSS-API!\n");
				exit(1);
			}
		}
		else if ( (argc > 4) && (!strcmp(argv[4], "2")) ) {
			printf("SPKM3 mechanism requested\n");
			if (mechanism_supported(&spkm3oid)) {
				mech = (gss_OID)&spkm3oid;
				if ( (argc > 5) && (!strcmp(argv[5], "-a")) ) {
					printf("Anonymous SPKM3 requested\n");
					anon = 1;
				}else 
					printf("Mutual auth SPKM3 requested\n");
			} else {
				printf("SPKM3 not supported by GSS-API!\n");
				exit(1);
			}
		}
		else {
			printf("Unsupported mechanism: '%s'\n", argv[4]);
			exit(1);
		}
	}

	if ((clnt = clnt_create(hostname, ADDRLISTPROG, ADDRLISTVERS,
					"udp")) == NULL) {
		clnt_pcreateerror(hostname);
		exit(1);
	}

	for (;;) {
		freeargs();
		parseargs();

		if (!args[0])
			continue;

		if (strcmp(args[0], "set") == 0) {
			op = ADDR_SET;
			name = args[1];
			addr = args[2];
			if (!(name && addr)) {
				printf("syntax error\n");
				continue;
			}

		} else if (strcmp(args[0], "get") == 0) {
			op = ADDR_GET;
			name = args[1];
			if (!name) {
				printf("syntax error\n");
				continue;
			}

		} else if (strcmp(args[0], "del") == 0) {
			op = ADDR_DEL;
			name = args[1];
			if (!name) {
				printf("syntax error\n");
				continue;
			}

		} else if (strcmp(args[0], "service") == 0) {
			op = SVC_SET;
			if (!args[1]) {
				printf("syntax error\n");
				continue;
			}
			if (svcstr)
				free(svcstr);
			svcstr = (char *) malloc(strlen(args[1]) + 1);
			strcpy(svcstr, args[1]);

		} else if ((strcmp(args[0], "create-context") == 0) ||
		          (strcmp(args[0], "cc") == 0)) {
			op = CREATE;

		} else if ((strcmp(args[0], "destroy-context") == 0) ||
		          (strcmp(args[0], "dc") == 0)) {
			op = DESTROY;
		} else if (strcmp(args[0], "loop") == 0) {
			op = LOOP;
			if (!args[1])
				k=5;
			else
				k= atoi(args[1]);

		} else if (strcmp(args[0], "quit") == 0) {
			op = QUIT;

		} else {
			printf("syntax error\n");
			continue;
		}

		switch (op) {
		case ADDR_SET:
			rec.name = name;
			rec.address = addr;
			resp = addrlist_set_1(&rec, clnt);
			if (resp != NULL && *resp == TRUE)
				printf("value is set\n");
			else
				printf("could not set value\n");
			break;

		case ADDR_GET:
			recp = addrlist_get_1(&name, clnt);
			
			if (recp && recp->name && (strlen(recp->name) > 0)) {
				printf("name:  %s\n", recp->name);
				printf("value: %s\n", recp->address);
			} else {
				if (recp)
					printf("recp:%p recp->name:%s\n", recp, recp->name);
				printf("could not get value\n");
			}
			break;

		case ADDR_DEL:
			resp = addrlist_del_1(&name, clnt);
			if (resp != NULL && *resp == TRUE)
				printf("deleted value\n");
			else
				printf("could not delete value\n");
			break;

		case SVC_SET:
		{
		int ret = 0;
			if (svcstr[0] == 'i')
				ret = authgss_service(clnt->cl_auth,RPCSEC_GSS_SVC_INTEGRITY);
			else if (svcstr[0] == 'p')
				ret = authgss_service(clnt->cl_auth,RPCSEC_GSS_SVC_PRIVACY);
			else if (svcstr[0] == 'n')
				ret = authgss_service(clnt->cl_auth,RPCSEC_GSS_SVC_NONE);
			else {
				printf("invalid service %s\n", svcstr);
				break;
			}
			if(ret) 
				printf("service is set\n");
			else
				printf("service is NOT set\n");
			break;
		}
		case LOOP:
			if (auth) {
				AUTH_DESTROY(auth);
				auth = NULL;
				clnt->cl_auth = oldauth;
			}

			sec.mech = mech;
			sec.qop = GSS_C_QOP_DEFAULT;
			sec.svc = svc;
			sec.cred = NULL;
			sec.req_flags = 0;
			if (anon)
				sec.req_flags |= GSS_C_ANON_FLAG;
			else
				sec.req_flags |= GSS_C_MUTUAL_FLAG;
			for (i=0; i< k; i++) {
				fprintf(stderr, "### Processing loop %d of %d ###\n",
					i+1, k);
				auth = authgss_create_default(clnt,
						service_name, &sec);
			
				if (auth == NULL) {
					printf("could not create context\n");
					exit(2);
				}
				else {
					oldauth = clnt->cl_auth;
					clnt->cl_auth = auth;
					printf("context created\n");
					
					if (auth){
						AUTH_DESTROY(auth);
						auth = NULL;
						clnt->cl_auth = oldauth;
						printf("context destroyed\n");
					} else
						printf("no context to destroy\n");
					if (auth) {
						AUTH_DESTROY(auth);
						clnt->cl_auth = oldauth;
					}
					/*clnt_destroy(clnt); */
				}
			}
			break;

		case CREATE:
			if (auth) {
				AUTH_DESTROY(auth);
				auth = NULL;
				clnt->cl_auth = oldauth;
			}
			sec.mech = mech;
			sec.qop = GSS_C_QOP_DEFAULT;
			sec.svc = svc;
			sec.cred = NULL;
			sec.req_flags = 0;
			if (anon)
				sec.req_flags |= GSS_C_ANON_FLAG;
			else
				sec.req_flags |= GSS_C_MUTUAL_FLAG;

			auth = authgss_create_default(clnt, service_name, &sec);

			if (auth == NULL)
				printf("could not create context\n");
			else {
				oldauth = clnt->cl_auth;
				clnt->cl_auth = auth;
				printf("context created\n");
			}
			break;

		case DESTROY:
			if (auth) {
				AUTH_DESTROY(auth);
				auth = NULL;
				clnt->cl_auth = oldauth;
				printf("context destroyed\n");
			} else
				printf("no context to destroy\n");
			break;
		case QUIT:
			if (auth) {
				AUTH_DESTROY(auth);
				clnt->cl_auth = oldauth;
			}
			clnt_destroy(clnt);
			exit(0);
		}
	}
}
