/*
 *  spkm3/seal.c
 *
 *  Copyright (c) 2002,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"


OM_uint32
spkm3_gss_wrap (
		       OM_uint32 * min_status,	/* minor_status */
		       gss_ctx_id_t ctx_hndl,	/* context_handle */
		       int flag_conf_req,	/* conf_req_flag */
		       int qop_req,	/* qop_req */
		       gss_buffer_t msg_in_buf,	/* input_message_buffer */
		       int *conf_st,	/* conf_state */
		       gss_buffer_t msg_out_buf	/* output_message_buffer */
   )
{
        SPKM3_DEBUG (1, ("STUB: spkm3_gss_wrap called\n"));
        *min_status = 0;
        return GSS_S_FAILURE;
}

#if 0

	OM_uint32 major_status = 0;
	spkm3_context_t *ctx;
	int tlen, len;
	unsigned char *ptr = 0, *tok = 0;
	SPKM_WRAP *wrap;
	SPKMInnerContextToken *ict = NULL;
	Wrap_Header *whdr;
	Wrap_Body *wbdy;
	EVP_CIPHER_CTX e_ctx;
	unsigned char iv[EVP_MAX_IV_LENGTH];
	MD5_CTX md5ctx;
	unsigned char md[MD5_DIGEST_LENGTH];
	int hdrlen = 0, cksumlen = 0, blocksize;
	int indatalen = 0, sealbuflen = 0, seallen = 0, enclen = 0, ret = 0;
	unsigned char *cksumptr, *sealptr;

	SPKM3_DEBUG (1, "spkm3_gss_wrap\n");
#ifdef USE_KRB_CONTEXT_CACHE
	   /* validate the context handle */
	   if (!kg_validate_ctx_id (ctx_hndl)) {
		*min_status = (OM_uint32) GSS_S_G_VALIDATE_FAILED;
		major_status = GSS_S_NO_CONTEXT;
		goto err;
	}
#endif

	ctx = (spkm3_context_t *) ctx_hndl;

	if (!ctx->established) {
		*min_status = GSS_SPKM_S_SG_CTX_INCOMPLETE;
		major_status = GSS_S_NO_CONTEXT;
		 /*XXX*/ goto err;
	}

	msg_out_buf->length = 0;
	msg_out_buf->value = NULL;

	/* only default qop for now. */

	switch (qop_req) {
	case 0:
		/* check the context algorithms. RFC 2203 states that QOP of 0
		 * means that the QOP default integ/conf/owf algorithm is the first
		 * one on the initiator's int_alg/conf_alg/owf_alg list.
		 * RFC 2847 states the following MANDATORY algs.
		 * 
		 * Integrity:
		 *  [0] md5WithRSAEncryption (a change to the spec following RSA licence)
		 * 
		 * Confidentiality:
		 *  [0] cast5CBC
		 * 
		 * One way function:
		 *  [0] id-sha1 
		 * 
		 */
		major_status = GSS_S_FAILURE;
#if 0
		 /*XXX*/ if (ctx->intg_alg != NID_md5) {
#else
		 /*XXX*/ if (ctx->intg_alg != NID_hmac_md5) {
#endif
			*min_status = GSS_SPKM_S_SG_BAD_INT_ALG_SET;
			goto err;
		}
		if (ctx->conf_alg != NID_cast5_cbc) {
			*min_status = GSS_SPKM_S_SG_BAD_CONF_ALG_SET;
			goto err;
		}
		if (ctx->owf_alg != NID_sha1) {
			*min_status = EINVAL;	/*XXX no BAD_OWF_ALG_SET */
			goto err;
		}
		break;
	default:
		spkm3_log_err("gss_seal: unavailable qop (%d) requested.\n",
			      qop_req);
		*min_status = GSS_S_G_UNAVAIL_QOP;
		goto err;
		break;
	}

	/* set status for any ANS1 or encryption error */
	*min_status = GSS_S_G_MEMORY_ALLOC;
	major_status = GSS_S_FAILURE;
	 /*XXX*/ ict = SPKMInnerContextToken_new ();
	if (ict == NULL) {
		goto err;
	}
	wrap = SPKM_WRAP_new ();
	if (wrap == NULL) {
		/* this doesn't free the base token.... */
		SPKMInnerContextToken_free (ict);
		goto err;
	}
	ict->tag = 5;		/* SPKM_WRAP */
	ict->d.wrap = wrap;

	whdr = wrap->wrapheader;

	/* set tokenid */
	if (!ASN1_INTEGER_set (whdr->tokid, 0x0201)) {
		goto err;
	}

	/* set context id */
	if (!ASN1_BIT_STRING_set
	    (whdr->contextid, ctx->ctx_id.data, ctx->ctx_id.length)) {
		goto err;
	}
	/* whdr->intgalg not present -> default intg_alg 
	 * whdr->confalg not present -> default intg_alg; NULL -> no conf applied 
	 * whdr->sndseq left NULL for now */

	/* derive the necessary sub key from the context key 
	 * NOTE: cast5_cbc uses a 128 bit key, which is also the 
	 * key length of the generated DH shared key, so 
	 * no need to derive a subkey in this situation. therefore, at first pass, 
	 * don't code this function.....
	 * min_status = spkm3_derive_subkey(evp_ctx,ctx);
	 */

	/* compute the checksum of the message. this assumes md5 */

	hdrlen = i2d_Wrap_Header (whdr, NULL);
	cksumlen = hdrlen + msg_in_buf->length;
	cksumptr = (unsigned char *) malloc (cksumlen);
	if (cksumptr == NULL)
		goto err;
	ptr = cksumptr;
	i2d_Wrap_Header (whdr, &ptr);
	ptr = cksumptr + hdrlen;
	memcpy (ptr, msg_in_buf->value, msg_in_buf->length);
	MD5_Init (&md5ctx);
	MD5_Update (&md5ctx, cksumptr, (unsigned long) cksumlen);
	MD5_Final (&(md[0]), &md5ctx);
	free (cksumptr);

	if (flag_conf_req) {	/* return sealed data */
		memset (iv, '\0', sizeof (iv));
		ret =
		   EVP_EncryptInit (&e_ctx, EVP_cast5_cbc (),
				    ctx->share_key.value, iv);
		if (ret == 0) {
			ERR_print_errors_fp (stderr);
			goto err;
		}

		/* calculate needed seal buf length. for stream ciphers, this
		 * is equal to the message length. for block ciphers, round
		 * up to the nearest block */
		blocksize = EVP_CIPHER_CTX_block_size (&e_ctx);

		seallen = msg_in_buf->length;

		/* for cbc ciphers */
		if (seallen % blocksize)
			seallen += seallen % blocksize;
		else
			seallen += blocksize;

		sealptr = (unsigned char *) malloc (seallen);
		ptr = sealptr;

		for (indatalen = msg_in_buf->length; indatalen >= blocksize;) {
			ret =
			   EVP_EncryptUpdate (&e_ctx, ptr, &sealbuflen,
					      msg_in_buf->value,
					      msg_in_buf->length);
			if (ret != 1) {
				ERR_print_errors_fp (stderr);
				goto err;
			}
			ptr += sealbuflen;
			enclen += sealbuflen;
			if (enclen > seallen) {
				free (sealptr);
				goto err;
			}
			indatalen -= sealbuflen;
			sealbuflen = 0;
		}
		ret = EVP_EncryptFinal (&e_ctx, ptr, &sealbuflen);
		if (ret != 1) {
			ERR_print_errors_fp (stderr);
			goto err;
		}
		enclen += sealbuflen;
		SPKM3_DEBUG (1, ("spkm3_gss_wrap: enclen %d sealbuflen %d\n",
			     enclen, sealbuflen));
/*
			if(enclen != seallen){
				printf("gss_wrap: error on sealbuf len\n");
				free(sealptr);
				goto err;
			}
*/
		*conf_st = 1;	/* TRUE */
		SPKM3_DEBUG (1, ("spkm3_gss_wrap: wrap data len: %d\n",
			     seallen));
	}
	else {			/* return plaintext data */
		seallen = msg_in_buf->length;
		sealptr = msg_in_buf->value;
		*conf_st = 0;	/* FALSE */
	}

	/* Wrap body */
	wbdy = wrap->wrapbody;

	/* place checksum in token */
	if (!ASN1_BIT_STRING_set (wbdy->intcksum, md, MD5_DIGEST_LENGTH)) {
		goto err;
	}

	/* place data in token */
	if (!ASN1_BIT_STRING_set (wbdy->data, sealptr, enclen)) {
		goto err;
	}

	/* calculate the length of the token */
	len = i2d_SPKMInnerContextToken (ict, NULL);

	/* allocate space for the token */
	tlen = g_token_size ((gss_OID) gss_mech_oid_spkm3, len);

	if ((tok = (unsigned char *) malloc (tlen)) == NULL) {
		*min_status = GSS_S_G_MEMORY_ALLOC;
		goto err;
	}

	/* fill in the buffer */
	ptr = tok;
	g_make_token_header ((gss_OID) gss_mech_oid_spkm3, len,
			     &ptr, SPKM_TOK_SEAL_MSG);

	/* encode the request data into tok and advances the ptr */
	len = i2d_SPKMInnerContextToken (ict, &ptr);

	msg_out_buf->length = tlen;
	msg_out_buf->value = (void *) tok;
	SPKM3_DEBUG (1, ("spkm3_gss_wrap token length: %d\n", 
                     msg_out_buf->length));

	SPKMInnerContextToken_free (ict);

	*min_status = 0;
	return GSS_S_COMPLETE;
      err:
	return major_status;
}

#endif /* 0 */

OM_uint32
spkm3_gss_seal (
		       OM_uint32 * min_status,	/* minor_status */
		       gss_ctx_id_t ctx_hndl,	/* context_handle */
		       int flag_conf_req,	/* conf_req_flag */
		       int qop_req,	/* qop_req */
		       gss_buffer_t msg_in_buf,	/* input_message_buffer */
		       int *conf_st,	/* conf_state */
		       gss_buffer_t msg_out_buf	/* output_message_buffer */
   )
{
	return (spkm3_gss_wrap
		(min_status, ctx_hndl, flag_conf_req, qop_req,
		 msg_in_buf, conf_st, msg_out_buf));
}
