/*
 *  spkm3/unseal.c
 *
 *  Copyright (c) 2002,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapi_spkm3.h"

OM_uint32
spkm3_gss_unwrap (
			 OM_uint32 * minor_status,
			 gss_ctx_id_t ctx_hndl,
			 gss_buffer_t msg_in_buf,
			 gss_buffer_t msg_out_buf,
			 int *conf_st, int *qop_state)
{
        SPKM3_DEBUG (1, ("STUB: spkm3_gss_unwrap called\n"));
        *minor_status = 0;
        return GSS_S_FAILURE;
}

#if 0
	OM_uint32 major_status = 0;
	spkm3_context_t *ctx;
	int len, nid, ret;
	unsigned char *ptr = 0, *pp = 0;
	SPKM_WRAP_t *wrap;
	Wrap_Body_t *wbdy;
	SPKMInnerContextToken_t *ict = NULL;
	MD5_CTX md5ctx;
	int hdrlen = 0, cksumlen = 0, decryptlen = 0, indatalen = 0;
	int blocksize = 0, declen = 0;
	unsigned char *cksumptr, *decryptptr;
	unsigned char md[MD5_DIGEST_LENGTH];
	EVP_CIPHER_CTX d_ctx;
	unsigned char iv[EVP_MAX_IV_LENGTH];

	SPKM3_DEBUG (1, ("spkm3_gss_unwrap\n"));
#ifdef USE_KRB_CONTEXT_CACHE
	   /* validate the context handle */
	   if (!kg_validate_ctx_id (ctx_hndl)) {
		*minor_status = (OM_uint32) GSS_S_G_VALIDATE_FAILED;
		major_status = GSS_S_NO_CONTEXT;
		goto err;
	}
#endif

	ctx = (spkm3_context_t *) ctx_hndl;

	if (!ctx->established) {
		*minor_status = GSS_SPKM_S_SG_CTX_INCOMPLETE;
		major_status = GSS_S_NO_CONTEXT;	/* XXX */
		goto err;
	}

	/* check integrity of token */

	/* verify input token header integrity. 
	 * upon return ptr points past token
	 * header, and stores remaining token length in len
	 */

	ptr = (unsigned char *) msg_in_buf->value;
	if ((*minor_status =
	     g_verify_token_header ((gss_OID) gss_mech_oid_spkm3, &len, &ptr,
				    SPKM_TOK_SEAL_MSG, msg_in_buf->length))) {
		goto err;
	}

	/* decode token */
	pp = ptr;
	if ((!d2i_SPKMInnerContextToken (&ict, &pp, (long) len))) {
		*minor_status = GSS_S_DEFECTIVE_TOKEN;
		goto err;
	}

	wrap = ict->d.wrap;
	wbdy = wrap->wrapbody;

	/* token sanity checks */

	if (ASN1_INTEGER_get (wrap->wrapheader->tokid) != SPKM_TOK_SEAL_MSG) {
		spkm3_log_err("spkm3_gss_wrap: Incorrect tokid %ld\n",
			      ASN1_INTEGER_get (wrap->wrapheader->tokid));
		*minor_status = GSS_SPKM_S_SG_INVALID_TOKEN_FORMAT;
		goto err;
	}

	if ((wrap->wrapheader->contextid->length != ctx->ctx_id.length) ||
	    (memcmp (wrap->wrapheader->contextid->data, ctx->ctx_id.data,
		     ctx->ctx_id.length))) {
		*minor_status = GSS_S_G_BAD_MSG_CTX;
		goto err;
	}

	major_status = GSS_S_FAILURE;	/* XXX */

	/* get the algorithms. 
	 * at first, we only support the default QOP.  RFC 2203 states that QOP of 0
	 * means that the QOP default integ/conf/owf algorithm is the first
	 * one on the initiator's int_alg/conf_alg/owf_alg list.
	 * RFC 2847 states the following MANDATORY algs.
	 *
	 * Integrity:
	 *  [0] md5WithRSAEncryption (a change to the spec following RSA licence)
	 *
	 * Confidentiality:
	 *  [0] cast5CBC
	 *
	 * One way function:
	 *  [0] id-sha1
	 *
	 */

	/* must use default algorithm */
	if (!((wrap->wrapheader->intalg == NULL) ||
	      ((nid =
		OBJ_obj2nid (wrap->wrapheader->intalg->algorithm)) ==
#if 0
	       NID_md5))) {
#else
	       NID_hmac_md5))) {
#endif
		spkm3_log_err("gss_unwrap: intalg not md5\n");
		*minor_status = GSS_SPKM_S_SG_BAD_INT_ALG_SET;
		goto err;
	}

/* XXX need to do this.
    if(!((wrap->wrapheader->confalg == NULL) ||
       ((nid = OBJ_obj2nid(wrap->wrapheader->confalg->algid)) == NID_cast5_cbc))) {
        spkm3_log_err("gss_unwrap: confalg not cast5_cbc\n");
        *minor_status = GSS_SPKM_S_SG_BAD_CONF_ALG_SET; 
        goto err;
    }

*/
	/* return an indication of the qop applied */
	*qop_state = 0;

	/* XXX need to check that ctx->intg_alg == wrap->wrapheader->intgalg.. */
	/* XXX need to check that ctx->conf_alg == wrap->wrapheader->confalg.. */


	/* set status for any encryption error XXX */
	*minor_status = GSS_S_G_MEMORY_ALLOC;
	major_status = GSS_S_FAILURE;

	msg_out_buf->length = 0;
	msg_out_buf->value = 0;

	if (conf_st) {
		/* decrypt data */
		memset (iv, '\0', sizeof (iv));
		ret =
		   EVP_DecryptInit (&d_ctx, EVP_cast5_cbc (),
				    ctx->share_key.value, iv);
		if (ret == 0) {
			ERR_print_errors_fp (stderr);
			goto err;
		}
		/* XXX will encrypted length always be more than decrypted plaintext? */
		decryptptr = malloc (wbdy->data->length);
		if (decryptptr == NULL)
			goto err;

		ptr = decryptptr;
		blocksize = EVP_CIPHER_CTX_block_size (&d_ctx);

		for (indatalen = wbdy->data->length; indatalen > blocksize;) {
			ret =
			   EVP_DecryptUpdate (&d_ctx, ptr, &decryptlen,
					      wbdy->data->data, indatalen);
			if (ret == 0) {
				ERR_print_errors_fp (stderr);
				goto err;
			}

			ptr += decryptlen;
			declen += decryptlen;
			if (declen > wbdy->data->length) {
				/* ran out of decryptptr space */
				free (decryptptr);
				goto err;
			}
			indatalen -= decryptlen;
			decryptlen = 0;
		}

		ret = EVP_DecryptFinal (&d_ctx, ptr, &decryptlen);
		if (ret == 0) {
			ERR_print_errors_fp (stderr);
			goto err;
		}
		declen += decryptlen;

		msg_out_buf->length = declen;
		msg_out_buf->value = decryptptr;
		/* return the conf_state applied */
		*conf_st = 1;
	}
	else {
		msg_out_buf->length = wbdy->data->length;
		msg_out_buf->value = wbdy->data->data;
	}

	/* verify the checksum of the message. this assumes md5 */

	if (wrap->wrapbody->intcksum->length != MD5_DIGEST_LENGTH) {
		*minor_status = GSS_S_G_WRONG_SIZE;
		goto err;
	}

	hdrlen = i2d_Wrap_Header (wrap->wrapheader, NULL);
	cksumlen = hdrlen + msg_out_buf->length;
	cksumptr = (unsigned char *) malloc (cksumlen);
	if (cksumptr == NULL)
		goto err;
	ptr = cksumptr;
	i2d_Wrap_Header (wrap->wrapheader, &ptr);
	ptr = cksumptr + hdrlen;
	memcpy (ptr, msg_out_buf->value, msg_out_buf->length);

	MD5_Init (&md5ctx);
	MD5_Update (&md5ctx, cksumptr, (unsigned long) cksumlen);
	MD5_Final (&(md[0]), &md5ctx);
	free (cksumptr);

	if (memcmp
	    (md, wrap->wrapbody->intcksum->data,
	     wrap->wrapbody->intcksum->length)) {
		spkm3_log_err("gss_unwrap: error calculating checksum\n");
		*minor_status = EINVAL;	/* XXX */
		goto err;
	}

	*minor_status = 0;
	return GSS_S_COMPLETE;
      err:
	return major_status;
}

#endif /* 0 */

OM_uint32
spkm3_gss_unseal (
			 OM_uint32 * minor_status,
			 gss_ctx_id_t ctx_hndl,
			 gss_buffer_t msg_in_buf,
			 gss_buffer_t msg_out_buf,
			 int *conf_st, int *qop_state)
{
	return (spkm3_gss_unwrap
		(minor_status, ctx_hndl, msg_in_buf, msg_out_buf,
		 conf_st, qop_state));
}
