/*
 *  spkm3/support.c
 *
 *  Copyright (c) 2001,2004 The Regents of the University of Michigan.
 *  All rights reserved.
 *
 *  Andy Adamson <andros@umich.edu>
 *
 *  Redistribution and use in source and binary forms, with or without
 *  modification, are permitted provided that the following conditions
 *  are met:
 *
 *  1. Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *  2. Redistributions in binary form must reproduce the above copyright
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution.
 *  3. Neither the name of the University nor the names of its
 *     contributors may be used to endorse or promote products derived
 *     from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *  DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 *  FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 *  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 *  BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 *  LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif
#include <stdio.h>
#include <stdlib.h>
#include <sys/time.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>
#include "gssapiP_generic.h"
#include "gssapi_spkm3.h"

OM_uint32
spkm3_process_token (OM_uint32 * major_status,
		     OM_uint32 * minor_status,
		     gss_OID mech_type,
		     OM_uint32 * token_type, gss_ctx_id_t context_handle)
{
	spkm3_context_t *ctx;
	int len;
	unsigned char *ptr = 0;

	SPKM3_DEBUG (1, ("spkm3_gss_verify_mic\n"));
	ctx = (spkm3_context_t *) context_handle;

	/* XXX once i have an spkm3 context cache, need to 
	 * validate the context_handle !*/

	if (!ctx->established) {
		*minor_status = -EINVAL;
		 /*XXX*/ return (GSS_S_NO_CONTEXT);
	}

	/* check integrity of token */

	/* verify input token header integrity. 
	 * upon return ptr points past token
	 * header, and stores remaining token length in len
	 */

	ptr = (unsigned char *) token_buffer->value;
	if ((*minor_status =
	     g_verify_token_header ((gss_OID) gss_mech_oid_spkm3, &len, &ptr,
				    SPKM_TOK_SIGN_MSG,
				    token_buffer->length))) {
		return (GSS_S_DEFECTIVE_TOKEN);
	}

	message_buffer->length = 0;
	message_buffer->value = NULL;

	/* here is where sanity checks on the token should be done... */










}
